/*
 * Decompiled with CFR 0.152.
 */
package net.astah.project.edit.command;

import java.util.Date;
import net.astah.project.Facet;
import net.astah.project.IFacetActivator;
import net.astah.project.Project;
import net.astah.project.ProjectFactory;
import net.astah.project.ProjectPackage;
import net.astah.project.VersionHistory;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class ActivateFacetCommand
extends CompoundCommand {
    IFacetActivator.Registry a = IFacetActivator.Registry.INSTANCE;
    protected EditingDomain domain;
    protected Project owner;
    protected String symbolicName;
    protected String modelProducer;

    public static Facet activate(EditingDomain editingDomain, Project project, String string, String string2) {
        editingDomain.getCommandStack().execute((Command)new ActivateFacetCommand(editingDomain, project, string, string2));
        return project.getFacet(string);
    }

    public ActivateFacetCommand(EditingDomain editingDomain, Project project, String string, String string2) {
        super(Integer.MIN_VALUE, "ActivateFacetCommand", "Activates a project facet");
        this.domain = editingDomain;
        this.owner = project;
        this.symbolicName = string;
        this.modelProducer = string2;
    }

    public EditingDomain getDomain() {
        return this.domain;
    }

    public Project getOwner() {
        return this.owner;
    }

    public String getId() {
        return this.symbolicName;
    }

    protected boolean prepare() {
        if (this.domain == null || this.owner == null) {
            return false;
        }
        if (this.owner.getFacet(this.symbolicName) != null) {
            return false;
        }
        IFacetActivator iFacetActivator = this.a.getActivator(this.symbolicName);
        if (iFacetActivator == null) {
            return false;
        }
        Facet facet = ProjectFactory.eINSTANCE.createFacet();
        facet.setSymbolicName(this.symbolicName);
        Object object = this.a.get((Object)this.symbolicName);
        if (object instanceof IFacetActivator.Descriptor) {
            IFacetActivator.Descriptor descriptor = (IFacetActivator.Descriptor)object;
            facet.setName(descriptor.getName());
            VersionHistory versionHistory = ProjectFactory.eINSTANCE.createVersionHistory();
            versionHistory.setModelProducer(this.modelProducer);
            versionHistory.setModelVersion(descriptor.getVersion());
            versionHistory.setLastModified(new Date());
            facet.getVersionHistories().add((Object)versionHistory);
        }
        this.append(AddCommand.create((EditingDomain)this.domain, (Object)this.owner, (Object)ProjectPackage.Literals.PROJECT__FACETS, (Object)facet));
        this.appendIfCanExecute(iFacetActivator.activate(this.domain, this.owner, facet));
        return super.prepare();
    }
}

