/*
 * Decompiled with CFR 0.152.
 */
package net.astah.table.edit.provider;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.astah.table.Element;
import net.astah.table.Grid;
import net.astah.table.TablePackage;
import net.astah.table.Tuple;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class GridObserver
extends EContentAdapter {
    protected final Map<Object, Set<Element>> index = Maps.newIdentityHashMap();

    public static IDisposable observe(Grid grid, IChangeNotifier iChangeNotifier) {
        GridObserver gridObserver = GridObserver.getGridObserver((EObject)grid, true);
        ((Object)((Object)gridObserver)).getClass();
        return gridObserver.new a(iChangeNotifier);
    }

    public static GridObserver getGridObserver(EObject eObject) {
        return GridObserver.getGridObserver(eObject, false);
    }

    public static GridObserver getGridObserver(EObject eObject, boolean bl) {
        EList eList = eObject.eAdapters();
        Adapter adapter = EcoreUtil.getAdapter((List)eList, GridObserver.class);
        if (adapter instanceof GridObserver) {
            return (GridObserver)adapter;
        }
        if (bl) {
            GridObserver gridObserver = new GridObserver();
            eList.add((Object)gridObserver);
            return gridObserver;
        }
        return null;
    }

    public Collection<Element> getElements(Object object) {
        Set<Element> set = this.index.get(object);
        return set != null ? Collections.unmodifiableSet(set) : Collections.emptySet();
    }

    public boolean isAdapterForType(Object object) {
        return object == GridObserver.class;
    }

    protected void addAdapter(Notifier notifier) {
        if (notifier instanceof Tuple) {
            super.addAdapter(notifier);
        } else if (notifier instanceof Element) {
            super.addAdapter(notifier);
            Element element = (Element)notifier;
            EObject eObject = element.getObject();
            if (eObject != null) {
                this.registerObject(element, eObject);
            }
        }
    }

    protected void removeAdapter(Notifier notifier) {
        Element element;
        EObject eObject;
        super.removeAdapter(notifier);
        if (notifier instanceof Element && (eObject = (element = (Element)notifier).getObject()) != null) {
            this.unregisterObject(element, eObject);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void selfAdapt(Notification notification) {
        super.selfAdapt(notification);
        Object object = notification.getNotifier();
        if (notification.isTouch() || !(object instanceof Element)) return;
        switch (notification.getFeatureID(Element.class)) {
            case 0: {
                switch (notification.getEventType()) {
                    case 1: 
                    case 2: {
                        Object object2;
                        Element element = (Element)object;
                        Object object3 = notification.getOldValue();
                        if (object3 instanceof EObject) {
                            this.unregisterObject(element, (EObject)object3);
                        }
                        if (!((object2 = notification.getNewValue()) instanceof EObject)) return;
                        this.registerObject(element, (EObject)object2);
                    }
                }
                return;
            }
        }
    }

    protected void registerObject(Element element, EObject eObject) {
        Set set = this.index.computeIfAbsent(eObject, object -> Sets.newIdentityHashSet());
        set.add(element);
    }

    protected void unregisterObject(Element element, EObject eObject) {
        Set<Element> set = this.index.get(eObject);
        if (set != null && set.remove(element) && set.isEmpty()) {
            this.index.remove(eObject);
        }
    }

    protected void objectChanged(IChangeNotifier iChangeNotifier, IViewerNotification iViewerNotification, Object object) {
        Set<Element> set = this.index.get(object);
        if (set != null) {
            for (Element element : Lists.newArrayList(set)) {
                switch (iViewerNotification.getEventType()) {
                    case 4: 
                    case 6: {
                        if (element.getObject() != object) break;
                        element.setObject(null);
                    }
                }
                this.elementChanged(iChangeNotifier, iViewerNotification, element);
            }
        }
    }

    protected void elementChanged(IChangeNotifier iChangeNotifier, IViewerNotification iViewerNotification, Element element) {
        Tuple tuple = element.getTuple();
        if (tuple != null) {
            this.tupleChanged(iChangeNotifier, iViewerNotification, tuple);
        }
    }

    protected void tupleChanged(IChangeNotifier iChangeNotifier, IViewerNotification iViewerNotification, Tuple tuple) {
        EReference eReference = tuple.eContainmentFeature();
        if (eReference == TablePackage.Literals.GRID__ROW_TUPLE) {
            this.rowTupleChanged(iChangeNotifier, iViewerNotification, tuple);
        } else if (eReference == TablePackage.Literals.GRID__COLUMN_TUPLE) {
            this.columnTupleChanged(iChangeNotifier, iViewerNotification, tuple);
        }
    }

    protected void columnTupleChanged(IChangeNotifier iChangeNotifier, IViewerNotification iViewerNotification, Tuple tuple) {
        Grid grid = (Grid)tuple.eContainer();
        iChangeNotifier.fireNotifyChanged((Notification)new ViewerNotification((Notification)iViewerNotification, (Object)grid, true, true));
    }

    protected void rowTupleChanged(IChangeNotifier iChangeNotifier, IViewerNotification iViewerNotification, Tuple tuple) {
        if (iViewerNotification.getElement() == tuple) {
            return;
        }
        iChangeNotifier.fireNotifyChanged((Notification)new ViewerNotification((Notification)iViewerNotification, (Object)tuple, false, true));
    }

    class a
    implements IDisposable,
    INotifyChangedListener {
        final IChangeNotifier a;

        a(IChangeNotifier iChangeNotifier) {
            iChangeNotifier.addListener((INotifyChangedListener)this);
            this.a = iChangeNotifier;
        }

        public void dispose() {
            this.a.removeListener((INotifyChangedListener)this);
        }

        public void notifyChanged(Notification notification) {
            if (notification instanceof IViewerNotification) {
                IViewerNotification iViewerNotification = (IViewerNotification)notification;
                if (iViewerNotification.isLabelUpdate()) {
                    this.a(iViewerNotification);
                }
                if (iViewerNotification.isContentRefresh()) {
                    this.b(iViewerNotification);
                }
            }
        }

        protected void a(IViewerNotification iViewerNotification) {
            Object object = iViewerNotification.getElement();
            if (object instanceof Tuple) {
                GridObserver.this.tupleChanged(this.a, iViewerNotification, (Tuple)object);
            } else if (object instanceof Element) {
                GridObserver.this.elementChanged(this.a, iViewerNotification, (Element)object);
            } else {
                GridObserver.this.objectChanged(this.a, iViewerNotification, object);
            }
        }

        protected void b(IViewerNotification iViewerNotification) {
            switch (iViewerNotification.getEventType()) {
                case 4: {
                    GridObserver.this.objectChanged(this.a, iViewerNotification, iViewerNotification.getOldValue());
                    break;
                }
                case 6: {
                    for (Object e : (List)iViewerNotification.getOldValue()) {
                        GridObserver.this.objectChanged(this.a, iViewerNotification, e);
                    }
                    break;
                }
            }
        }
    }
}

