/*
 * Decompiled with CFR 0.152.
 */
package net.astah.table.edit.provider;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.astah.emf.edit.command.Commands;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.table.Dataset;
import net.astah.table.Grid;
import net.astah.table.Tuple;
import net.astah.table.edit.command.AddRowCommand;
import net.astah.table.edit.command.DeleteRowCommand;
import net.astah.table.edit.command.DeleteTupleElementCommand;
import net.astah.table.edit.provider.GenericTableItemProviderDecorator;
import net.astah.table.engine.impl.DatasetEngineAdapter;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;

public class GridItemProviderDecorator
extends GenericTableItemProviderDecorator {
    public GridItemProviderDecorator(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Collection<?> getChildren(Object object) {
        Grid grid = (Grid)object;
        return grid.getRowTuples();
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        return Collections.emptyList();
    }

    public Command createCommand(Object object, EditingDomain editingDomain, Class<? extends Command> clazz, CommandParameter commandParameter) {
        if (clazz == AddRowCommand.class) {
            return this.createAddRowCommand(editingDomain, commandParameter.getEOwner(), commandParameter.getCollection(), commandParameter.getIndex());
        }
        if (clazz == DeleteRowCommand.class) {
            return this.createDeleteRowCommand(editingDomain, commandParameter.getEOwner(), commandParameter.getCollection());
        }
        if (clazz == DeleteTupleElementCommand.class) {
            return this.createDeleteTupleElementCommand(editingDomain, commandParameter.getEOwner(), commandParameter.getCollection(), commandParameter.getIndex());
        }
        Command command = super.createCommand(object, editingDomain, clazz, commandParameter);
        if (clazz == MoveCommand.class && commandParameter.getValue() instanceof Tuple) {
            return command.chain(this.createMoveRowElementCommand(commandParameter.getEOwner(), (Tuple)commandParameter.getValue(), commandParameter.getIndex(), editingDomain));
        }
        return command;
    }

    protected Command createAddRowCommand(EditingDomain editingDomain, EObject eObject, Collection<?> collection, int n) {
        AddRowCommand addRowCommand = new AddRowCommand(editingDomain, eObject, collection, n);
        if (collection != null && !collection.isEmpty()) {
            addRowCommand = Commands.chain((Command)addRowCommand, (Command)this.createPrepareRowTupleCommand((Grid)eObject, collection, n, editingDomain));
        }
        return addRowCommand;
    }

    protected Command createDeleteRowCommand(EditingDomain editingDomain, EObject eObject, Collection<?> collection) {
        DeleteRowCommand deleteRowCommand = new DeleteRowCommand(editingDomain, eObject, collection);
        if (collection != null && !collection.isEmpty()) {
            deleteRowCommand = Commands.chain((Command)deleteRowCommand, (Command)this.createDestroyTupleElementCommand(collection, editingDomain));
        }
        return deleteRowCommand;
    }

    protected Command createDeleteTupleElementCommand(EditingDomain editingDomain, EObject eObject, Collection<?> collection, int n) {
        return new DeleteTupleElementCommand(editingDomain, eObject, collection, n);
    }

    protected Command createPrepareRowTupleCommand(Grid grid, Collection<?> collection, int n, EditingDomain editingDomain) {
        CompoundCommand compoundCommand = new CompoundCommand();
        for (Tuple tuple : Iterables.filter(collection, Tuple.class)) {
            Command command = this.createPrepareRowTupleCommand(grid, tuple, editingDomain);
            if (command == IdentityCommand.INSTANCE) continue;
            compoundCommand.append(command);
        }
        return compoundCommand.isEmpty() ? IdentityCommand.INSTANCE : compoundCommand.unwrap();
    }

    protected Command createPrepareRowTupleCommand(Grid grid, Tuple tuple, EditingDomain editingDomain) {
        return UnexecutableCommand.INSTANCE;
    }

    protected Command createDestroyTupleElementCommand(Collection<?> collection, EditingDomain editingDomain) {
        Set<EObject> set = this.getDistinguishableElements(collection);
        return this.createDestroyCommand(set, editingDomain);
    }

    protected Command createMoveRowElementCommand(EObject eObject, Tuple tuple, int n, EditingDomain editingDomain) {
        return UnexecutableCommand.INSTANCE;
    }

    protected Set<EObject> getDistinguishableElements(Collection<?> collection) {
        LinkedHashSet<EObject> linkedHashSet = new LinkedHashSet<EObject>();
        for (Tuple tuple : Iterables.filter(collection, Tuple.class)) {
            Dataset dataset = tuple.getDataset();
            Iterables.addAll(linkedHashSet, (Iterable)DatasetEngineAdapter.getDistinguishableElements((AdapterFactory)this.adapterFactory, (Object)dataset, (Tuple)tuple));
        }
        return linkedHashSet;
    }

    protected Command createDestroyCommand(Collection<?> collection, EditingDomain editingDomain) {
        return this.groupingDomain(collection, editingDomain).entrySet().stream().map(entry -> DestroyCommand.create((EditingDomain)((EditingDomain)entry.getKey()), (Collection)((Collection)entry.getValue()))).reduce(Command::chain).orElse((Command)UnexecutableCommand.INSTANCE);
    }

    protected <T> Map<EditingDomain, List<T>> groupingDomain(Collection<T> collection, EditingDomain editingDomain) {
        return collection.stream().collect(Collectors.groupingBy(object -> (EditingDomain)MoreObjects.firstNonNull((Object)AdapterFactoryEditingDomain.getEditingDomainFor((Object)object), (Object)editingDomain)));
    }
}

