/*
 * Decompiled with CFR 0.152.
 */
package net.astah.table.edit.domain;

import lombok.NonNull;
import net.astah.table.Grid;
import net.astah.table.edit.command.RefreshGridCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class GridRefresher
extends ResourceSetListenerImpl
implements IDisposable {
    protected final TransactionalEditingDomain domain;
    protected final Grid grid;

    public GridRefresher(@NonNull TransactionalEditingDomain transactionalEditingDomain, @NonNull Grid grid) {
        if (transactionalEditingDomain == null) {
            throw new NullPointerException("domain");
        }
        if (grid == null) {
            throw new NullPointerException("grid");
        }
        this.domain = transactionalEditingDomain;
        this.grid = grid;
        transactionalEditingDomain.addResourceSetListener((ResourceSetListener)this);
    }

    public void dispose() {
        if (this.domain != null) {
            this.domain.removeResourceSetListener((ResourceSetListener)this);
        }
    }

    public boolean isPrecommitOnly() {
        return TransactionUtil.getEditingDomain((EObject)this.grid) == this.domain;
    }

    public boolean isPostcommitOnly() {
        return TransactionUtil.getEditingDomain((EObject)this.grid) != this.domain;
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent resourceSetChangeEvent) throws RollbackException {
        Command command = this.createRefreshGridCommand();
        if (command.canExecute()) {
            return command;
        }
        command.dispose();
        return null;
    }

    public void resourceSetChanged(ResourceSetChangeEvent resourceSetChangeEvent) {
        Command command = this.createRefreshGridCommand();
        if (command.canExecute()) {
            command.execute();
        }
        command.dispose();
    }

    protected Command createRefreshGridCommand() {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.grid);
        return new RefreshGridCommand(editingDomain, (EObject)this.grid);
    }
}

