/*
 * Decompiled with CFR 0.152.
 */
package net.astah.table.edit.command;

import com.google.common.base.Equivalence;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.table.Dataset;
import net.astah.table.Grid;
import net.astah.table.Table;
import net.astah.table.TablePackage;
import net.astah.table.Tuple;
import net.astah.table.edit.command.TableCommand;
import net.astah.table.edit.command.a;
import net.astah.table.engine.IEngineTable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class RefreshGridCommand
extends CompoundCommand
implements TableCommand {
    protected EditingDomain domain;
    protected EObject owner;
    protected Object value;

    public static Command create(EditingDomain editingDomain, Grid grid) {
        return RefreshGridCommand.create(editingDomain, grid, grid.getTable());
    }

    public static Command create(EditingDomain editingDomain, Grid grid, Table table) {
        CommandParameter commandParameter = new CommandParameter((Object)table, (Object)grid, null);
        return editingDomain.createCommand(RefreshGridCommand.class, commandParameter);
    }

    public RefreshGridCommand(EditingDomain editingDomain, EObject eObject) {
        this(editingDomain, eObject, null);
    }

    public RefreshGridCommand(EditingDomain editingDomain, EObject eObject, Object object) {
        super("RefreshGridCommand", "Refresh the grid model with re-executing queries");
        this.domain = editingDomain;
        this.owner = eObject;
        this.value = object;
    }

    protected void createRefreshCommands(Grid grid, Table table, IEngineTable iEngineTable) {
        if (grid.getTable() != table) {
            this.append((Command)new SetCommand(this.domain, (EObject)grid, (EStructuralFeature)TablePackage.Literals.GRID__TABLE, (Object)table));
        }
        EList eList = grid.getRowTuples();
        EList eList2 = grid.getColumnTuples();
        this.refreshTuples((EList<Tuple>)eList, table, (List<Dataset>)table.getRows(), iEngineTable);
        this.refreshTuples((EList<Tuple>)eList2, table, (List<Dataset>)table.getColumns(), iEngineTable);
    }

    @Override
    public EditingDomain getDomain() {
        return this.domain;
    }

    @Override
    public EObject getOwner() {
        return this.owner;
    }

    public Object getValue() {
        return this.value;
    }

    protected boolean prepare() {
        Table table;
        if (this.domain == null || !(this.owner instanceof Grid)) {
            return false;
        }
        Grid grid = (Grid)this.owner;
        Table table2 = table = this.value instanceof Table ? (Table)this.value : grid.getTable();
        if (table == null) {
            return false;
        }
        AdapterFactory adapterFactory = ItemProviders.getAdapterFactory((EditingDomain)this.domain);
        IEngineTable iEngineTable = (IEngineTable)ItemProviders.adapt((AdapterFactory)adapterFactory, (Notifier)table, IEngineTable.class);
        if (iEngineTable == null) {
            return false;
        }
        this.createRefreshCommands(grid, table, iEngineTable);
        return super.prepare();
    }

    protected void refreshTuples(EList<Tuple> eList, Table table, List<Dataset> list, IEngineTable iEngineTable) {
        Iterable iterable = iEngineTable.generateTuples((Object)table, list);
        if (eList.isEmpty()) {
            this.appendIfCanExecute((Command)new AddCommand(this.domain, eList, (Collection)Lists.newArrayList((Iterable)iterable)));
        } else {
            Equivalence equivalence = iEngineTable.getTupleEquivalence((Object)table);
            this.appendIfCanExecute((Command)new a(this, this.domain, eList, iterable, equivalence));
        }
    }
}

