/*
 * Decompiled with CFR 0.152.
 */
package net.astah.table.edit.command;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.table.Dataset;
import net.astah.table.Tuple;
import net.astah.table.edit.command.TableCommand;
import net.astah.table.engine.impl.DatasetEngineAdapter;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;

public class DeleteTupleElementCommand
extends CompoundCommand
implements TableCommand {
    protected EditingDomain domain;
    protected EObject owner;
    protected Collection<?> collection;
    protected int index;

    public static Command create(EditingDomain editingDomain, Object object, Object object2, int n) {
        return DeleteTupleElementCommand.create(editingDomain, object, Collections.singleton(object2), n);
    }

    public static Command create(EditingDomain editingDomain, Object object, Collection<?> collection, int n) {
        return editingDomain.createCommand(DeleteTupleElementCommand.class, new CommandParameter(object, null, collection, n));
    }

    public DeleteTupleElementCommand(EditingDomain editingDomain, EObject eObject, Object object, int n) {
        this(editingDomain, eObject, Collections.singleton(object), n);
    }

    public DeleteTupleElementCommand(EditingDomain editingDomain, EObject eObject, Collection<?> collection, int n) {
        super("DeleteTupleElementCommand", "Delete tuple element model");
        this.domain = editingDomain;
        this.owner = eObject;
        this.collection = collection;
        this.index = n;
    }

    @Override
    public EditingDomain getDomain() {
        return this.domain;
    }

    @Override
    public EObject getOwner() {
        return this.owner;
    }

    public Collection<?> getCollection() {
        return this.collection;
    }

    public int getIndex() {
        return this.index;
    }

    protected boolean prepare() {
        if (this.collection == null || this.collection.isEmpty()) {
            return false;
        }
        AdapterFactory adapterFactory = ItemProviders.getAdapterFactory((EditingDomain)this.domain);
        for (Tuple tuple : Iterables.filter(this.collection, Tuple.class)) {
            Dataset dataset = tuple.getDataset();
            this.append(DatasetEngineAdapter.createDeleteTupleElementCommand((AdapterFactory)adapterFactory, (EditingDomain)this.domain, (Object)dataset, (Tuple)tuple, (int)this.index));
        }
        return super.prepare();
    }
}

