/*
 * Decompiled with CFR 0.152.
 */
package net.astah.table.edit.command;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import net.astah.table.Dataset;
import net.astah.table.Grid;
import net.astah.table.TableFactory;
import net.astah.table.TablePackage;
import net.astah.table.Tuple;
import net.astah.table.edit.command.TableCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;

public class AddRowCommand
extends CommandWrapper
implements TableCommand {
    protected EditingDomain domain;
    protected EObject owner;
    protected Collection<?> collection;
    protected int index;

    public static Command create(EditingDomain editingDomain, Object object, Object object2) {
        return AddRowCommand.create(editingDomain, object, Collections.singleton(object2), -1);
    }

    public static Command create(EditingDomain editingDomain, Object object, Object object2, int n) {
        return AddRowCommand.create(editingDomain, object, Collections.singleton(object2), n);
    }

    public static Command create(EditingDomain editingDomain, Object object, Collection<?> collection) {
        return AddRowCommand.create(editingDomain, object, collection, -1);
    }

    public static Command create(EditingDomain editingDomain, Object object, Collection<?> collection, int n) {
        return editingDomain.createCommand(AddRowCommand.class, new CommandParameter(object, null, collection, n));
    }

    public AddRowCommand(EditingDomain editingDomain, EObject eObject, Object object) {
        this(editingDomain, eObject, Collections.singleton(object), -1);
    }

    public AddRowCommand(EditingDomain editingDomain, EObject eObject, Object object, int n) {
        this(editingDomain, eObject, Collections.singleton(object), n);
    }

    public AddRowCommand(EditingDomain editingDomain, EObject eObject, Collection<?> collection) {
        this(editingDomain, eObject, collection, -1);
    }

    public AddRowCommand(EditingDomain editingDomain, EObject eObject, Collection<?> collection, int n) {
        super("AddRowCommand", "Add new row to grid model");
        this.domain = editingDomain;
        this.owner = eObject;
        this.collection = collection;
        this.index = n;
    }

    public static Tuple prepareNewTuple(Grid grid, int n) {
        Tuple tuple = TableFactory.eINSTANCE.createTuple();
        EList eList = grid.getRowTuples();
        if (n >= 0 && n < eList.size()) {
            tuple.setDataset(((Tuple)eList.get(n)).getDataset());
        } else {
            EList eList2 = grid.getTable().getRows();
            tuple.setDataset((Dataset)Iterables.getFirst((Iterable)eList2, null));
        }
        int n2 = grid.getTable().getRowTupleTypes().size();
        EList eList3 = tuple.getElements();
        while (eList3.size() < n2) {
            eList3.add((Object)TableFactory.eINSTANCE.createElement());
        }
        return tuple;
    }

    @Override
    public EditingDomain getDomain() {
        return this.domain;
    }

    @Override
    public EObject getOwner() {
        return this.owner;
    }

    public Collection<?> getCollection() {
        return this.collection;
    }

    public int getIndex() {
        return this.index;
    }

    protected Command createCommand() {
        return AddCommand.create((EditingDomain)this.domain, (Object)this.owner, (Object)TablePackage.Literals.GRID__ROW_TUPLE, this.collection, (int)this.index);
    }
}

