/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.view.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.TransferHandler;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.astah.dd.di.Diagram;
import net.astah.emf.common.notify.EFeaturePath;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.emf.edit.provider.swing.JTableBuilder;
import net.astah.golf.model.EntityStoreEvent;
import net.astah.golf.view.swing.ITableColumnProvider;
import net.astah.golf.widget.CJComponent;
import net.astah.golf.widget.IListSelection;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.ITableSelection;
import net.astah.golf.widget.TableSelection;
import net.astah.golf.widget.swing.GenericTable;
import net.astah.golf.widget.swing.Selections;
import net.astah.golf.widget.swing.SwingIconRegistry;
import net.astah.notation.TableView;
import net.astah.stpa.stamp.ControlAction;
import net.astah.stpa.stamp.STAMPPackage;
import net.astah.stpa.stamp.UCAAnalysis;
import net.astah.stpa.stamp.UCAGuideWordSet;
import net.astah.stpa.stamp.notation.UCATable;
import net.astah.stpa.stamp.ui.Messages;
import net.astah.stpa.stamp.ui.menu.handler.JumpToDiagramElementHandler;
import net.astah.stpa.stamp.ui.table.UCAAnalysisResultCellEvaluator;
import net.astah.stpa.stamp.ui.table.UcaTableColumnProvider;
import net.astah.stpa.stamp.ui.view.swing.STPATableEditorPeer;
import net.astah.table.CellDescriptor;
import net.astah.table.DataQuery;
import net.astah.table.DynamicDataset;
import net.astah.table.ElementSet;
import net.astah.table.FeaturePath;
import net.astah.table.FixedDataset;
import net.astah.table.Grid;
import net.astah.table.IQueryExecutor;
import net.astah.table.JoinReference;
import net.astah.table.JoinType;
import net.astah.table.NativeCellDescriptor;
import net.astah.table.NativeDataQuery;
import net.astah.table.ObjectDataQuery;
import net.astah.table.ObjectElement;
import net.astah.table.PropertyCellDescriptor;
import net.astah.table.PseudoCellDescriptor;
import net.astah.table.Table;
import net.astah.table.TableFactory;
import net.astah.table.Tuple;
import net.astah.table.edit.provider.GenericTableAdapterFactory;
import net.astah.table.edit.provider.GridItemProviderDecorator;
import net.astah.table.ui.swing.GenericTableTableTransferHandler;
import net.astah.ui.menu.annotation.Context;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemProviderDecorator;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

@Context(id="net.astah.stpa.stamp.notation.UCATable", classes={JumpToDiagramElementHandler.class})
public class UCATableEditorPeer
extends STPATableEditorPeer {
    public static final String ANNOTATION__UCA_TABLE = "ucaTable";
    public static final int NUMBER_COLUMN_WIDTH = 35;
    public static final int UCA_ANALYSIS_TUPLE_ELEMENT_INDEX = 3;
    public static final int GUIDEWORD_TUPLE_ELEMENT_INDEX = 0;
    public static final int CONTROL_ACTION_TUPLE_ELEMENT_INDEX = 0;
    private JPanel warnPanel;

    @Override
    public void initialize(Diagram diagram, CJComponent parent) {
        super.initialize(diagram, parent);
        JTable table = (JTable)this.getTable().getComponent();
        table.setSelectionMode(0);
        table.setCellSelectionEnabled(true);
        table.getColumnModel().getColumn(0).setMinWidth(SwingIconRegistry.scaleValue((int)35));
        table.getColumnModel().getColumn(0).setMaxWidth(SwingIconRegistry.scaleValue((int)35));
    }

    public UCATable getDiagram() {
        return (UCATable)super.getDiagram();
    }

    protected Container createNorthPanel() {
        Container panel = super.createNorthPanel();
        panel.add(this.createWarnPanel(), 0);
        this.updateWarnPanel();
        return panel;
    }

    public void update(EntityStoreEvent e) {
        super.update(e);
        this.updateWarnPanel();
    }

    private Component createWarnPanel() {
        this.warnPanel = new JPanel();
        this.warnPanel.setLayout(new BoxLayout(this.warnPanel, 1));
        this.warnPanel.setBorder(new CompoundBorder(this.warnPanel.getBorder(), new EmptyBorder(10, 10, 0, 0)));
        JTextArea warnLabel = new JTextArea();
        warnLabel.setText(Messages.uca_table_ca_none_warning);
        warnLabel.setForeground(Color.RED);
        warnLabel.setOpaque(false);
        warnLabel.setEditable(false);
        warnLabel.setFocusable(false);
        warnLabel.setLineWrap(true);
        warnLabel.setFont(null);
        this.warnPanel.add(warnLabel);
        this.warnPanel.setVisible(false);
        return this.warnPanel;
    }

    private void updateWarnPanel() {
        this.warnPanel.setVisible(this.getDiagram().getControlActions().isEmpty());
    }

    protected Table prepareTableModel(TableView view) {
        UCATable ucaTable = (UCATable)view;
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        annotation.setSource(ANNOTATION__UCA_TABLE);
        annotation.getReferences().add((Object)ucaTable);
        NativeDataQuery row0 = TableFactory.eINSTANCE.createNativeDataQuery();
        row0.getEAnnotations().add((Object)annotation);
        row0.setImplementationClass(ControlActionFactory.class);
        row0.setMetaclass(STAMPPackage.Literals.CONTROL_ACTION);
        JoinReference row1 = TableFactory.eINSTANCE.createJoinReference();
        UCATableEditorPeer.applyFeaturePath((FeaturePath)row1, (EFeaturePath)EFeaturePath.build((EStructuralFeature[])new EStructuralFeature[]{STAMPPackage.Literals.SIGNAL__LINK, STAMPPackage.Literals.LINK__SOURCE}));
        row1.setJoinType(JoinType.INNER);
        row1.setOrigin((DataQuery)row0);
        JoinReference row2 = TableFactory.eINSTANCE.createJoinReference();
        UCATableEditorPeer.applyFeaturePath((FeaturePath)row2, (EFeaturePath)EFeaturePath.build((EStructuralFeature[])new EStructuralFeature[]{STAMPPackage.Literals.SIGNAL__LINK, STAMPPackage.Literals.LINK__TARGET}));
        row2.setJoinType(JoinType.INNER);
        row2.setOrigin((DataQuery)row0);
        ObjectDataQuery row3 = TableFactory.eINSTANCE.createObjectDataQuery();
        row3.getObjects().add((Object)ucaTable.getAnalysis());
        row3.setMetaclass(STAMPPackage.Literals.UCA_ANALYSIS);
        DynamicDataset row = TableFactory.eINSTANCE.createDynamicDataset();
        row.getQueries().addAll(Arrays.asList(row0, row1, row2, row3));
        ObjectElement columnIdx = TableFactory.eINSTANCE.createObjectElement();
        columnIdx.setHeader(TableFactory.eINSTANCE.createFixedCellDescriptor(Messages.uca_table_no_label));
        PseudoCellDescriptor columnIdxCell = TableFactory.eINSTANCE.createPseudoCellDescriptor();
        columnIdx.setCell((CellDescriptor)columnIdxCell);
        ObjectElement columnCA = TableFactory.eINSTANCE.createObjectElement();
        columnCA.setHeader(TableFactory.eINSTANCE.createFixedCellDescriptor(Messages.uca_table_ca_label));
        PropertyCellDescriptor columnCACell = TableFactory.eINSTANCE.createPropertyCellDescriptor();
        columnCACell.setOrigin(row.getQueries().indexOf((Object)row0));
        UCATableEditorPeer.applyFeaturePath((FeaturePath)columnCACell, (EFeaturePath)EFeaturePath.build((EStructuralFeature)STAMPPackage.Literals.NAMED_ELEMENT__NAME));
        columnCACell.setLineWrap(true);
        columnCA.setCell((CellDescriptor)columnCACell);
        ObjectElement columnFrom = TableFactory.eINSTANCE.createObjectElement();
        columnFrom.setHeader(TableFactory.eINSTANCE.createFixedCellDescriptor(Messages.uca_table_ca_from_label));
        PropertyCellDescriptor columnFromCell = TableFactory.eINSTANCE.createPropertyCellDescriptor();
        columnFromCell.setOrigin(row.getQueries().indexOf((Object)row1));
        UCATableEditorPeer.applyFeaturePath((FeaturePath)columnFromCell, (EFeaturePath)EFeaturePath.build((EStructuralFeature)STAMPPackage.Literals.NAMED_ELEMENT__NAME));
        columnFromCell.setLineWrap(true);
        columnFrom.setCell((CellDescriptor)columnFromCell);
        ObjectElement columnTo = TableFactory.eINSTANCE.createObjectElement();
        columnTo.setHeader(TableFactory.eINSTANCE.createFixedCellDescriptor(Messages.uca_table_ca_to_label));
        PropertyCellDescriptor columnToCell = TableFactory.eINSTANCE.createPropertyCellDescriptor();
        columnToCell.setOrigin(row.getQueries().indexOf((Object)row2));
        UCATableEditorPeer.applyFeaturePath((FeaturePath)columnToCell, (EFeaturePath)EFeaturePath.build((EStructuralFeature)STAMPPackage.Literals.NAMED_ELEMENT__NAME));
        columnToCell.setLineWrap(true);
        columnTo.setCell((CellDescriptor)columnToCell);
        ObjectElement columnCondition = TableFactory.eINSTANCE.createObjectElement();
        columnCondition.setHeader(TableFactory.eINSTANCE.createFixedCellDescriptor(Messages.uca_table_ca_providing_condition_label));
        PropertyCellDescriptor columnConditionCell = TableFactory.eINSTANCE.createPropertyCellDescriptor();
        columnConditionCell.setOrigin(row.getQueries().indexOf((Object)row0));
        UCATableEditorPeer.applyFeaturePath((FeaturePath)columnConditionCell, (EFeaturePath)EFeaturePath.build((EStructuralFeature)STAMPPackage.Literals.SIGNAL__PROVIDING_CONDITION));
        columnConditionCell.setLineWrap(true);
        columnCondition.setCell((CellDescriptor)columnConditionCell);
        UCAAnalysis analysis = ucaTable.getAnalysis();
        UCAGuideWordSet guideWordSet = analysis.getGuideWordSet();
        ObjectDataQuery guideWordQuery = TableFactory.eINSTANCE.createObjectDataQuery();
        guideWordQuery.getObjects().add((Object)guideWordSet);
        guideWordQuery.setMetaclass(STAMPPackage.Literals.UCA_GUIDE_WORD);
        guideWordQuery.setTraversal(true);
        DynamicDataset rowGuideWord = TableFactory.eINSTANCE.createDynamicDataset();
        rowGuideWord.getQueries().addAll(Arrays.asList(guideWordQuery));
        PropertyCellDescriptor guideWordCellDescriptor = TableFactory.eINSTANCE.createPropertyCellDescriptor();
        guideWordCellDescriptor.setOrigin(rowGuideWord.getQueries().indexOf((Object)guideWordQuery));
        UCATableEditorPeer.applyFeaturePath((FeaturePath)guideWordCellDescriptor, (EFeaturePath)EFeaturePath.build((EStructuralFeature)STAMPPackage.Literals.NAMED_ELEMENT__NAME));
        guideWordCellDescriptor.setLineWrap(true);
        rowGuideWord.getHeaders().add((Object)guideWordCellDescriptor);
        NativeCellDescriptor ucaAnalysisResultCellDescriptor = TableFactory.eINSTANCE.createNativeCellDescriptor();
        ucaAnalysisResultCellDescriptor.setImplementationClass(UCAAnalysisResultCellEvaluator.class);
        rowGuideWord.getCells().add((Object)ucaAnalysisResultCellDescriptor);
        ElementSet columnSet = TableFactory.eINSTANCE.createElementSet();
        columnSet.getElements().addAll(Arrays.asList(columnIdx, columnCA, columnFrom, columnTo, columnCondition));
        FixedDataset column = TableFactory.eINSTANCE.createFixedDataset();
        column.getElementSets().add((Object)columnSet);
        Table table = TableFactory.eINSTANCE.createTable();
        table.getColumns().add((Object)column);
        table.getColumns().add((Object)rowGuideWord);
        table.getRows().add((Object)row);
        return table;
    }

    protected AdapterFactory createTableAdapterFactory() {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.getDiagram());
        return new GenericTableAdapterFactory(ItemProviders.getAdapterFactory((EditingDomain)domain)){

            protected IItemProviderDecorator createGridDecorator() {
                return new GridItemProviderDecorator((AdapterFactory)this){

                    protected Command createMoveRowElementCommand(EObject owner, Tuple tuple, int index, EditingDomain defaultDomain) {
                        return this.createMoveControlActionCommand(owner, tuple, index, defaultDomain);
                    }
                };
            }

            protected Command createMoveControlActionCommand(EObject owner, Tuple tuple, int index, EditingDomain defaultDomain) {
                UCAAnalysis ucaAnalysis;
                Tuple targetTuple = (Tuple)UCATableEditorPeer.this.grid.getRowTuples().get(index);
                ControlAction target = (ControlAction)targetTuple.getElementObject(0);
                UCATable ucaTable = this.getUCATable();
                UCAAnalysis uCAAnalysis = ucaAnalysis = ucaTable != null ? ucaTable.getAnalysis() : null;
                if (ucaAnalysis == null) {
                    return IdentityCommand.INSTANCE;
                }
                int targetIndex = ucaAnalysis.getControlActions().indexOf((Object)target);
                EObject value = tuple.getElementObject(0);
                return MoveCommand.create((EditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)ucaAnalysis), (Object)ucaAnalysis, (Object)STAMPPackage.Literals.UCA_ANALYSIS__CONTROL_ACTION, (Object)value, (int)targetIndex);
            }

            private UCATable getUCATable() {
                UCATable diagram = UCATableEditorPeer.this.getDiagram();
                if (diagram != null && diagram instanceof UCATable) {
                    return diagram;
                }
                return null;
            }
        };
    }

    @Override
    protected JTable createJTable(AdapterFactory adapterFactory, Grid grid) {
        UcaTableColumnProvider columnProvider = new UcaTableColumnProvider();
        columnProvider.setAdapterFactory(adapterFactory);
        columnProvider.setGrid(grid);
        TransactionalEditingDomain txDomain = TransactionUtil.getEditingDomain((EObject)this.getDiagram());
        return ((JTableBuilder)((JTableBuilder)((JTableBuilder)JTableBuilder.builder((EditingDomain)txDomain).adapterFactory(adapterFactory)).columnProvider((ITableColumnProvider)columnProvider).transferHandler((TransferHandler)new GenericTableTableTransferHandler(txDomain, this.domain))).input((Object)grid).font(this.resolveTableFont())).reorderingAllowed(false).build((JTable)new GenericTable());
    }

    public ISelection getEditorSelection(ITableSelection selection) {
        IListSelection columnSelection = selection.getColumnSelection();
        int[] columnIndices = columnSelection.getIndices();
        if (columnIndices.length > 0) {
            ArrayList<EObject> elements = new ArrayList<EObject>(selection.size());
            for (Tuple tuple : Selections.iterable((ISelection)selection, Tuple.class)) {
                elements.add(tuple.getElementObject(0));
            }
            IListSelection rowSelection = selection.getRowSelection();
            return new TableSelection(elements, rowSelection, columnSelection);
        }
        return super.getEditorSelection(selection);
    }

    @Override
    protected boolean needToShowMessageOnActivated() {
        return false;
    }

    @Override
    protected String getMessageOnActivated() {
        return null;
    }

    public static class ControlActionFactory
    implements IQueryExecutor.Provider {
        public IQueryExecutor createExecutor(DataQuery dataQuery) {
            return dependencies -> {
                EAnnotation annotation = dataQuery.getEAnnotation(UCATableEditorPeer.ANNOTATION__UCA_TABLE);
                UCATable table = (UCATable)annotation.getReferences().get(0);
                return table.getControlActions().iterator();
            };
        }
    }
}

