/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.view.swing;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.astah.emf.common.ecore.EComparators;
import net.astah.emf.common.notify.EFeaturePath;
import net.astah.emf.edit.command.DeferringCommandWrapper;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.emf.edit.job.CommandJob;
import net.astah.emf.edit.job.Jobs;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.emf.edit.provider.swing.AdapterFactoryContentProvider;
import net.astah.emf.edit.provider.swing.JTableBuilder;
import net.astah.emf.edit.provider.swing.PropertyEditorFactory;
import net.astah.emf.edit.provider.swing.PropertyEditorFactoryRegistryImpl;
import net.astah.emf.edit.provider.swing.TransactionalFeaturePathContentProvider;
import net.astah.emf.edit.provider.swing.editor.ManyEReferenceCellEditor;
import net.astah.golf.view.swing.IPropertySourceProvider;
import net.astah.golf.view.swing.ITableColumnProvider;
import net.astah.golf.view.swing.TableColumnProvider;
import net.astah.golf.widget.swing.ContentTableModel;
import net.astah.golf.widget.swing.GenericTable;
import net.astah.golf.widget.swing.IContentProvider;
import net.astah.golf.widget.swing.IViewerAdapter;
import net.astah.golf.widget.swing.SwingIconRegistry;
import net.astah.jomt.jview.EditableTextComponentMouseAdapther;
import net.astah.stpa.stamp.ControlAction;
import net.astah.stpa.stamp.Element;
import net.astah.stpa.stamp.Note;
import net.astah.stpa.stamp.STAMPFactory;
import net.astah.stpa.stamp.STAMPPackage;
import net.astah.stpa.stamp.STPAAnalysis;
import net.astah.stpa.stamp.SafetyConstraint;
import net.astah.stpa.stamp.UCAAnalysis;
import net.astah.stpa.stamp.UCAAnalysisResult;
import net.astah.stpa.stamp.UCAGuideWord;
import net.astah.stpa.stamp.UnsafeControlAction;
import net.astah.stpa.stamp.ui.Messages;
import net.astah.table.Tuple;
import net.astah.table.ui.Tables;
import net.astah.table.ui.swing.TableCellDialogPanel;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.uml2.common.util.UML2Util;

public class UCADialogPanel
extends TableCellDialogPanel
implements ActionListener {
    private static final long serialVersionUID = -7596620116731878186L;
    private static final int DIALOG_WIDTH = 650;
    private static final int DIALOG_HEIGHT = 200;
    private JTable ucaTable;
    private JButton addUCAButton;
    private JButton addNonUCAButton;
    private JButton deleteButton;
    private JButton upButton;
    private JButton downButton;
    private UCAAnalysis ucaAnalysis;
    private UCAAnalysisResult ucaAnalysisResult;
    private UCAGuideWord guideWord;
    private ControlAction controlAction;

    public UCADialogPanel(IPropertySourceProvider propertySourceProvider) {
        super(propertySourceProvider);
        this.setPreferredSize(new Dimension(SwingIconRegistry.scaleValue((int)650), SwingIconRegistry.scaleValue((int)200)));
    }

    protected float[] getColumnsWidthRatio() {
        return new float[]{0.08f, 0.15f, 0.49f, 0.28f};
    }

    protected void setInput(Object object, JTable baseTable, int row, int column) {
        EObject parent;
        ContentTableModel baseTableModel = (ContentTableModel)baseTable.getModel();
        Tuple tempTuple = (Tuple)baseTableModel.getRowAt(row);
        Tuple ucaTableRowTuple = (Tuple)tempTuple.getGrid().getRowTuples().get(row);
        Tuple ucaTableColumnTuple = (Tuple)tempTuple.getGrid().getColumnTuples().get(column);
        this.ucaAnalysis = (UCAAnalysis)ucaTableRowTuple.getElementObject(3);
        this.guideWord = (UCAGuideWord)ucaTableColumnTuple.getElementObject(0);
        this.controlAction = (ControlAction)ucaTableRowTuple.getElementObject(0);
        if (object instanceof EObjectEList && (parent = ((EObjectEList)object).getEObject()) instanceof UCAAnalysisResult) {
            this.ucaAnalysisResult = (UCAAnalysisResult)parent;
        }
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.ucaAnalysis);
        AdapterFactory adapterFactory = ItemProviders.getAdapterFactory((EditingDomain)domain);
        AdapterFactoryContentProvider contentProvider = this.createContentProvider(domain, adapterFactory);
        PropertyEditorFactoryRegistryImpl registry = new PropertyEditorFactoryRegistryImpl(PropertyEditorFactory.Registry.INSTANCE);
        ManyEReferenceCellEditor.DescriptorImpl factory = new ManyEReferenceCellEditor.DescriptorImpl((Notifier)this.ucaAnalysis.getOwner(), EComparators.comparingFeature((String)STAMPPackage.Literals.IDENTIFIED_ELEMENT__ID.getName()).thenComparing(EComparators.eObjectPath()));
        registry.getFeatureMap().put(STAMPPackage.Literals.UNSAFE_CONTROL_ACTION__VIOLATING_SAFETY_CONSTRAINT, factory);
        contentProvider.setPropertyEditorFactoryRegistry((PropertyEditorFactory.Registry)registry);
        ((JTableBuilder)((JTableBuilder)((JTableBuilder)JTableBuilder.builder((EditingDomain)domain).adapterFactory(adapterFactory)).addColumn((ITableColumnProvider.IColumnDescriptor)new CheckBoxColumnDescriptor(Messages.uca_dialog_panel_is_uca_check_header)).addColumn((ITableColumnProvider.IColumnDescriptor)TableColumnProvider.idProperty((String)Messages.uca_dialog_panel_uca_id_header, (Object)"id").setClickCountToStart(2)).addColumn((ITableColumnProvider.IColumnDescriptor)TableColumnProvider.idProperty((String)Messages.uca_dialog_panel_text_header, (Set)Sets.newHashSet((Object[])new Object[]{"description", "body"})).setLineWrap(true).setClickCountToStart(2)).addColumn((ITableColumnProvider.IColumnDescriptor)new SafetyConstraintColumnDescriptor("violatingSafetyConstraint").setHeaderValue(Messages.uca_dialog_panel_violating_sc_header).setLineWrap(true).setClickCountToStart(2)).contentProvider((IContentProvider)contentProvider)).propertyEditorFactoryRegistry((PropertyEditorFactory.Registry)registry)).reorderingAllowed(false).input((Object)this.ucaAnalysisResult).build(this.ucaTable);
        this.ucaTable.setFont(baseTable.getFont());
        this.ucaTable.getTableHeader().setFont(baseTable.getFont());
        Enumeration<TableColumn> columns = this.ucaTable.getColumnModel().getColumns();
        for (float ratio : this.getColumnsWidthRatio()) {
            if (!columns.hasMoreElements()) continue;
            columns.nextElement().setPreferredWidth((int)(650.0f * ratio));
        }
    }

    protected void initComponent(IPropertySourceProvider propertySourceProvider) {
        this.ucaTable = new GenericTable();
        EditableTextComponentMouseAdapther.install((JTable)this.ucaTable);
        JScrollPane scrollPane = new JScrollPane(this.ucaTable);
        this.addUCAButton = new JButton(Messages.uca_dialog_panel_uca_add_button);
        this.addUCAButton.addActionListener(this);
        this.addNonUCAButton = new JButton(Messages.uca_dialog_panel_non_uca_add_button);
        this.addNonUCAButton.addActionListener(this);
        this.deleteButton = new JButton(Messages.stpa_dialog_panel_delete_button);
        this.deleteButton.addActionListener(this);
        this.deleteButton.setEnabled(false);
        this.upButton = new JButton(Messages.stpa_dialog_panel_up_button);
        this.upButton.addActionListener(this);
        this.upButton.setEnabled(false);
        this.downButton = new JButton(Messages.stpa_dialog_panel_down_button);
        this.downButton.addActionListener(this);
        this.downButton.setEnabled(false);
        this.ucaTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                int selectedCount = this.ucaTable.getSelectedRowCount();
                this.deleteButton.setEnabled(selectedCount > 0);
                this.upButton.setEnabled(selectedCount == 1);
                this.downButton.setEnabled(selectedCount == 1);
            }
        });
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(2, 10, 2, 10);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(scrollPane, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(2, 10, 2, 10);
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        this.add(new JLabel(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.add(this.addUCAButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.add(this.addNonUCAButton, gbc);
        gbc.gridx = 2;
        gbc.gridy = 1;
        this.add(this.deleteButton, gbc);
        gbc.gridx = 3;
        gbc.gridy = 1;
        this.add(this.upButton, gbc);
        gbc.gridx = 4;
        gbc.gridy = 1;
        this.add(this.downButton, gbc);
    }

    protected AdapterFactoryContentProvider createContentProvider(TransactionalEditingDomain domain, AdapterFactory adapterFactory) {
        TransactionalFeaturePathContentProvider contentProvider = new TransactionalFeaturePathContentProvider(domain, adapterFactory);
        contentProvider.addPath(EFeaturePath.build((EStructuralFeature)STAMPPackage.Literals.UCA_ANALYSIS_RESULT__RESULT_ELEMENT));
        return contentProvider;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int newSelectionRow;
        Command command;
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.ucaAnalysis);
        int selectedRow = this.ucaTable.getSelectedRow();
        if (e.getSource() == this.addUCAButton) {
            command = this.createAddUCACommands(domain, selectedRow);
            newSelectionRow = selectedRow == -1 ? this.ucaTable.getRowCount() : selectedRow + 1;
        } else if (e.getSource() == this.addNonUCAButton) {
            command = this.createAddNonUCACommands(domain, selectedRow);
            newSelectionRow = selectedRow == -1 ? this.ucaTable.getRowCount() : selectedRow + 1;
        } else if (e.getSource() == this.deleteButton) {
            command = this.createDeleteCommands(domain, this.ucaTable.getSelectedRows());
            newSelectionRow = -1;
        } else if (e.getSource() == this.upButton) {
            command = this.createMoveUpCommand(domain, selectedRow);
            newSelectionRow = selectedRow - 1;
        } else if (e.getSource() == this.downButton) {
            command = this.createMoveDownCommand(domain, selectedRow);
            newSelectionRow = selectedRow + 1;
        } else {
            return;
        }
        IViewerAdapter model = (IViewerAdapter)this.ucaTable.getModel();
        if (model.getInput() != this.ucaAnalysisResult) {
            model.setInput((Object)this.ucaAnalysisResult);
            model.refresh();
        }
        CommandJob job = new CommandJob(domain, command);
        Jobs.toCompletableFuture((Job)job, (boolean)true).thenRun(() -> {
            if (newSelectionRow >= 0) {
                this.ucaTable.scrollRectToVisible(this.ucaTable.getCellRect(newSelectionRow, 0, true));
                this.ucaTable.setRowSelectionInterval(newSelectionRow, newSelectionRow);
            }
            if (e.getSource() == this.addUCAButton || e.getSource() == this.addNonUCAButton) {
                Tables.startCellEditing((JTable)this.ucaTable, (int)newSelectionRow, (int)2);
            }
        });
        job.schedule();
    }

    protected void okHandler() {
        TableCellEditor cellEditor = this.ucaTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        this.closeDialog();
    }

    protected void cancelHandler() {
        TableCellEditor cellEditor = this.ucaTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.cancelCellEditing();
        }
        this.closeDialog();
    }

    protected Command createAddUCACommands(TransactionalEditingDomain domain, int selectedRow) {
        UnsafeControlAction uca = STAMPFactory.eINSTANCE.createUnsafeControlAction();
        uca.setDescription("UCA");
        uca.setControlAction(this.controlAction);
        CompoundCommand command = new CompoundCommand();
        STPAAnalysis stpaAnalysis = this.ucaAnalysis.getOwner();
        if (this.ucaAnalysisResult == null) {
            command.append(this.createAddUCAAnalysisCommand(domain));
        }
        command.append(CreateChildCommand.create((EditingDomain)domain, (Object)stpaAnalysis, (Object)new CommandParameter((Object)stpaAnalysis, (Object)STAMPPackage.Literals.STPA_ANALYSIS__UNSAFE_CONTROL_ACTION, (Object)uca), Collections.singleton(stpaAnalysis)));
        command.append(AddCommand.create((EditingDomain)domain, (Object)this.ucaAnalysisResult, (Object)STAMPPackage.Literals.UCA_ANALYSIS_RESULT__UNSAFE_CONTROL_ACTION, (Object)uca));
        command.append((Command)new DeferringCommandWrapper(MoveCommand.create((EditingDomain)domain, (Object)this.ucaAnalysisResult, (Object)STAMPPackage.Literals.UCA_ANALYSIS_RESULT__RESULT_ELEMENT, (Object)uca, (int)(selectedRow < 0 ? -1 : selectedRow + 1))));
        return command.unwrap();
    }

    protected Command createAddNonUCACommands(TransactionalEditingDomain domain, int selectedRow) {
        CompoundCommand command = new CompoundCommand();
        Note note = STAMPFactory.eINSTANCE.createNote();
        note.setBody("-");
        if (this.ucaAnalysisResult == null) {
            command.append(this.createAddUCAAnalysisCommand(domain));
        }
        command.append(CreateChildCommand.create((EditingDomain)domain, (Object)this.ucaAnalysisResult, (Object)new CommandParameter((Object)this.ucaAnalysisResult, (Object)STAMPPackage.Literals.ELEMENT__OWNED_NOTE, (Object)note), Collections.singleton(this.ucaAnalysisResult)));
        command.append((Command)new DeferringCommandWrapper(MoveCommand.create((EditingDomain)domain, (Object)this.ucaAnalysisResult, (Object)STAMPPackage.Literals.UCA_ANALYSIS_RESULT__RESULT_ELEMENT, (Object)note, (int)(selectedRow < 0 ? -1 : selectedRow + 1))));
        return command.unwrap();
    }

    private Command createAddUCAAnalysisCommand(TransactionalEditingDomain domain) {
        this.ucaAnalysisResult = STAMPFactory.eINSTANCE.createUCAAnalysisResult();
        this.ucaAnalysisResult.setControlAction(this.controlAction);
        this.ucaAnalysisResult.setGuideWord(this.guideWord);
        return AddCommand.create((EditingDomain)domain, (Object)this.ucaAnalysis, (Object)STAMPPackage.Literals.UCA_ANALYSIS__RESULT, (Object)this.ucaAnalysisResult);
    }

    protected Command createDeleteCommands(TransactionalEditingDomain domain, int[] rowIndices) {
        if (rowIndices != null && rowIndices.length > 0) {
            EList resultElements = this.ucaAnalysisResult.getResultElements();
            ArrayList<Element> ownedElements = new ArrayList<Element>();
            ArrayList<Element> elements = new ArrayList<Element>();
            for (int rowIndex : rowIndices) {
                Element element = (Element)resultElements.get(rowIndex);
                if (EcoreUtil.isAncestor((EObject)this.ucaAnalysisResult, (EObject)element)) {
                    ownedElements.add(element);
                    continue;
                }
                elements.add(element);
            }
            CompoundCommand result = new CompoundCommand();
            if (!ownedElements.isEmpty()) {
                result.append(DestroyCommand.create((EditingDomain)domain, ownedElements));
            }
            if (!elements.isEmpty()) {
                result.append(DestroyCommand.create((EditingDomain)domain, (Object)new DestroyCommand.Reference((EObject)this.ucaAnalysisResult, (EStructuralFeature)STAMPPackage.Literals.UCA_ANALYSIS_RESULT__RESULT_ELEMENT, elements)));
            }
            return result.unwrap();
        }
        return IdentityCommand.INSTANCE;
    }

    protected Command createMoveUpCommand(TransactionalEditingDomain domain, int rowIndex) {
        if (rowIndex < 1) {
            return IdentityCommand.INSTANCE;
        }
        Element element = (Element)this.ucaAnalysisResult.getResultElements().get(rowIndex);
        return MoveCommand.create((EditingDomain)domain, (Object)this.ucaAnalysisResult, (Object)STAMPPackage.Literals.UCA_ANALYSIS_RESULT__RESULT_ELEMENT, (Object)element, (int)(rowIndex - 1));
    }

    protected Command createMoveDownCommand(TransactionalEditingDomain domain, int rowIndex) {
        if (rowIndex >= this.ucaAnalysisResult.getResultElements().size() - 1) {
            return IdentityCommand.INSTANCE;
        }
        Element element = (Element)this.ucaAnalysisResult.getResultElements().get(rowIndex);
        return MoveCommand.create((EditingDomain)domain, (Object)this.ucaAnalysisResult, (Object)STAMPPackage.Literals.UCA_ANALYSIS_RESULT__RESULT_ELEMENT, (Object)element, (int)(rowIndex + 1));
    }

    private void closeDialog() {
        JTableBuilder.dispose((JTable)this.ucaTable);
        if (this.ucaAnalysisResult != null) {
            this.ucaAnalysisResult = null;
        }
    }

    class SafetyConstraintColumnDescriptor
    extends TableColumnProvider.IdPropertyColumnDescriptor {
        protected SafetyConstraintColumnDescriptor(Object propertyId) {
            super(propertyId);
        }

        protected TableCellRenderer createCellRenderer(IPropertySourceProvider propertySourceProvider) {
            return new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 2127237340620063003L;

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    JPanel panel = new JPanel();
                    panel.setFont(table.getFont());
                    if (isSelected) {
                        panel.setBackground(table.getSelectionBackground());
                    } else {
                        panel.setBackground(component.getBackground());
                    }
                    if (value instanceof ItemPropertyDescriptor.PropertyValueWrapper && ((ItemPropertyDescriptor.PropertyValueWrapper)value).getEditableValue(null) instanceof List) {
                        List list = (List)((ItemPropertyDescriptor.PropertyValueWrapper)value).getEditableValue(null);
                        if (list.isEmpty()) {
                            return panel;
                        }
                        FlowLayout flowLayout = new FlowLayout(0, 0, 0);
                        panel.setLayout(flowLayout);
                        int panelPreferredSize = 0;
                        String safetyConstraintString = list.stream().filter(element -> element instanceof SafetyConstraint).map(sc -> ((SafetyConstraint)sc).getId()).collect(Collectors.joining(", "));
                        JTextArea textArea = new JTextArea(safetyConstraintString);
                        if (isSelected) {
                            textArea.setForeground(Color.white);
                            textArea.setBackground(table.getSelectionBackground());
                        } else {
                            textArea.setForeground(Color.black);
                            textArea.setBackground(table.getBackground());
                        }
                        textArea.setFont(table.getFont());
                        textArea.setLineWrap(true);
                        textArea.doLayout();
                        textArea.setSize(table.getColumnModel().getColumn(column).getWidth(), (int)textArea.getPreferredSize().getHeight());
                        panel.add(textArea);
                        panelPreferredSize = (int)((double)panelPreferredSize + textArea.getPreferredSize().getHeight());
                        panel.doLayout();
                        panel.setPreferredSize(new Dimension(table.getColumnModel().getColumn(column).getWidth(), (int)Math.max(this.getPreferredSize().getHeight(), (double)panelPreferredSize)));
                        return panel;
                    }
                    return component;
                }
            };
        }
    }

    class CheckBoxColumnDescriptor
    extends TableColumnProvider.CheckBoxPropertyColumnDescriptor {
        public CheckBoxColumnDescriptor(String header) {
            super((Object)header);
            this.setHeaderValue(header);
        }

        public Object getColumnValue(IPropertySourceProvider propertySourceProvider, Object object) {
            if (object == null) {
                return null;
            }
            if (object instanceof UnsafeControlAction) {
                return true;
            }
            return false;
        }

        public void setColumnValue(IPropertySourceProvider propertySourceProvider, Object object, Object value) {
            CompoundCommand command = new CompoundCommand();
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Object)object);
            command.append(DestroyCommand.create((EditingDomain)domain, Collections.singleton(object)));
            EList supersetList = UCADialogPanel.this.ucaAnalysisResult.getResultElements();
            int index = supersetList.indexOf(object);
            if (object instanceof UnsafeControlAction) {
                UnsafeControlAction uca = (UnsafeControlAction)object;
                UCAAnalysisResult ucaAnalysisResult = (UCAAnalysisResult)Iterables.tryFind((Iterable)UML2Util.getInverseReferences((EObject)uca), setting -> setting.getEObject() instanceof UCAAnalysisResult).transform(setting -> (UCAAnalysisResult)setting.getEObject()).orNull();
                Note note = STAMPFactory.eINSTANCE.createNote();
                note.setBody(uca.getDescription());
                int subsetListIndex = this.findNearlyIndex((List<? extends EObject>)supersetList, (List<? extends EObject>)ucaAnalysisResult.getOwnedNotes(), index);
                command.append(CreateChildCommand.create((EditingDomain)domain, (Object)ucaAnalysisResult, (Object)new CommandParameter((Object)ucaAnalysisResult, (Object)STAMPPackage.Literals.ELEMENT__OWNED_NOTE, (Object)note, subsetListIndex), Collections.singleton(ucaAnalysisResult)));
                command.append((Command)new DeferringCommandWrapper(MoveCommand.create((EditingDomain)domain, (Object)ucaAnalysisResult, (Object)STAMPPackage.Literals.UCA_ANALYSIS_RESULT__RESULT_ELEMENT, (Object)note, (int)index)));
            } else if (object instanceof Note) {
                Note note = (Note)object;
                UCAAnalysisResult ucaAnalysisResult = (UCAAnalysisResult)note.eContainer();
                STPAAnalysis stpaAnalysis = (STPAAnalysis)ucaAnalysisResult.eContainer().eContainer();
                UnsafeControlAction uca = STAMPFactory.eINSTANCE.createUnsafeControlAction();
                if (note.getBody().isEmpty()) {
                    uca.setDescription("UCA");
                } else {
                    uca.setDescription(note.getBody());
                }
                uca.setControlAction(ucaAnalysisResult.getControlAction());
                int subsetListIndex = this.findNearlyIndex((List<? extends EObject>)supersetList, (List<? extends EObject>)ucaAnalysisResult.getUnsafeControlActions(), index);
                command.append(CreateChildCommand.create((EditingDomain)domain, (Object)stpaAnalysis, (Object)new CommandParameter((Object)stpaAnalysis, (Object)STAMPPackage.Literals.STPA_ANALYSIS__UNSAFE_CONTROL_ACTION, (Object)uca), Collections.singleton(stpaAnalysis)));
                command.append(AddCommand.create((EditingDomain)domain, (Object)ucaAnalysisResult, (Object)STAMPPackage.Literals.UCA_ANALYSIS_RESULT__UNSAFE_CONTROL_ACTION, (Object)uca, (int)subsetListIndex));
                command.append((Command)new DeferringCommandWrapper(MoveCommand.create((EditingDomain)domain, (Object)ucaAnalysisResult, (Object)STAMPPackage.Literals.UCA_ANALYSIS_RESULT__RESULT_ELEMENT, (Object)uca, (int)index)));
            }
            new CommandJob(domain, command.unwrap()).schedule();
        }

        private int findNearlyIndex(List<? extends EObject> supersetList, List<? extends EObject> subsetList, int index) {
            EObject nearlySametypeObj = (EObject)Iterables.tryFind(supersetList.subList(index, supersetList.size()), subsetList::contains).orNull();
            if (nearlySametypeObj == null) {
                return subsetList.size();
            }
            return subsetList.indexOf(nearlySametypeObj);
        }
    }
}

