/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.view.swing;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import lombok.NonNull;
import net.astah.common.collect.Streams;
import net.astah.emf.common.ecore.EObjects;
import net.astah.emf.common.notify.EFeaturePath;
import net.astah.emf.edit.command.DeferringCommandWrapper;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.emf.edit.job.CommandJob;
import net.astah.emf.edit.job.Jobs;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.emf.edit.provider.swing.AdapterFactoryContentProvider;
import net.astah.emf.edit.provider.swing.JTableBuilder;
import net.astah.emf.edit.provider.swing.TransactionalContentProviderTableModel;
import net.astah.emf.edit.provider.swing.TransactionalFeaturePathContentProvider;
import net.astah.golf.view.swing.IPropertySourceProvider;
import net.astah.golf.view.swing.ITableColumnProvider;
import net.astah.golf.view.swing.TableColumnProvider;
import net.astah.golf.widget.swing.ContentTableModel;
import net.astah.golf.widget.swing.GenericTable;
import net.astah.golf.widget.swing.IContentProvider;
import net.astah.golf.widget.swing.ILabelProvider;
import net.astah.golf.widget.swing.IStructuredContentProvider;
import net.astah.golf.widget.swing.LabelProvider;
import net.astah.golf.widget.swing.SwingFrame;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jview.EditableTextComponentMouseAdapther;
import net.astah.stpa.stamp.Component;
import net.astah.stpa.stamp.ControlStructure;
import net.astah.stpa.stamp.Link;
import net.astah.stpa.stamp.LinkEnd;
import net.astah.stpa.stamp.NamedElement;
import net.astah.stpa.stamp.STAMPPackage;
import net.astah.stpa.stamp.Signal;
import net.astah.stpa.stamp.ui.Messages;
import net.astah.stpa.stamp.ui.control.ModifyControlStructureDiagramElementsCommand;
import net.astah.stpa.stamp.ui.view.SelectNamedElementDialog;
import net.astah.table.Tuple;
import net.astah.table.ui.Tables;
import net.astah.table.ui.swing.TableCellDialogPanel;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class SignalDialogPanel
extends TableCellDialogPanel
implements ActionListener {
    private static final long serialVersionUID = -8707467912616651771L;
    private static final int DIALOG_WIDTH = 500;
    private static final int DIALOG_HEIGHT = 260;
    private final EClass targetEClass;
    private final EReference targetEReference;
    private final EClass createEClass;
    private JTable table;
    private JButton addButton;
    private JButton deleteButton;
    private Component component;
    private Signal selectingSignal;

    public SignalDialogPanel(IPropertySourceProvider propertySourceProvider, @NonNull EClass targetEClass, @NonNull EReference targetEReference, @NonNull EClass createEClass) {
        super(propertySourceProvider);
        if (targetEClass == null) {
            throw new NullPointerException("targetEClass");
        }
        if (targetEReference == null) {
            throw new NullPointerException("targetEReference");
        }
        if (createEClass == null) {
            throw new NullPointerException("createEClass");
        }
        this.targetEClass = targetEClass;
        this.targetEReference = targetEReference;
        this.createEClass = createEClass;
        this.setPreferredSize(new Dimension(500, 260));
    }

    protected String getSignalHeaderText() {
        return Messages.signal_dialog_panel_signal_header;
    }

    protected void setInput(Object object, JTable baseTable, int row, int column) {
        ContentTableModel baseTableModel = (ContentTableModel)baseTable.getModel();
        Tuple tempTuple = (Tuple)baseTableModel.getRowAt(row);
        Tuple tableRowTuple = (Tuple)tempTuple.getGrid().getRowTuples().get(row);
        this.component = (Component)tableRowTuple.getElementObject(0);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.component);
        AdapterFactory adapterFactory = ItemProviders.getAdapterFactory((EditingDomain)domain);
        ((JTableBuilder)((JTableBuilder)JTableBuilder.builder((EditingDomain)domain).adapterFactory(adapterFactory)).addColumn((ITableColumnProvider.IColumnDescriptor)TableColumnProvider.idProperty((String)this.getSignalHeaderText(), (Object)"name").setLineWrap(true).setClickCountToStart(2)).addColumn((ITableColumnProvider.IColumnDescriptor)TableColumnProvider.label((String)Messages.signal_dialog_panel_target_component_header, (ILabelProvider)this.getTargetComponentLabelProvider()).setLineWrap(true).setClickCountToStart(2)).contentProvider((IContentProvider)this.createContentProvider(domain, adapterFactory))).reorderingAllowed(false).input((Object)this.component).build(this.table);
        this.table.setFont(baseTable.getFont());
        this.table.getTableHeader().setFont(baseTable.getFont());
        Enumeration<TableColumn> columns = this.table.getColumnModel().getColumns();
        for (float ratio : this.getColumnsWidthRatio()) {
            if (!columns.hasMoreElements()) continue;
            columns.nextElement().setPreferredWidth((int)(500.0f * ratio));
        }
    }

    protected AdapterFactoryContentProvider createContentProvider(TransactionalEditingDomain domain, AdapterFactory adapterFactory) {
        TransactionalFeaturePathContentProvider contentProvider = new TransactionalFeaturePathContentProvider(domain, adapterFactory){

            public Collection<?> getElements(Object object) {
                return Streams.stream((Collection)super.getElements(object), Signal.class).filter(signal -> !(signal.getLink().getSource() instanceof LinkEnd) && !(signal.getLink().getTarget() instanceof LinkEnd)).collect(Collectors.toList());
            }
        };
        contentProvider.addPath(EFeaturePath.builder().addInverse(STAMPPackage.Literals.LINK__SOURCE).add((EStructuralFeature)this.targetEReference).inclusive(true).create());
        return contentProvider;
    }

    protected float[] getColumnsWidthRatio() {
        return new float[]{0.5f, 0.5f};
    }

    protected void initComponent(IPropertySourceProvider propertySourceProvider) {
        this.table = new GenericTable();
        EditableTextComponentMouseAdapther.install((JTable)this.table);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.addButton = new JButton(Messages.stpa_dialog_panel_add_button);
        this.addButton.addActionListener(this);
        this.deleteButton = new JButton(Messages.stpa_dialog_panel_delete_button);
        this.deleteButton.addActionListener(this);
        this.deleteButton.setEnabled(false);
        this.table.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                int selectedCount = this.table.getSelectedRowCount();
                this.deleteButton.setEnabled(selectedCount > 0);
            }
        });
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(2, 10, 2, 10);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(scrollPane, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(2, 20, 2, 20);
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        this.add(new JLabel(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.add(this.addButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.add(this.deleteButton, gbc);
    }

    private ILabelProvider getTargetComponentLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof Signal)) {
                    return null;
                }
                Link link = ((Signal)element).getLink();
                return link == null ? null : link.getTarget().getName();
            }
        };
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.stopCellEditing();
        CompoundCommand command = new CompoundCommand();
        final TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.component);
        Object source = e.getSource();
        if (source == this.addButton) {
            this.selectingSignal = this.createSignal(domain, command);
        } else if (source == this.deleteButton) {
            command.append(this.createDeleteCommands((EditingDomain)domain, this.table.getSelectedRows()));
        }
        if (source != this.deleteButton) {
            DeferringCommandWrapper modifyDiagramCommand = new DeferringCommandWrapper(){

                protected Command createCommand() {
                    ControlStructure controlStructure = (ControlStructure)EObjects.getAncestor(ControlStructure.class, (EObject)SignalDialogPanel.this.component);
                    return new ModifyControlStructureDiagramElementsCommand(domain, controlStructure);
                }
            };
            command.append((Command)modifyDiagramCommand);
        }
        if (command.isEmpty()) {
            return;
        }
        CommandJob job = new CommandJob(domain, command.unwrap());
        if (source == this.addButton) {
            Jobs.toCompletableFuture((Job)job, (boolean)true).thenRun(this::postExecute);
        }
        job.schedule();
    }

    protected void okHandler() {
        this.stopCellEditing();
        this.closeDialog();
    }

    protected void cancelHandler() {
        this.stopCellEditing();
        this.closeDialog();
    }

    private void closeDialog() {
        JTableBuilder.dispose((JTable)this.table);
        if (this.component != null) {
            this.component = null;
        }
    }

    private void stopCellEditing() {
        TableCellEditor cellEditor = this.table.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    protected Signal createSignal(TransactionalEditingDomain domain, CompoundCommand command) {
        ControlStructure controlStructure = (ControlStructure)EObjects.getAncestor(ControlStructure.class, (EObject)this.component);
        TreeIterator iterator = EcoreUtil.getAllContents((EObject)controlStructure, (boolean)false);
        List components = Lists.newArrayList((Iterator)Iterators.filter((Iterator)iterator, arg_0 -> ((EClass)STAMPPackage.Literals.COMPONENT).isInstance(arg_0)));
        JFrame parent = (JFrame)((SwingFrame)JomtGlobal.viewManager.getManagementView().getComponent()).getComponent();
        SelectNamedElementDialog dialog = new SelectNamedElementDialog(parent, components, (NamedElement)components.get(0));
        dialog.setTitle(Messages.signal_dialog_panel_target_component_header);
        dialog.pack();
        dialog.setVisible(true);
        if (dialog.getResultState() == 1) {
            Component selectComponent = (Component)dialog.getSelectedElement();
            Signal signal = (Signal)EcoreUtil.create((EClass)this.createEClass);
            Link link = controlStructure.getLinks().stream().filter(m -> m.eClass() == this.targetEClass && m.getSource() == this.component && m.getTarget() == selectComponent).findFirst().orElseGet(() -> {
                Link returnLink = (Link)EcoreUtil.create((EClass)this.targetEClass);
                command.append(CreateChildCommand.create((EditingDomain)domain, (Object)controlStructure, (Object)new CommandParameter((Object)controlStructure, (Object)STAMPPackage.Literals.CONTROL_STRUCTURE__LINK, (Object)returnLink), Collections.singleton(controlStructure)));
                command.append(SetCommand.create((EditingDomain)domain, (Object)returnLink, (Object)STAMPPackage.Literals.LINK__SOURCE, (Object)this.component));
                command.append(SetCommand.create((EditingDomain)domain, (Object)returnLink, (Object)STAMPPackage.Literals.LINK__TARGET, (Object)selectComponent));
                return returnLink;
            });
            command.append(CreateChildCommand.create((EditingDomain)domain, (Object)link, (Object)new CommandParameter((Object)link, (Object)STAMPPackage.Literals.LINK__SIGNAL, (Object)signal), Collections.singleton(link)));
            return signal;
        }
        return null;
    }

    protected Command createDeleteCommands(EditingDomain domain, int[] rowIndices) {
        if (rowIndices != null && rowIndices.length > 0) {
            List elements = (List)this.getContentProvider().getElements((Object)this.component);
            CompoundCommand result = new CompoundCommand();
            for (int rowIndex : rowIndices) {
                result.append(DestroyCommand.create((EditingDomain)domain, elements.get(rowIndex)));
            }
            return result;
        }
        return IdentityCommand.INSTANCE;
    }

    private IStructuredContentProvider getContentProvider() {
        TableModel selectionModel = this.table.getModel();
        TransactionalContentProviderTableModel contentProviderModel = (TransactionalContentProviderTableModel)selectionModel;
        IStructuredContentProvider provider = contentProviderModel.getContentProvider();
        return provider;
    }

    private void postExecute() {
        List elements = (List)this.getContentProvider().getElements((Object)this.component);
        int index = elements.indexOf(this.selectingSignal);
        Tables.startCellEditing((JTable)this.table, (int)index, (int)0);
        this.table.setRowSelectionInterval(index, index);
        this.selectingSignal = null;
    }
}

