/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.view.swing;

import com.google.common.base.Strings;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.astah.dd.di.Diagram;
import net.astah.emf.edit.provider.swing.JTableBuilder;
import net.astah.golf.view.swing.ITableColumnProvider;
import net.astah.golf.widget.CJComponent;
import net.astah.golf.widget.swing.GenericTable;
import net.astah.jomt.jview.Editor;
import net.astah.jomt.jview.swing.SwingTableEditorPeer;
import net.astah.stpa.stamp.ui.Messages;
import net.astah.stpa.stamp.ui.table.STPAGenericTableColumnProvider;
import net.astah.table.Grid;
import net.astah.table.ui.swing.GenericTableTableTransferHandler;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class STPATableEditorPeer
extends SwingTableEditorPeer {
    private Container southPanel;
    private boolean showingMessageOnActivated;
    protected int messageTimeOnActivated = 6000;

    public void initialize(Diagram diagram, CJComponent parent) {
        this.setShowingMessageOnActivated(false);
        super.initialize(diagram, parent);
    }

    protected JTable createJTable(AdapterFactory adapterFactory, Grid grid) {
        STPAGenericTableColumnProvider columnProvider = new STPAGenericTableColumnProvider();
        columnProvider.setAdapterFactory(adapterFactory);
        columnProvider.setGrid(grid);
        TransactionalEditingDomain txDomain = TransactionUtil.getEditingDomain((EObject)this.getDiagram());
        return ((JTableBuilder)((JTableBuilder)((JTableBuilder)JTableBuilder.builder((EditingDomain)txDomain).adapterFactory(adapterFactory)).columnProvider((ITableColumnProvider)columnProvider).transferHandler((TransferHandler)new GenericTableTableTransferHandler(txDomain, this.domain))).input((Object)grid).font(this.resolveTableFont())).reorderingAllowed(false).build((JTable)new GenericTable());
    }

    public void tableEditorActivated(Editor previousEditor) {
        super.tableEditorActivated(previousEditor);
        if (this.getTableEditor() != previousEditor) {
            this.showMessageOnActivated();
        }
    }

    protected Container createSouthPanel() {
        this.southPanel = super.createSouthPanel();
        return this.southPanel;
    }

    private synchronized void setShowingMessageOnActivated(boolean showing) {
        this.showingMessageOnActivated = showing;
    }

    private synchronized boolean showingMessageOnActivated() {
        return this.showingMessageOnActivated;
    }

    private void showMessageOnActivated() {
        String message;
        if (!this.showingMessageOnActivated() && this.needToShowMessageOnActivated() && !Strings.isNullOrEmpty((String)(message = this.getMessageOnActivated()))) {
            this.showMessageLikeToast(message, this.messageTimeOnActivated);
        }
    }

    protected boolean needToShowMessageOnActivated() {
        JTable table = (JTable)this.getTable().getComponent();
        int rowCount = table.getRowCount();
        return rowCount <= 0;
    }

    protected String getMessageOnActivated() {
        return Messages.stpa_table_operation_guide_message;
    }

    private void showMessageLikeToast(String message, int duration) {
        if (this.southPanel == null) {
            return;
        }
        this.setShowingMessageOnActivated(true);
        final JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new CompoundBorder(panel.getBorder(), new EmptyBorder(5, 5, 5, 5)));
        panel.setBackground(Color.GRAY);
        JTextArea label = new JTextArea();
        label.setText(message);
        label.setForeground(Color.WHITE);
        label.setOpaque(false);
        label.setEditable(false);
        label.setFocusable(false);
        label.setLineWrap(true);
        label.setFont(null);
        panel.add(label);
        this.southPanel.add(panel);
        Timer timer = new Timer(duration, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                STPATableEditorPeer.this.setShowingMessageOnActivated(false);
                panel.setVisible(false);
                STPATableEditorPeer.this.southPanel.remove(panel);
            }
        });
        timer.setRepeats(false);
        timer.start();
    }
}

