/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.view.swing;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import lombok.NonNull;
import net.astah.common.collect.Streams;
import net.astah.emf.common.ecore.EObjects;
import net.astah.emf.common.notify.EFeaturePath;
import net.astah.emf.edit.command.DeferringCommandWrapper;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.emf.edit.job.CommandJob;
import net.astah.emf.edit.job.Jobs;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.emf.edit.provider.swing.AdapterFactoryContentProvider;
import net.astah.emf.edit.provider.swing.JTableBuilder;
import net.astah.emf.edit.provider.swing.TransactionalContentProviderTableModel;
import net.astah.emf.edit.provider.swing.TransactionalFeaturePathContentProvider;
import net.astah.golf.view.swing.IPropertySourceProvider;
import net.astah.golf.view.swing.ITableColumnProvider;
import net.astah.golf.view.swing.TableColumnProvider;
import net.astah.golf.widget.swing.ContentTableModel;
import net.astah.golf.widget.swing.GenericTable;
import net.astah.golf.widget.swing.IContentProvider;
import net.astah.golf.widget.swing.ILabelProvider;
import net.astah.golf.widget.swing.IStructuredContentProvider;
import net.astah.golf.widget.swing.LabelProvider;
import net.astah.jomt.jview.EditableTextComponentMouseAdapther;
import net.astah.stpa.stamp.Component;
import net.astah.stpa.stamp.ControlStructure;
import net.astah.stpa.stamp.Link;
import net.astah.stpa.stamp.LinkEnd;
import net.astah.stpa.stamp.LinkableElement;
import net.astah.stpa.stamp.STAMPPackage;
import net.astah.stpa.stamp.Signal;
import net.astah.stpa.stamp.ui.Messages;
import net.astah.stpa.stamp.ui.control.ModifyControlStructureDiagramElementsCommand;
import net.astah.table.Tuple;
import net.astah.table.ui.Tables;
import net.astah.table.ui.swing.TableCellDialogPanel;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class InputOutputDialogPanel
extends TableCellDialogPanel
implements ActionListener {
    private static final long serialVersionUID = 7244982310002778620L;
    private static final int DIALOG_WIDTH = 500;
    private static final int DIALOG_HEIGHT = 260;
    private static final boolean INPUT = true;
    private static final boolean OUTPUT = false;
    private final EClass createEClass;
    private JTable table;
    private JButton addInputButton;
    private JButton addOutputButton;
    private JButton deleteButton;
    private Component component;
    private Signal selectingSignal;

    public InputOutputDialogPanel(IPropertySourceProvider propertySourceProvider, @NonNull EClass createEClass) {
        super(propertySourceProvider);
        if (createEClass == null) {
            throw new NullPointerException("createEClass");
        }
        this.createEClass = createEClass;
        this.setPreferredSize(new Dimension(500, 260));
    }

    protected String getHeaderText() {
        return Messages.component_extracting_table_input_output_label;
    }

    protected void setInput(Object object, JTable baseTable, int row, int column) {
        ContentTableModel baseTableModel = (ContentTableModel)baseTable.getModel();
        Tuple tempTuple = (Tuple)baseTableModel.getRowAt(row);
        Tuple tableRowTuple = (Tuple)tempTuple.getGrid().getRowTuples().get(row);
        this.component = (Component)tableRowTuple.getElementObject(0);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.component);
        AdapterFactory adapterFactory = ItemProviders.getAdapterFactory((EditingDomain)domain);
        ((JTableBuilder)((JTableBuilder)JTableBuilder.builder((EditingDomain)domain).adapterFactory(adapterFactory)).addColumn((ITableColumnProvider.IColumnDescriptor)TableColumnProvider.label((String)Messages.io_dialog_panel_io_header, (ILabelProvider)this.getInOutLabelProvider()).setLineWrap(true).setClickCountToStart(2)).addColumn((ITableColumnProvider.IColumnDescriptor)TableColumnProvider.idProperty((String)Messages.io_dialog_panel_contents_header, (Object)"name").setLineWrap(true).setClickCountToStart(2)).contentProvider((IContentProvider)this.createContentProvider(domain, adapterFactory))).reorderingAllowed(false).input((Object)this.component).build(this.table);
        this.table.setFont(baseTable.getFont());
        this.table.getTableHeader().setFont(baseTable.getFont());
        Enumeration<TableColumn> columns = this.table.getColumnModel().getColumns();
        for (float ratio : this.getColumnsWidthRatio()) {
            if (!columns.hasMoreElements()) continue;
            columns.nextElement().setPreferredWidth((int)(500.0f * ratio));
        }
    }

    protected AdapterFactoryContentProvider createContentProvider(TransactionalEditingDomain domain, AdapterFactory adapterFactory) {
        TransactionalFeaturePathContentProvider contentProvider = new TransactionalFeaturePathContentProvider(domain, adapterFactory){

            public Collection<?> getElements(Object object) {
                return Streams.stream((Collection)super.getElements(object), Signal.class).filter(signal -> InputOutputDialogPanel.this.isIoSignal(signal, InputOutputDialogPanel.this.component)).collect(Collectors.toList());
            }
        };
        contentProvider.addPath(EFeaturePath.builder().addInverse(STAMPPackage.Literals.LINK__SOURCE).add((EStructuralFeature)STAMPPackage.Literals.CONTROL_LINK__ACTION).create());
        contentProvider.addPath(EFeaturePath.builder().addInverse(STAMPPackage.Literals.LINK__TARGET).add((EStructuralFeature)STAMPPackage.Literals.CONTROL_LINK__ACTION).create());
        contentProvider.addPath(EFeaturePath.builder().addInverse(STAMPPackage.Literals.LINK__SOURCE).add((EStructuralFeature)STAMPPackage.Literals.FEEDBACK_LINK__FEEDBACK).create());
        contentProvider.addPath(EFeaturePath.builder().addInverse(STAMPPackage.Literals.LINK__TARGET).add((EStructuralFeature)STAMPPackage.Literals.FEEDBACK_LINK__FEEDBACK).create());
        return contentProvider;
    }

    protected float[] getColumnsWidthRatio() {
        return new float[]{0.5f, 0.5f};
    }

    protected void initComponent(IPropertySourceProvider propertySourceProvider) {
        this.table = new GenericTable();
        EditableTextComponentMouseAdapther.install((JTable)this.table);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.addInputButton = new JButton(Messages.io_dialog_panel_add_input_button);
        this.addInputButton.addActionListener(this);
        this.addOutputButton = new JButton(Messages.io_dialog_panel_add_output_button);
        this.addOutputButton.addActionListener(this);
        this.deleteButton = new JButton(Messages.stpa_dialog_panel_delete_button);
        this.deleteButton.addActionListener(this);
        this.deleteButton.setEnabled(false);
        this.table.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                int selectedCount = this.table.getSelectedRowCount();
                this.deleteButton.setEnabled(selectedCount > 0);
            }
        });
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(2, 10, 2, 10);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(scrollPane, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(2, 20, 2, 20);
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        this.add(new JLabel(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.add(this.addInputButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.add(this.addOutputButton, gbc);
        gbc.gridx = 2;
        gbc.gridy = 1;
        this.add(this.deleteButton, gbc);
    }

    private ILabelProvider getInOutLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                Link link = ((Signal)element).getLink();
                if (InputOutputDialogPanel.this.isInput(link, InputOutputDialogPanel.this.component)) {
                    return Messages.io_dialog_panel_input_value;
                }
                if (InputOutputDialogPanel.this.isOutput(link, InputOutputDialogPanel.this.component)) {
                    return Messages.io_dialog_panel_output_value;
                }
                return null;
            }
        };
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.stopCellEditing();
        CompoundCommand command = new CompoundCommand();
        final TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.component);
        Object source = e.getSource();
        if (source == this.addInputButton) {
            this.selectingSignal = this.createSignal(domain, true, command);
        } else if (source == this.addOutputButton) {
            this.selectingSignal = this.createSignal(domain, false, command);
        } else if (source == this.deleteButton) {
            command.append(this.createDeleteCommands((EditingDomain)domain, this.table.getSelectedRows()));
        }
        if (source != this.deleteButton) {
            DeferringCommandWrapper modifyDiagramCommand = new DeferringCommandWrapper(){

                protected Command createCommand() {
                    ControlStructure controlStructure = (ControlStructure)EObjects.getAncestor(ControlStructure.class, (EObject)InputOutputDialogPanel.this.component);
                    return new ModifyControlStructureDiagramElementsCommand(domain, controlStructure);
                }
            };
            command.append((Command)modifyDiagramCommand);
        }
        CommandJob job = new CommandJob(domain, command.unwrap());
        if (source == this.addInputButton || source == this.addOutputButton) {
            Jobs.toCompletableFuture((Job)job, (boolean)true).thenRun(this::postExecute);
        }
        job.schedule();
    }

    protected void okHandler() {
        this.stopCellEditing();
        this.closeDialog();
    }

    protected void cancelHandler() {
        this.stopCellEditing();
        this.closeDialog();
    }

    private void closeDialog() {
        JTableBuilder.dispose((JTable)this.table);
        if (this.component != null) {
            this.component = null;
        }
    }

    private void stopCellEditing() {
        TableCellEditor cellEditor = this.table.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    protected Signal createSignal(TransactionalEditingDomain domain, boolean isInput, CompoundCommand command) {
        Signal signal = (Signal)EcoreUtil.create((EClass)this.createEClass);
        ControlStructure controlStructure = (ControlStructure)EObjects.getAncestor(ControlStructure.class, (EObject)this.component);
        Link link = isInput ? controlStructure.getLinks().stream().filter(m -> m.eClass() == STAMPPackage.Literals.CONTROL_LINK && this.isInput((Link)m, this.component)).findFirst().orElseGet(() -> {
            LinkEnd linkEnd = this.createLinkEnd(domain, controlStructure, command);
            return this.createControlLink((EditingDomain)domain, controlStructure, (LinkableElement)linkEnd, (LinkableElement)this.component, command);
        }) : controlStructure.getLinks().stream().filter(m -> m.eClass() == STAMPPackage.Literals.CONTROL_LINK && this.isOutput((Link)m, this.component)).findFirst().orElseGet(() -> {
            LinkEnd linkEnd = this.createLinkEnd(domain, controlStructure, command);
            return this.createControlLink((EditingDomain)domain, controlStructure, (LinkableElement)this.component, (LinkableElement)linkEnd, command);
        });
        command.append(CreateChildCommand.create((EditingDomain)domain, (Object)link, (Object)new CommandParameter((Object)link, (Object)STAMPPackage.Literals.LINK__SIGNAL, (Object)signal), Collections.singleton(link)));
        return signal;
    }

    protected LinkEnd createLinkEnd(TransactionalEditingDomain domain, ControlStructure owner, CompoundCommand command) {
        LinkEnd linkEnd = (LinkEnd)EcoreUtil.create((EClass)STAMPPackage.Literals.LINK_END);
        command.append(CreateChildCommand.create((EditingDomain)domain, (Object)owner, (Object)new CommandParameter((Object)owner, (Object)STAMPPackage.Literals.CONTROL_STRUCTURE__LINK_END, (Object)linkEnd), Collections.singleton(owner)));
        return linkEnd;
    }

    private boolean isInput(Link link, Component component) {
        return link.getSource() instanceof LinkEnd && link.getTarget() == component;
    }

    private boolean isOutput(Link link, Component component) {
        return link.getSource() == component && link.getTarget() instanceof LinkEnd;
    }

    private Link createControlLink(EditingDomain domain, Object owner, LinkableElement source, LinkableElement target, CompoundCommand command) {
        Link link = (Link)EcoreUtil.create((EClass)STAMPPackage.Literals.CONTROL_LINK);
        command.append(CreateChildCommand.create((EditingDomain)domain, (Object)owner, (Object)new CommandParameter(owner, (Object)STAMPPackage.Literals.CONTROL_STRUCTURE__LINK, (Object)link), Collections.singleton(owner)));
        command.append(SetCommand.create((EditingDomain)domain, (Object)link, (Object)STAMPPackage.Literals.LINK__SOURCE, (Object)source));
        command.append(SetCommand.create((EditingDomain)domain, (Object)link, (Object)STAMPPackage.Literals.LINK__TARGET, (Object)target));
        return link;
    }

    protected Command createDeleteCommands(EditingDomain domain, int[] rowIndices) {
        if (rowIndices != null && rowIndices.length > 0) {
            List elements = (List)this.getContentProvider().getElements((Object)this.component);
            CompoundCommand result = new CompoundCommand();
            for (int rowIndex : rowIndices) {
                result.append(DestroyCommand.create((EditingDomain)domain, elements.get(rowIndex)));
            }
            return result;
        }
        return IdentityCommand.INSTANCE;
    }

    private IStructuredContentProvider getContentProvider() {
        TableModel selectionModel = this.table.getModel();
        TransactionalContentProviderTableModel contentProviderModel = (TransactionalContentProviderTableModel)selectionModel;
        IStructuredContentProvider provider = contentProviderModel.getContentProvider();
        return provider;
    }

    private boolean isIoSignal(Signal signal, Component component) {
        Link link = signal.getLink();
        return this.isInput(link, component) || this.isOutput(link, component);
    }

    private void postExecute() {
        ContentTableModel tableModel = (ContentTableModel)this.table.getModel();
        int row = tableModel.getIndexOfRow((Object)this.selectingSignal);
        this.table.clearSelection();
        Tables.startCellEditing((JTable)this.table, (int)row, (int)1);
        this.selectingSignal = null;
    }
}

