/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.view.swing;

import com.google.common.base.Objects;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.astah.dd.di.Diagram;
import net.astah.emf.common.ecore.EComparators;
import net.astah.emf.common.ecore.EcoreCopier;
import net.astah.emf.common.notify.EFeaturePath;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.emf.edit.job.CommandJob;
import net.astah.emf.edit.job.Jobs;
import net.astah.emf.edit.provider.ExtraLabelVariant;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.emf.edit.provider.swing.AdapterFactoryVariantLabelProvider;
import net.astah.emf.edit.provider.swing.JTableBuilder;
import net.astah.emf.edit.provider.swing.PropertyEditorFactory;
import net.astah.emf.edit.provider.swing.PropertyEditorFactoryRegistryImpl;
import net.astah.emf.edit.provider.swing.editor.SingleEReferenceCellEditor;
import net.astah.emf.edit.provider.swing.renderer.LabelProviderListCellRenderer;
import net.astah.golf.control.CommandEvent;
import net.astah.golf.control.CommandManager;
import net.astah.golf.model.EntityStoreEvent;
import net.astah.golf.view.swing.ITableColumnProvider;
import net.astah.golf.widget.CJComponent;
import net.astah.golf.widget.swing.GenericTable;
import net.astah.golf.widget.swing.ILabelProvider;
import net.astah.jomt.jutil.SwingInvoker;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.Editor;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.swing.SwingTableEditorPeer;
import net.astah.notation.TableView;
import net.astah.stpa.stamp.ControlLoop;
import net.astah.stpa.stamp.HCFAnalysis;
import net.astah.stpa.stamp.HCFAnalysisResult;
import net.astah.stpa.stamp.HCFHintWordSet;
import net.astah.stpa.stamp.HazardCausalFactor;
import net.astah.stpa.stamp.STAMPFactory;
import net.astah.stpa.stamp.STAMPPackage;
import net.astah.stpa.stamp.STPAAnalysis;
import net.astah.stpa.stamp.UnsafeControlAction;
import net.astah.stpa.stamp.notation.HCFTable;
import net.astah.stpa.stamp.ui.Messages;
import net.astah.stpa.stamp.ui.control.OpenHintWordImageCommand;
import net.astah.stpa.stamp.ui.menu.handler.AddHazardCausalFactorHandler;
import net.astah.stpa.stamp.ui.menu.handler.DeleteHazardCausalFactorHandler;
import net.astah.stpa.stamp.ui.table.HCFScenarioCellEvaluator;
import net.astah.stpa.stamp.ui.table.HCFTableColumnProvider;
import net.astah.stpa.stamp.ui.view.HCFHintWordSetFrame;
import net.astah.stpa.stamp.ui.view.swing.STPATableEditorPeer;
import net.astah.stpa.stamp.util.HCFHintWordSets;
import net.astah.table.CellDescriptor;
import net.astah.table.DataQuery;
import net.astah.table.DynamicDataset;
import net.astah.table.Element;
import net.astah.table.ElementSet;
import net.astah.table.FeaturePath;
import net.astah.table.FixedDataset;
import net.astah.table.Grid;
import net.astah.table.IQueryExecutor;
import net.astah.table.JoinReference;
import net.astah.table.JoinType;
import net.astah.table.NativeCellDescriptor;
import net.astah.table.NativeDataQuery;
import net.astah.table.ObjectElement;
import net.astah.table.PropertyCellDescriptor;
import net.astah.table.Table;
import net.astah.table.TableFactory;
import net.astah.table.Tuple;
import net.astah.table.edit.provider.GenericTableAdapterFactory;
import net.astah.table.edit.provider.GridItemProviderDecorator;
import net.astah.table.ui.export.TableExcelExport;
import net.astah.table.ui.swing.GenericTableTableTransferHandler;
import net.astah.ui.menu.annotation.Context;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemProviderDecorator;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Context(id="net.astah.stpa.stamp.notation.HCFTable", classes={AddHazardCausalFactorHandler.class, DeleteHazardCausalFactorHandler.class})
public class HCFTableEditorPeer
extends STPATableEditorPeer
implements ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(HCFTableEditorPeer.class);
    public static final String ANNOTATION__HCF_TABLE = "hcfTable";
    public static final int HAZARD_CAUSAL_FACTOR__INDEX = 0;
    private JLabel ucaId;
    private JTextArea ucaDescription;
    private JComboBox<HCFHintWordSet> hwsComboBox;
    private JButton hwsButton;

    @Override
    public void initialize(Diagram diagram, CJComponent parent) {
        super.initialize(diagram, parent);
        JTable table = (JTable)this.getTable().getComponent();
        table.setCellSelectionEnabled(true);
    }

    public void update(EntityStoreEvent e) {
        super.update(e);
        this.updateUcaInfo();
    }

    private void updateUcaInfo() {
        HCFTable hcfTable = (HCFTable)this.getDiagram();
        if (AdapterFactoryEditingDomain.getEditingDomainFor((EObject)hcfTable) != null) {
            ControlLoop controlLoop = hcfTable.getControlLoop();
            UnsafeControlAction uca = hcfTable.getUnsafeControlAction();
            this.ucaId.setText("(" + uca.getId() + ")");
            this.ucaDescription.setText(uca.getDescription());
            this.ucaDescription.setFont(null);
            this.setSelectedItem(controlLoop.getHintWordSet());
        }
    }

    private void setSelectedItem(HCFHintWordSet selectedItem) {
        if (this.hwsComboBox.getSelectedItem() != selectedItem) {
            this.hwsComboBox.setSelectedItem(selectedItem);
        }
    }

    protected float[] getColumnsWidthRatio() {
        return new float[]{0.1f, 0.3f, 0.3f, 0.3f};
    }

    protected Table prepareTableModel(TableView view) {
        HCFTable hcfTable = (HCFTable)view;
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        annotation.setSource(ANNOTATION__HCF_TABLE);
        annotation.getReferences().add((Object)hcfTable);
        NativeDataQuery row0 = TableFactory.eINSTANCE.createNativeDataQuery();
        row0.getEAnnotations().add((Object)annotation);
        row0.setImplementationClass(HazardCausalFactorFactory.class);
        row0.setMetaclass(STAMPPackage.Literals.HAZARD_CAUSAL_FACTOR);
        JoinReference row1 = TableFactory.eINSTANCE.createJoinReference();
        EFeaturePath featurePath = EFeaturePath.builder().addInverse(STAMPPackage.Literals.HCF_ANALYSIS_RESULT__HAZARD_CAUSAL_FACTOR).create();
        HCFTableEditorPeer.applyFeaturePath((FeaturePath)row1, (EFeaturePath)featurePath);
        row1.setJoinType(JoinType.INNER);
        row1.setOrigin((DataQuery)row0);
        DynamicDataset row = TableFactory.eINSTANCE.createDynamicDataset();
        row.getQueries().addAll(Arrays.asList(row0, row1));
        ObjectElement columnId = TableFactory.eINSTANCE.createObjectElement();
        columnId.setHeader(TableFactory.eINSTANCE.createFixedCellDescriptor(Messages.hcf_table_hcf_id_label));
        PropertyCellDescriptor columnIdCell = TableFactory.eINSTANCE.createPropertyCellDescriptor();
        columnIdCell.setOrigin(row.getQueries().indexOf((Object)row0));
        HCFTableEditorPeer.applyFeaturePath((FeaturePath)columnIdCell, (EFeaturePath)EFeaturePath.build((EStructuralFeature)STAMPPackage.Literals.IDENTIFIED_ELEMENT__ID));
        columnId.setCell((CellDescriptor)columnIdCell);
        ObjectElement columnHcf = TableFactory.eINSTANCE.createObjectElement();
        columnHcf.setHeader(TableFactory.eINSTANCE.createFixedCellDescriptor(Messages.hcf_table_hcf_label));
        PropertyCellDescriptor columnHcfCell = TableFactory.eINSTANCE.createPropertyCellDescriptor();
        columnHcfCell.setOrigin(row.getQueries().indexOf((Object)row0));
        HCFTableEditorPeer.applyFeaturePath((FeaturePath)columnHcfCell, (EFeaturePath)EFeaturePath.build((EStructuralFeature)STAMPPackage.Literals.IDENTIFIED_ELEMENT__DESCRIPTION));
        columnHcfCell.setLineWrap(true);
        columnHcf.setCell((CellDescriptor)columnHcfCell);
        ObjectElement columnHintWord = TableFactory.eINSTANCE.createObjectElement();
        columnHintWord.setHeader(TableFactory.eINSTANCE.createFixedCellDescriptor(Messages.hcf_table_hint_word_label));
        PropertyCellDescriptor columnHintWordCell = TableFactory.eINSTANCE.createPropertyCellDescriptor();
        columnHintWordCell.setOrigin(row.getQueries().indexOf((Object)row1));
        HCFTableEditorPeer.applyFeaturePath((FeaturePath)columnHintWordCell, (EFeaturePath)EFeaturePath.build((EStructuralFeature)STAMPPackage.Literals.HCF_ANALYSIS_RESULT__HINT_WORD));
        columnHintWordCell.setLineWrap(true);
        columnHintWord.setCell((CellDescriptor)columnHintWordCell);
        ObjectElement columnScenario = TableFactory.eINSTANCE.createObjectElement();
        columnScenario.setHeader(TableFactory.eINSTANCE.createFixedCellDescriptor(Messages.hcf_table_hazard_scenario_label));
        NativeCellDescriptor columnScenarioCell = TableFactory.eINSTANCE.createNativeCellDescriptor();
        columnScenarioCell.setImplementationClass(HCFScenarioCellEvaluator.class);
        columnScenario.setCell((CellDescriptor)columnScenarioCell);
        ElementSet columnSet = TableFactory.eINSTANCE.createElementSet();
        columnSet.getElements().addAll(Arrays.asList(columnId, columnHcf, columnHintWord, columnScenario));
        FixedDataset column = TableFactory.eINSTANCE.createFixedDataset();
        column.getElementSets().add((Object)columnSet);
        Table table = TableFactory.eINSTANCE.createTable();
        table.getColumns().add((Object)column);
        table.getRows().add((Object)row);
        return table;
    }

    @Override
    protected JTable createJTable(AdapterFactory adapterFactory, Grid grid) {
        HCFTableColumnProvider columnProvider = new HCFTableColumnProvider();
        PropertyEditorFactoryRegistryImpl registry = new PropertyEditorFactoryRegistryImpl(PropertyEditorFactory.Registry.INSTANCE);
        SingleEReferenceCellEditor.DescriptorImpl factory = new SingleEReferenceCellEditor.DescriptorImpl(){

            protected Notifier resolveScope(Object object) {
                HCFTable hcfTable = (HCFTable)HCFTableEditorPeer.this.getDiagram();
                ControlLoop controlLoop = hcfTable.getControlLoop();
                return controlLoop.getHintWordSet();
            }
        };
        registry.getFeatureMap().put(STAMPPackage.Literals.HCF_ANALYSIS_RESULT__HINT_WORD, factory);
        columnProvider.setAdapterFactory(adapterFactory);
        columnProvider.setGrid(grid);
        TransactionalEditingDomain txDomain = TransactionUtil.getEditingDomain((EObject)this.getDiagram());
        return ((JTableBuilder)((JTableBuilder)((JTableBuilder)((JTableBuilder)JTableBuilder.builder((EditingDomain)txDomain).adapterFactory(adapterFactory)).columnProvider((ITableColumnProvider)columnProvider).transferHandler((TransferHandler)new GenericTableTableTransferHandler(txDomain, this.domain))).input((Object)grid).propertyEditorFactoryRegistry((PropertyEditorFactory.Registry)registry)).font(this.resolveTableFont())).reorderingAllowed(false).build((JTable)new GenericTable());
    }

    private STPAAnalysis getSTPAAnalysis() {
        HCFTable hcfTable = (HCFTable)this.getDiagram();
        ControlLoop controlLoop = hcfTable.getControlLoop();
        return controlLoop.getHintWordSet().getOwner();
    }

    protected AdapterFactory createTableAdapterFactory() {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.getDiagram());
        STPAAnalysis stpaAnalysis = this.getSTPAAnalysis();
        HCFAnalysis hcfAnalysis = stpaAnalysis.getHcfAnalysis();
        UnsafeControlAction uca = ((HCFTable)this.getDiagram()).getUnsafeControlAction();
        return new GenericTableAdapterFactory(ItemProviders.getAdapterFactory((EditingDomain)domain), (EditingDomain)domain, stpaAnalysis, uca, hcfAnalysis){
            final /* synthetic */ EditingDomain val$domain;
            final /* synthetic */ STPAAnalysis val$stpaAnalysis;
            final /* synthetic */ UnsafeControlAction val$uca;
            final /* synthetic */ HCFAnalysis val$hcfAnalysis;
            {
                this.val$domain = editingDomain;
                this.val$stpaAnalysis = sTPAAnalysis;
                this.val$uca = unsafeControlAction;
                this.val$hcfAnalysis = hCFAnalysis;
                super(x0);
            }

            protected IItemProviderDecorator createGridDecorator() {
                return new GridItemProviderDecorator((AdapterFactory)this){

                    protected Command createPrepareRowTupleCommand(Grid grid, Tuple tuple, EditingDomain domain) {
                        return this.prepareHazardCausalFactorCommand(tuple);
                    }

                    protected Command createMoveRowElementCommand(EObject owner, Tuple tuple, int index, EditingDomain defaultDomain) {
                        return this.createMoveHcfCommand(owner, tuple, index, val$domain);
                    }
                };
            }

            protected Command createMoveHcfCommand(EObject owner, Tuple tuple, int index, EditingDomain defaultDomain) {
                Tuple targetTuple = (Tuple)HCFTableEditorPeer.this.grid.getRowTuples().get(index);
                HazardCausalFactor target = (HazardCausalFactor)targetTuple.getElementObject(0);
                STPAAnalysis targetOwner = target.getOwner();
                int targetIndex = targetOwner.getHazardCausalFactors().indexOf((Object)target);
                EObject value = tuple.getElementObject(0);
                return MoveCommand.create((EditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)targetOwner), (Object)targetOwner, (Object)STAMPPackage.Literals.STPA_ANALYSIS__HAZARD_CAUSAL_FACTOR, (Object)value, (int)targetIndex);
            }

            protected Command prepareHazardCausalFactorCommand(Tuple rowTuple) {
                HazardCausalFactor hcf = STAMPFactory.eINSTANCE.createHazardCausalFactor();
                HCFAnalysisResult result = STAMPFactory.eINSTANCE.createHCFAnalysisResult();
                EList elements = rowTuple.getElements();
                ((Element)elements.get(0)).setObject((EObject)hcf);
                EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.val$stpaAnalysis);
                CompoundCommand command = new CompoundCommand();
                CommandParameter hcfDescription = new CommandParameter((Object)this.val$stpaAnalysis, (Object)STAMPPackage.Literals.STPA_ANALYSIS__HAZARD_CAUSAL_FACTOR, (Object)hcf);
                hcf.setUnsafeControlAction(this.val$uca);
                command.append(CreateChildCommand.create((EditingDomain)domain, (Object)this.val$stpaAnalysis, (Object)hcfDescription, Collections.singleton(this.val$stpaAnalysis)));
                result.setUnsafeControlAction(this.val$uca);
                result.getHazardCausalFactors().add((Object)hcf);
                CommandParameter resultDescriptor = new CommandParameter((Object)this.val$hcfAnalysis, (Object)STAMPPackage.Literals.HCF_ANALYSIS__RESULT, (Object)result);
                command.append(CreateChildCommand.create((EditingDomain)domain, (Object)this.val$hcfAnalysis, (Object)resultDescriptor, Collections.singleton(this.val$hcfAnalysis)));
                return command;
            }
        };
    }

    protected Container createNorthPanel() {
        Container panel = super.createNorthPanel();
        panel.add((Component)this.createUcaInfoPanel(), 0);
        this.updateUcaInfo();
        return panel;
    }

    private Container createUcaInfoPanel() {
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BoxLayout(infoPanel, 1));
        infoPanel.setBorder(new CompoundBorder(infoPanel.getBorder(), new EmptyBorder(10, 10, 0, 0)));
        JPanel ucaPanel = new JPanel();
        ucaPanel.setLayout(new BorderLayout(10, 0));
        this.ucaId = new JLabel();
        this.ucaDescription = new JTextArea();
        this.ucaDescription.setEditable(false);
        this.ucaDescription.setBackground(ucaPanel.getBackground());
        this.ucaDescription.setLineWrap(true);
        ucaPanel.add("West", this.ucaId);
        ucaPanel.add("Center", this.ucaDescription);
        JPanel hwsPanel = new JPanel();
        hwsPanel.setLayout(new BoxLayout(hwsPanel, 0));
        hwsPanel.add(new JLabel(Messages.hcf_table_info_hint_word_set_label));
        hwsPanel.add(Box.createHorizontalStrut(10));
        this.hwsComboBox = this.createHintWordSetComboBox();
        hwsPanel.add(this.hwsComboBox);
        hwsPanel.add(Box.createHorizontalStrut(10));
        this.hwsButton = new JButton(Messages.hcf_table_button_hint_word_label);
        this.hwsButton.addActionListener(this);
        hwsPanel.add(this.hwsButton);
        hwsPanel.add(Box.createHorizontalGlue());
        infoPanel.add(ucaPanel);
        infoPanel.add(Box.createVerticalStrut(10));
        infoPanel.add(hwsPanel);
        return infoPanel;
    }

    private JComboBox<HCFHintWordSet> createHintWordSetComboBox() {
        STPAAnalysis stpaAnalysis = this.getSTPAAnalysis();
        EList hintWordSets = HCFHintWordSets.getLanguageHintWordSets((STPAAnalysis)stpaAnalysis, (ResourceSet)this.domain.getResourceSet());
        DefaultComboBoxModel<Object> cmbModel = new DefaultComboBoxModel<Object>(hintWordSets.toArray((Object[])new HCFHintWordSet[0]));
        final JComboBox<Object> hwsComboBox = new JComboBox<Object>(cmbModel);
        hwsComboBox.addPropertyChangeListener("ancestor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    ((LabelProviderListCellRenderer)hwsComboBox.getRenderer()).dispose();
                }
            }
        });
        HCFTable hcfTable = (HCFTable)this.getDiagram();
        ControlLoop controlLoop = hcfTable.getControlLoop();
        HCFHintWordSet hintWordSet = controlLoop.getHintWordSet();
        if (hintWordSet != null) {
            hwsComboBox.setSelectedItem(hintWordSet);
        }
        LabelProviderListCellRenderer renderer = new LabelProviderListCellRenderer((ILabelProvider)new AdapterFactoryVariantLabelProvider(ItemProviders.getAdapterFactory((EObject)stpaAnalysis), (Object)ExtraLabelVariant.MODEL_LIST));
        hwsComboBox.setRenderer((ListCellRenderer<Object>)renderer);
        hwsComboBox.setEditable(false);
        Dimension preferredSize = hwsComboBox.getPreferredSize();
        preferredSize.width += 5;
        hwsComboBox.setPreferredSize(preferredSize);
        hwsComboBox.setMaximumSize(preferredSize);
        hwsComboBox.setMinimumSize(new Dimension(150, preferredSize.height));
        hwsComboBox.addActionListener(this);
        return hwsComboBox;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.hwsComboBox) {
            SwingInvoker.runLaterInEDT(() -> this.changeHintWordSet());
        } else if (e.getSource() == this.hwsButton) {
            this.toggleHintWordImage();
        }
    }

    private void changeHintWordSet() {
        HCFHintWordSet newSelectionHWS;
        int yesno;
        HCFTable hcfTable = (HCFTable)this.getDiagram();
        ControlLoop controlLoop = hcfTable.getControlLoop();
        HCFHintWordSet selectionHWS = (HCFHintWordSet)this.hwsComboBox.getSelectedItem();
        HCFHintWordSet selectedHWS = controlLoop.getHintWordSet();
        if (Objects.equal((Object)selectionHWS.getName(), (Object)selectedHWS.getName()) && Objects.equal((Object)selectionHWS.getLanguage(), (Object)selectedHWS.getLanguage())) {
            this.updateHintWordSetFrame();
            return;
        }
        this.stopEditing();
        STPAAnalysis stpaAnalysis = this.getSTPAAnalysis();
        HCFAnalysis hcfAnalysis = stpaAnalysis.getHcfAnalysis();
        if (hcfAnalysis.getResults().stream().anyMatch(result -> result.eIsSet((EStructuralFeature)STAMPPackage.Literals.HCF_ANALYSIS_RESULT__HINT_WORD) && this.isClearHintWord(controlLoop, (HCFAnalysisResult)result)) && (yesno = MessageManager.displayYesNoDialog((String)"", (String)Messages.hcf_table_ask_change_hint_word_set_label)) != 0) {
            this.hwsComboBox.setSelectedItem(selectedHWS);
            this.hwsComboBox.updateUI();
            return;
        }
        TransactionalEditingDomain txDomain = TransactionUtil.getEditingDomain((EObject)hcfTable);
        CompoundCommand command = new CompoundCommand();
        if (!HCFHintWordSets.isHCFHintWordSetPresent((HCFHintWordSet)selectionHWS, (STPAAnalysis)stpaAnalysis)) {
            EcoreCopier copier = new EcoreCopier();
            EObject copyObject = copier.copy((EObject)selectionHWS);
            command.append(AddCommand.create((EditingDomain)this.domain, (Object)stpaAnalysis, (Object)STAMPPackage.Literals.HCF_HINT_WORD_SET, (Object)copyObject));
            newSelectionHWS = (HCFHintWordSet)copyObject;
            this.hwsComboBox.insertItemAt(newSelectionHWS, stpaAnalysis.getHCFHintWordSets().size());
        } else {
            newSelectionHWS = HCFHintWordSets.getHintWordSetInProject((HCFHintWordSet)selectionHWS, (STPAAnalysis)stpaAnalysis);
        }
        hcfAnalysis.getResults().forEach(result -> {
            if (this.isClearHintWord(controlLoop, (HCFAnalysisResult)result)) {
                command.append(SetCommand.create((EditingDomain)txDomain, (Object)result, (Object)STAMPPackage.Literals.HCF_ANALYSIS_RESULT__HINT_WORD, (Object)SetCommand.UNSET_VALUE));
            }
        });
        command.append(SetCommand.create((EditingDomain)txDomain, (Object)controlLoop, (Object)STAMPPackage.Literals.CONTROL_LOOP__HINT_WORD_SET, (Object)newSelectionHWS));
        this.hwsComboBox.updateUI();
        CommandJob job = new CommandJob(txDomain, command.unwrap());
        Jobs.toCompletableFuture((Job)job, (boolean)true).thenRun(this::updateHintWordSetFrame);
        job.schedule();
    }

    private boolean isClearHintWord(ControlLoop controlLoop, HCFAnalysisResult result) {
        return controlLoop.getTargetLink().getActions().contains((Object)result.getUnsafeControlAction().getControlAction());
    }

    private void toggleHintWordImage() {
        OpenHintWordImageCommand cmd = new OpenHintWordImageCommand();
        CommandEvent event = new CommandEvent((Object)this, 0, "", (net.astah.golf.control.Command)cmd, 0, 1);
        CommandManager.instance().commandPerformed(event);
    }

    @Override
    public void tableEditorActivated(Editor previousEditor) {
        super.tableEditorActivated(previousEditor);
        if (previousEditor != null && previousEditor.getEditorPeer() == this) {
            return;
        }
        if (this.hwsComboBox != null) {
            STPAAnalysis analysis = this.getSTPAAnalysis();
            EList hintWordSets = HCFHintWordSets.getLanguageHintWordSets((STPAAnalysis)analysis, (ResourceSet)analysis.eResource().getResourceSet());
            HCFTable hcfTable = (HCFTable)this.getDiagram();
            HCFHintWordSet selectedHWS = hcfTable.getControlLoop().getHintWordSet();
            boolean thisIsLintening = Arrays.asList(this.hwsComboBox.getActionListeners()).contains(this);
            this.hwsComboBox.removeActionListener(this);
            this.hwsComboBox.removeAllItems();
            for (int i = 0; i < hintWordSets.size(); ++i) {
                this.hwsComboBox.insertItemAt((HCFHintWordSet)hintWordSets.get(i), i);
            }
            this.hwsComboBox.setSelectedItem(selectedHWS);
            if (thisIsLintening) {
                this.hwsComboBox.addActionListener(this);
            }
        }
        this.updateHintWordSetFrame();
    }

    private void updateHintWordSetFrame() {
        HCFTable hcfTable = (HCFTable)this.getDiagram();
        if (AdapterFactoryEditingDomain.getEditingDomainFor((EObject)hcfTable) == null) {
            return;
        }
        HCFHintWordSetFrame frame = (HCFHintWordSetFrame)DiagramEditor.getPaletteframe();
        if (frame == null) {
            return;
        }
        ControlLoop controlLoop = hcfTable.getControlLoop();
        frame.updateComboBox(controlLoop);
        try {
            frame.update();
        }
        catch (IOException e) {
            LOGGER.error("Update HCFHintWordSetFrame failed.", (Throwable)e);
        }
    }

    protected JButton createExportButton() {
        return new SwingTableEditorPeer.ExportExcelButton(){
            private static final long serialVersionUID = 1L;

            protected void exportFile(JTable table, String path) {
                HCFTable hcfTable = (HCFTable)HCFTableEditorPeer.this.getDiagram();
                UnsafeControlAction uca = hcfTable.getUnsafeControlAction();
                table.setName(uca.getId());
                new TableExcelExport(table).export(path);
            }
        };
    }

    public static class HazardCausalFactorFactory
    implements IQueryExecutor.Provider {
        public IQueryExecutor createExecutor(final DataQuery dataQuery) {
            return new IQueryExecutor(){

                public Iterator<? extends EObject> executeQuery(EMap<DataQuery, EObject> dependencies) {
                    EAnnotation annotation = dataQuery.getEAnnotation(HCFTableEditorPeer.ANNOTATION__HCF_TABLE);
                    HCFTable table = (HCFTable)annotation.getReferences().get(0);
                    UnsafeControlAction uca = table.getUnsafeControlAction();
                    EFeaturePath path = EFeaturePath.build((EStructuralFeature)STAMPPackage.Literals.HAZARD_CAUSAL_FACTOR__UNSAFE_CONTROL_ACTION);
                    return path.getInverseReferences((EObject)uca).stream().sorted(EComparators.eObjectPath()).iterator();
                }
            };
        }

        public Command createDeleteElementObjectCommand(EditingDomain domain, DataQuery dataQuery, Tuple tuple) {
            EObject element;
            int index = dataQuery.getIndexOfDataset();
            if (index == 0 && (element = tuple.getElementObject(index)) != null) {
                EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)element);
                CompoundCommand command = new CompoundCommand();
                command.append(SetCommand.create((EditingDomain)editingDomain, (Object)element, (Object)STAMPPackage.Literals.HAZARD_CAUSAL_FACTOR__UNSAFE_CONTROL_ACTION, (Object)SetCommand.UNSET_VALUE));
                command.append(DestroyCommand.create((EditingDomain)editingDomain, Collections.singleton(element)));
                return command.unwrap();
            }
            return UnexecutableCommand.INSTANCE;
        }
    }
}

