/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.view.swing;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import net.astah.emf.common.notify.EFeaturePath;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.emf.edit.job.CommandJob;
import net.astah.emf.edit.job.Jobs;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.emf.edit.provider.swing.AdapterFactoryContentProvider;
import net.astah.emf.edit.provider.swing.JTableBuilder;
import net.astah.emf.edit.provider.swing.TransactionalContentProviderTableModel;
import net.astah.emf.edit.provider.swing.TransactionalFeaturePathContentProvider;
import net.astah.golf.view.swing.IPropertySourceProvider;
import net.astah.golf.view.swing.ITableColumnProvider;
import net.astah.golf.view.swing.TableColumnProvider;
import net.astah.golf.widget.swing.ContentTableModel;
import net.astah.golf.widget.swing.GenericTable;
import net.astah.golf.widget.swing.IContentProvider;
import net.astah.golf.widget.swing.IStructuredContentProvider;
import net.astah.golf.widget.swing.SwingIconRegistry;
import net.astah.jomt.jview.EditableTextComponentMouseAdapther;
import net.astah.stpa.stamp.Element;
import net.astah.stpa.stamp.HazardCausalFactor;
import net.astah.stpa.stamp.HazardScenario;
import net.astah.stpa.stamp.STAMPFactory;
import net.astah.stpa.stamp.STAMPPackage;
import net.astah.stpa.stamp.ui.Messages;
import net.astah.table.Tuple;
import net.astah.table.ui.Tables;
import net.astah.table.ui.swing.TableCellDialogPanel;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class HCFScenarioDialogPanel
extends TableCellDialogPanel
implements ActionListener {
    private static final long serialVersionUID = -7596620116731878186L;
    private static final int DIALOG_WIDTH = 500;
    private static final int DIALOG_HEIGHT = 600;
    private JTable table;
    private JButton addButton;
    private JButton deleteButton;
    private JButton upButton;
    private JButton downButton;
    private HazardCausalFactor hcf;
    private Tuple hcfTableRowTuple;

    public HCFScenarioDialogPanel(IPropertySourceProvider propertySourceProvider) {
        super(propertySourceProvider);
        this.setPreferredSize(new Dimension(SwingIconRegistry.scaleValue((int)500), SwingIconRegistry.scaleValue((int)600)));
    }

    protected void setInput(Object object, JTable baseTable, int row, int column) {
        ContentTableModel baseTableModel = (ContentTableModel)baseTable.getModel();
        Tuple tempTuple = (Tuple)baseTableModel.getRowAt(row);
        Tuple tableRowTuple = (Tuple)tempTuple.getGrid().getRowTuples().get(row);
        this.hcfTableRowTuple = (Tuple)tempTuple.getGrid().getRowTuples().get(row);
        this.hcf = (HazardCausalFactor)tableRowTuple.getElementObject(0);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.hcf);
        AdapterFactory adapterFactory = ItemProviders.getAdapterFactory((EditingDomain)domain);
        ((JTableBuilder)((JTableBuilder)JTableBuilder.builder((EditingDomain)domain).adapterFactory(adapterFactory)).addColumn((ITableColumnProvider.IColumnDescriptor)TableColumnProvider.idProperty((String)Messages.hcf_dialog_panel_scenario_header, (Set)Sets.newHashSet((Object[])new Object[]{"description"})).setLineWrap(true).setClickCountToStart(2)).contentProvider((IContentProvider)this.createContentProvider(domain, adapterFactory))).reorderingAllowed(false).input((Object)this.hcf).build(this.table);
        this.table.setFont(baseTable.getFont());
        this.table.getTableHeader().setFont(baseTable.getFont());
    }

    protected AdapterFactoryContentProvider createContentProvider(TransactionalEditingDomain domain, AdapterFactory adapterFactory) {
        TransactionalFeaturePathContentProvider contentProvider = new TransactionalFeaturePathContentProvider(domain, adapterFactory);
        contentProvider.addPath(EFeaturePath.builder().add((EStructuralFeature)STAMPPackage.Literals.HAZARD_CAUSAL_FACTOR__HAZARD_SCENARIO).inclusive(true).create());
        return contentProvider;
    }

    protected void initComponent(IPropertySourceProvider propertySourceProvider) {
        this.table = new GenericTable();
        EditableTextComponentMouseAdapther.install((JTable)this.table);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.addButton = new JButton(Messages.stpa_dialog_panel_add_button);
        this.addButton.addActionListener(this);
        this.deleteButton = new JButton(Messages.stpa_dialog_panel_delete_button);
        this.deleteButton.addActionListener(this);
        this.deleteButton.setEnabled(false);
        this.upButton = new JButton(Messages.stpa_dialog_panel_up_button);
        this.upButton.addActionListener(this);
        this.upButton.setEnabled(false);
        this.downButton = new JButton(Messages.stpa_dialog_panel_down_button);
        this.downButton.addActionListener(this);
        this.downButton.setEnabled(false);
        this.table.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                int selectedCount = this.table.getSelectedRowCount();
                this.deleteButton.setEnabled(selectedCount > 0);
                this.upButton.setEnabled(selectedCount == 1);
                this.downButton.setEnabled(selectedCount == 1);
            }
        });
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(2, 10, 2, 10);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(scrollPane, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(2, 20, 2, 20);
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        this.add(new JLabel(), gbc);
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.add(this.addButton, gbc);
        gbc.gridx = 2;
        gbc.gridy = 1;
        this.add(this.deleteButton, gbc);
        gbc.gridx = 3;
        gbc.gridy = 1;
        this.add(new JLabel(), gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        this.add(this.upButton, gbc);
        gbc.gridx = 2;
        gbc.gridy = 2;
        this.add(this.downButton, gbc);
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        Element element;
        CompoundCommand command = new CompoundCommand();
        TransactionalEditingDomain domain = null;
        domain = TransactionUtil.getEditingDomain((EObject)this.hcf);
        HazardScenario tempSelectedHazardScenario = null;
        int selectedRowIndex = this.table.getSelectedRow();
        if (e.getSource() == this.addButton) {
            tempSelectedHazardScenario = this.createScenario(domain, selectedRowIndex, command);
        } else if (e.getSource() == this.deleteButton) {
            List<Integer> rowIndexes = Arrays.stream(this.table.getSelectedRows()).boxed().collect(Collectors.toList());
            command.append(this.createDeleteCommands(domain, rowIndexes));
        } else if (e.getSource() == this.upButton) {
            element = (Element)this.hcf.getHazardScenarios().get(selectedRowIndex);
            tempSelectedHazardScenario = (HazardScenario)element;
            command.append(this.createMoveUpCommand(domain, selectedRowIndex, element));
        } else if (e.getSource() == this.downButton) {
            element = (Element)this.hcf.getHazardScenarios().get(selectedRowIndex);
            tempSelectedHazardScenario = (HazardScenario)element;
            command.append(this.createMoveDownCommand(domain, selectedRowIndex, element));
        }
        final HazardScenario selectedHazardScenario = tempSelectedHazardScenario;
        CommandJob job = new CommandJob(domain, command.unwrap());
        if (e.getSource() != this.deleteButton) {
            Jobs.toCompletableFuture((Job)job, (boolean)true).thenRun(new Runnable(){

                @Override
                public void run() {
                    HCFScenarioDialogPanel.this.postExecute(e.getSource() == HCFScenarioDialogPanel.this.addButton, selectedHazardScenario);
                }
            });
        }
        job.schedule();
    }

    protected void okHandler() {
        this.stopCellEditing();
        this.closeDialog();
    }

    protected void cancelHandler() {
        this.stopCellEditing();
        this.closeDialog();
    }

    private void closeDialog() {
        JTableBuilder.dispose((JTable)this.table);
        if (this.hcf != null) {
            this.hcf = null;
        }
    }

    private void stopCellEditing() {
        TableCellEditor cellEditor = this.table.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    protected HazardScenario createScenario(TransactionalEditingDomain domain, int selectedIndex, CompoundCommand command) {
        HazardScenario scenario = STAMPFactory.eINSTANCE.createHazardScenario();
        scenario.setDescription(Messages.hcf_dialog_panel_scenario_default_description);
        HazardCausalFactor hcf = (HazardCausalFactor)((net.astah.table.Element)this.hcfTableRowTuple.getElements().get(0)).getObject();
        int index = 0 <= selectedIndex && selectedIndex < hcf.getHazardScenarios().size() - 1 ? selectedIndex + 1 : -1;
        command.append(AddCommand.create((EditingDomain)domain, (Object)hcf, (Object)STAMPPackage.Literals.HAZARD_CAUSAL_FACTOR__HAZARD_SCENARIO, (Object)scenario, (int)index));
        return scenario;
    }

    protected Command createDeleteCommands(TransactionalEditingDomain domain, List<Integer> deleteIndexes) {
        List rowIndexes = Arrays.stream(this.table.getSelectedRows()).boxed().collect(Collectors.toList());
        if (rowIndexes != null && !rowIndexes.isEmpty()) {
            Set deleteElements = rowIndexes.stream().map(idx -> (HazardScenario)this.hcf.getHazardScenarios().get(idx.intValue())).collect(Collectors.toSet());
            return DestroyCommand.create((EditingDomain)domain, deleteElements);
        }
        return IdentityCommand.INSTANCE;
    }

    protected Command createMoveUpCommand(TransactionalEditingDomain domain, int rowIndex, Element element) {
        return MoveCommand.create((EditingDomain)domain, (Object)this.hcf, (Object)STAMPPackage.Literals.HAZARD_CAUSAL_FACTOR__HAZARD_SCENARIO, (Object)element, (int)(rowIndex - 1));
    }

    protected Command createMoveDownCommand(TransactionalEditingDomain domain, int rowIndex, Element element) {
        return MoveCommand.create((EditingDomain)domain, (Object)this.hcf, (Object)STAMPPackage.Literals.HAZARD_CAUSAL_FACTOR__HAZARD_SCENARIO, (Object)element, (int)(rowIndex + 1));
    }

    private IStructuredContentProvider getContentProvider() {
        TableModel selectionModel = this.table.getModel();
        TransactionalContentProviderTableModel contentProviderModel = (TransactionalContentProviderTableModel)selectionModel;
        IStructuredContentProvider provider = contentProviderModel.getContentProvider();
        return provider;
    }

    private void postExecute(boolean isStartCellEditing, HazardScenario selectedHazardScenario) {
        Collection elements = this.getContentProvider().getElements((Object)this.hcf);
        int index = Iterables.indexOf((Iterable)elements, input -> input == selectedHazardScenario);
        if (isStartCellEditing) {
            Tables.startCellEditing((JTable)this.table, (int)index, (int)0);
        }
        this.table.setRowSelectionInterval(index, index);
    }
}

