/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.view.proptab;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.emf.edit.job.CommandJob;
import net.astah.emf.edit.job.Jobs;
import net.astah.emf.edit.provider.ExtraLabelVariant;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.emf.edit.provider.swing.AdapterFactoryVariantLabelProvider;
import net.astah.emf.edit.provider.swing.DecoratorJTreeBuilder;
import net.astah.emf.edit.provider.swing.EditingDomainTreeTransferHandler;
import net.astah.emf.edit.provider.swing.JTreeBuilder;
import net.astah.golf.widget.IBaseLabelProvider;
import net.astah.jomt.jview.JomtTree;
import net.astah.jomt.jview.swing.TreeNodeExpander;
import net.astah.stpa.stamp.Component;
import net.astah.stpa.stamp.ProcessModel;
import net.astah.stpa.stamp.ProcessValue;
import net.astah.stpa.stamp.ProcessVariable;
import net.astah.stpa.stamp.STAMPFactory;
import net.astah.stpa.stamp.STAMPPackage;
import net.astah.stpa.stamp.ui.Messages;
import net.astah.stpa.stamp.ui.view.proptab.STAMPModelTab;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class STAMPProcessModelTab
extends STAMPModelTab
implements ActionListener {
    private static final long serialVersionUID = 6143077688312421486L;
    private JPanel processModelPanel;
    private JButton createProcessModelButton = new JButton(Messages.stamp_process_model_tab_create_process_model_label);
    private JTree processModelTree;
    private final JMenuItem deleteProcessModelMenu;
    private final JMenuItem addVariableMenu;
    private final JMenuItem deleteVariableMenu;
    private final JMenuItem addValueMenu;
    private final JMenuItem deleteValueMenu;

    public STAMPProcessModelTab() {
        this.createProcessModelButton.addActionListener(this);
        this.deleteProcessModelMenu = new JMenuItem(Messages.stamp_process_model_tab_delete_process_model_label);
        this.deleteProcessModelMenu.addActionListener(this);
        this.addVariableMenu = new JMenuItem(Messages.stamp_process_model_tab_add_variable_label);
        this.addVariableMenu.addActionListener(this);
        this.deleteVariableMenu = new JMenuItem(Messages.stamp_process_model_tab_delete_variable_label);
        this.deleteVariableMenu.addActionListener(this);
        this.addValueMenu = new JMenuItem(Messages.stamp_process_model_tab_add_value_label);
        this.addValueMenu.addActionListener(this);
        this.deleteValueMenu = new JMenuItem(Messages.stamp_process_model_tab_delete_value_label);
        this.deleteValueMenu.addActionListener(this);
    }

    public void refresh(Object element) {
        super.refresh(element);
        if (!(element instanceof Component)) {
            return;
        }
        Component model = (Component)element;
        if (Arrays.asList(this.processModelPanel.getComponents()).contains(this.createProcessModelButton)) {
            if (model.getProcessModel() != null) {
                this.initPanel();
            }
        } else if (model.getProcessModel() == null) {
            this.initPanel();
        }
        this.updateUI();
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.removeAll();
        this.processModelPanel = new JPanel();
        this.processModelPanel.setLayout(new BorderLayout());
        if (this.model instanceof Component) {
            if (!this.hasProcessModel(this.model)) {
                this.processModelPanel.add((java.awt.Component)this.createProcessModelButton, "North");
            } else {
                ProcessModel processModel = ((Component)this.model).getProcessModel();
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)processModel);
                this.processModelTree = new JomtTree();
                AdapterFactory adapterFactory = ItemProviders.getAdapterFactory((EditingDomain)domain);
                ((JTreeBuilder)((JTreeBuilder)DecoratorJTreeBuilder.builder((EditingDomain)domain).labelProvider((IBaseLabelProvider)new AdapterFactoryVariantLabelProvider(adapterFactory, (Object)ExtraLabelVariant.NAME))).transferHandler((TransferHandler)new EditingDomainTreeTransferHandler((EditingDomain)domain))).root((Object)processModel).editable(true).build(this.processModelTree);
                this.processModelTree.setAutoscrolls(true);
                new TreeNodeExpander(this.processModelTree);
                this.processModelTree.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (SwingUtilities.isRightMouseButton(e)) {
                            TreePath path = STAMPProcessModelTab.this.processModelTree.getClosestPathForLocation(e.getX(), e.getY());
                            STAMPProcessModelTab.this.processModelTree.setSelectionPath(path);
                            Object selectingObject = path.getLastPathComponent();
                            JPopupMenu popupMenu = new JPopupMenu();
                            if (selectingObject instanceof ProcessModel) {
                                popupMenu.add(STAMPProcessModelTab.this.addVariableMenu);
                                popupMenu.add(STAMPProcessModelTab.this.deleteProcessModelMenu);
                            } else if (selectingObject instanceof ProcessVariable) {
                                popupMenu.add(STAMPProcessModelTab.this.addVariableMenu);
                                popupMenu.add(STAMPProcessModelTab.this.deleteVariableMenu);
                                popupMenu.add(STAMPProcessModelTab.this.addValueMenu);
                            } else if (selectingObject instanceof ProcessValue) {
                                popupMenu.add(STAMPProcessModelTab.this.addValueMenu);
                                popupMenu.add(STAMPProcessModelTab.this.deleteValueMenu);
                            } else {
                                return;
                            }
                            popupMenu.show(e.getComponent(), e.getX(), e.getY());
                            e.consume();
                        }
                    }
                });
                JScrollPane scrollPane = new JScrollPane(this.processModelTree);
                this.processModelPanel.add((java.awt.Component)scrollPane, "Center");
            }
        }
        this.processModelPanel.updateUI();
        this.add(this.processModelPanel);
    }

    @Override
    void initPanelRows() {
    }

    private boolean hasProcessModel(EObject model) {
        return model.eIsSet((EStructuralFeature)STAMPPackage.Literals.COMPONENT__PROCESS_MODEL);
    }

    public String getTabName() {
        return Messages.projectview_process_model_tab_title;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Command command = null;
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.model);
        if (e.getSource() == this.createProcessModelButton) {
            command = CreateChildCommand.create((EditingDomain)domain, (Object)this.model, (Object)new CommandParameter((Object)this.model, (Object)STAMPPackage.Literals.COMPONENT__PROCESS_MODEL, (Object)STAMPFactory.eINSTANCE.createProcessModel()), Collections.singleton(this.model));
        } else {
            Object selectedModel = this.processModelTree.getSelectionPath().getLastPathComponent();
            if (e.getSource() == this.addVariableMenu) {
                ProcessVariable processVariable = STAMPFactory.eINSTANCE.createProcessVariable();
                Object owner = null;
                if (selectedModel instanceof ProcessModel) {
                    owner = selectedModel;
                } else if (selectedModel instanceof ProcessVariable) {
                    owner = ((ProcessVariable)selectedModel).eContainer();
                } else {
                    return;
                }
                command = CreateChildCommand.create((EditingDomain)domain, (Object)owner, (Object)new CommandParameter(owner, (Object)STAMPPackage.Literals.PROCESS_MODEL__VARIABLE, (Object)processVariable), Collections.singleton(owner));
            } else if (e.getSource() == this.addValueMenu) {
                ProcessValue processValue = STAMPFactory.eINSTANCE.createProcessValue();
                Object owner = null;
                if (selectedModel instanceof ProcessVariable) {
                    owner = selectedModel;
                } else if (selectedModel instanceof ProcessValue) {
                    owner = ((ProcessValue)selectedModel).eContainer();
                } else {
                    return;
                }
                command = CreateChildCommand.create((EditingDomain)domain, (Object)owner, (Object)new CommandParameter(owner, (Object)STAMPPackage.Literals.PROCESS_VARIABLE__VALUE, (Object)processValue), Collections.singleton(owner));
            } else if (e.getSource() == this.deleteProcessModelMenu) {
                command = DestroyCommand.create((EditingDomain)domain, (Object)selectedModel);
            } else if (e.getSource() == this.deleteVariableMenu) {
                command = DestroyCommand.create((EditingDomain)domain, (Object)selectedModel);
            } else if (e.getSource() == this.deleteValueMenu) {
                command = DestroyCommand.create((EditingDomain)domain, (Object)selectedModel);
            } else {
                return;
            }
        }
        CommandJob job = new CommandJob(domain, command);
        Jobs.toCompletableFuture((Job)job, (boolean)true);
        job.schedule();
    }
}

