/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import net.astah.emf.edit.provider.ExtraLabelVariant;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.emf.edit.provider.swing.AdapterFactoryVariantLabelProvider;
import net.astah.emf.edit.provider.swing.renderer.LabelProviderListCellRenderer;
import net.astah.golf.widget.swing.ILabelProvider;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.KeyDialog;
import net.astah.stpa.stamp.NamedElement;
import org.eclipse.emf.ecore.EObject;

public class SelectNamedElementDialog
extends KeyDialog
implements ActionListener {
    private static final long serialVersionUID = -1L;
    private int resultState = 2;
    private NamedElement element;
    private List<NamedElement> elementList;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    private JComboBox<NamedElement> comboBox;
    private String description = null;

    public SelectNamedElementDialog(Frame owner, List<NamedElement> elementList, NamedElement selectedElement) {
        super(owner, true);
        this.elementList = elementList;
        this.setBounds((int)owner.getBounds().getCenterX(), (int)owner.getBounds().getCenterY(), 400, 100);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        this.comboBox = this.createJCombobox();
        if (selectedElement != null) {
            this.comboBox.setSelectedItem(selectedElement);
        }
        contentPane.add(this.comboBox);
        contentPane.add(this.createOkPanel());
    }

    private Component createOkPanel() {
        JPanel okPanel = new JPanel(new FlowLayout(2));
        JButton okButton = new JButton(PropertyManager.getProjectViewResourceBundle().getString("projectview.button.ok.label"));
        okButton.setActionCommand("OK");
        okButton.addActionListener(this);
        JButton cancelButton = new JButton(PropertyManager.getProjectViewResourceBundle().getString("projectview.button.cancel.label"));
        cancelButton.setActionCommand("CANCEL");
        cancelButton.addActionListener(this);
        if (PropertyManager.isMacOS()) {
            okPanel.add(cancelButton);
            okPanel.add(okButton);
        } else {
            okPanel.add(okButton);
            okPanel.add(cancelButton);
        }
        JPanel okBasePanel = new JPanel(new BorderLayout());
        okBasePanel.add((Component)new JSeparator(), "Center");
        okBasePanel.add((Component)okPanel, "South");
        return okBasePanel;
    }

    private JComboBox<NamedElement> createJCombobox() {
        JComboBox<NamedElement> cmb = new JComboBox<NamedElement>(this.elementList.toArray(new NamedElement[0]));
        cmb.setRenderer((ListCellRenderer<NamedElement>)new LabelProviderListCellRenderer(this.createLabelProvider()));
        cmb.setEditable(false);
        return cmb;
    }

    protected ILabelProvider createLabelProvider() {
        return new AdapterFactoryVariantLabelProvider(ItemProviders.getAdapterFactory((EObject)this.elementList.get(0).eContainer()), (Object)ExtraLabelVariant.MODEL_LIST);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("OK")) {
            this.resultState = 1;
            this.element = (NamedElement)this.comboBox.getSelectedItem();
        } else if (action.equals("CANCEL")) {
            this.resultState = 2;
        }
        this.setVisible(false);
    }

    public int getResultState() {
        return this.resultState;
    }

    public NamedElement getSelectedElement() {
        return this.element;
    }

    public void setDescription(String description) {
        Container contentPane = this.getContentPane();
        if (this.description != null) {
            contentPane.remove(0);
            this.pack();
        }
        if (description != null) {
            contentPane.add(this.createDescriptionPanel(description), 0);
            this.pack();
        }
        this.description = description;
    }

    private Component createDescriptionPanel(String description) {
        JPanel panel = new JPanel(new FlowLayout(0));
        JLabel label = new JLabel();
        label.setText(description);
        panel.add(label);
        return panel;
    }
}

