/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import net.astah.emf.edit.provider.ExtraLabelVariant;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.emf.edit.provider.swing.AdapterFactoryVariantLabelProvider;
import net.astah.emf.edit.provider.swing.renderer.LabelProviderListCellRenderer;
import net.astah.golf.widget.swing.ILabelProvider;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.KeyDialog;
import net.astah.stpa.stamp.Element;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IDisposable;

public class SelectElementListDialog<T extends Element>
extends KeyDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private int resultState = 2;
    private T element;
    private final List<T> elementList;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    private static final int LIST_SCROLL_PANE_WIDTH = 400;
    private static final int LIST_SCROLL_PANE_HEIGHT = 150;
    private final JList<T> list;
    private String description = null;
    private final JPanel northPanel;

    public SelectElementListDialog(Frame owner, List<T> elementList, T selectedElement) {
        super(owner, true);
        this.elementList = elementList;
        this.setLocation((int)owner.getBounds().getCenterX(), (int)owner.getBounds().getCenterY());
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.northPanel = new JPanel();
        this.northPanel.setLayout(new BoxLayout(this.northPanel, 1));
        contentPane.add((Component)this.northPanel, "North");
        this.list = this.createJList();
        if (selectedElement != null) {
            this.list.setSelectedValue(selectedElement, true);
        }
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().setView(this.list);
        scrollPane.setPreferredSize(new Dimension(400, 150));
        contentPane.add((Component)scrollPane, "Center");
        contentPane.add(this.createOkPanel(), "South");
        this.pack();
    }

    private Component createOkPanel() {
        JPanel okPanel = new JPanel(new FlowLayout(2));
        JButton okButton = new JButton(PropertyManager.getProjectViewResourceBundle().getString("projectview.button.ok.label"));
        okButton.setActionCommand("OK");
        okButton.addActionListener(this);
        JButton cancelButton = new JButton(PropertyManager.getProjectViewResourceBundle().getString("projectview.button.cancel.label"));
        cancelButton.setActionCommand("CANCEL");
        cancelButton.addActionListener(this);
        if (PropertyManager.isMacOS()) {
            okPanel.add(cancelButton);
            okPanel.add(okButton);
        } else {
            okPanel.add(okButton);
            okPanel.add(cancelButton);
        }
        JPanel okBasePanel = new JPanel(new BorderLayout());
        okBasePanel.add((Component)new JSeparator(), "Center");
        okBasePanel.add((Component)okPanel, "South");
        return okBasePanel;
    }

    private JList<T> createJList() {
        final JList<T> list = new JList<T>(new Vector<T>(this.elementList));
        list.setSelectionMode(0);
        list.setCellRenderer(this.createListCellRenderer());
        list.addPropertyChangeListener("ancestor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ListCellRenderer cellRenderer;
                if (evt.getNewValue() == null && (cellRenderer = list.getCellRenderer()) instanceof IDisposable) {
                    ((IDisposable)cellRenderer).dispose();
                }
            }
        });
        return list;
    }

    protected ListCellRenderer<? super T> createListCellRenderer() {
        return new LabelProviderListCellRenderer(this.createLabelProvider());
    }

    protected ILabelProvider createLabelProvider() {
        return new AdapterFactoryVariantLabelProvider(ItemProviders.getAdapterFactory((EObject)((Element)this.elementList.get(0)).eContainer()), (Object)ExtraLabelVariant.MODEL_LIST);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("OK")) {
            this.resultState = 1;
            this.element = (Element)this.list.getSelectedValue();
        } else if (action.equals("CANCEL")) {
            this.resultState = 2;
        }
        this.setVisible(false);
    }

    public int getResultState() {
        return this.resultState;
    }

    public T getSelectedElement() {
        return this.element;
    }

    public void setDescription(String description) {
        if (this.description != null) {
            this.northPanel.remove(0);
            this.pack();
        }
        if (description != null) {
            this.northPanel.add(this.createDescriptionPanel(description), 0);
            this.pack();
        }
        this.description = description;
    }

    private Component createDescriptionPanel(String description) {
        JPanel panel = new JPanel(new FlowLayout(0));
        JLabel label = new JLabel();
        label.setText(description);
        panel.add(label);
        return panel;
    }
}

