/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import net.astah.dd.di.Diagram;
import net.astah.emf.common.ecore.EcoreCopier;
import net.astah.emf.common.ecore.resource.DataURIHandlerImpl;
import net.astah.emf.edit.job.CommandJob;
import net.astah.emf.edit.job.Jobs;
import net.astah.emf.edit.provider.ExtraLabelVariant;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.emf.edit.provider.swing.AdapterFactoryVariantLabelProvider;
import net.astah.emf.edit.provider.swing.renderer.LabelProviderListCellRenderer;
import net.astah.golf.view.swing.UIViewPeer;
import net.astah.golf.widget.swing.ILabelProvider;
import net.astah.golf.widget.swing.SwingComponent;
import net.astah.golf.widget.swing.SwingDesktopPane;
import net.astah.golf.widget.swing.SwingIconRegistry;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.SwingInvoker;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.Editor;
import net.astah.jomt.jview.ManagementView;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.TableEditor;
import net.astah.project.Facets;
import net.astah.project.Project;
import net.astah.project.ProjectManagerAdapter;
import net.astah.stpa.stamp.ControlLoop;
import net.astah.stpa.stamp.HCFAnalysis;
import net.astah.stpa.stamp.HCFAnalysisResult;
import net.astah.stpa.stamp.HCFHintWordSet;
import net.astah.stpa.stamp.STAMPPackage;
import net.astah.stpa.stamp.STAMPPlugin;
import net.astah.stpa.stamp.STPAAnalysis;
import net.astah.stpa.stamp.notation.HCFTable;
import net.astah.stpa.stamp.notation.STAMPControlLoopDiagram;
import net.astah.stpa.stamp.ui.Messages;
import net.astah.stpa.stamp.ui.view.swing.HCFTableEditorPeer;
import net.astah.stpa.stamp.util.HCFHintWordSets;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.icepdf.ri.common.MyAnnotationCallback;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.SwingViewBuilder;
import org.icepdf.ri.common.views.AnnotationCallback;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.util.PropertiesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HCFHintWordSetFrame
extends JInternalFrame
implements ActionListener {
    private static final long serialVersionUID = 1153537152200366219L;
    private static final Logger LOGGER = LoggerFactory.getLogger(HCFHintWordSetFrame.class);
    private JComboBox<HCFHintWordSet> comboBox;
    private SwingController controller;
    private final ResourceSet resourceSet;

    public HCFHintWordSetFrame(EditingDomain domain, String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        super(title, resizable, closable, maximizable, iconifiable);
        this.resourceSet = domain.getResourceSet();
        URIConverter uriConverter = this.resourceSet.getURIConverter();
        DataURIHandlerImpl.install((URIConverter)uriConverter);
    }

    public void createHintWordSetFrame(EList<HCFHintWordSet> hintWordSets, ControlLoop controlLoop) {
        JDesktopPane desktopPane = this.getViewDesktopPane();
        try {
            JPanel comboPanel = this.createComboBoxPanel(controlLoop, hintWordSets);
            this.add((Component)comboPanel, "North");
            JPanel panel = this.createHintWordSetPdfPanel();
            this.add(panel);
            this.pack();
            desktopPane.add((Component)this, JLayeredPane.PALETTE_LAYER);
            DiagramEditor.setPaletteFrame((JInternalFrame)this);
            this.setVisible(true);
        }
        catch (IOException e) {
            LOGGER.error("Creation of HCFHintWordSet InputStream failed.", (Throwable)e);
        }
    }

    public void initializeFrame() throws PropertyVetoException {
        this.setFrameIcon(null);
        this.setMaximum(false);
        this.setBounds(300, 50, 550, 475);
        this.putClientProperty("JInternalFrame.isPalette", Boolean.TRUE);
        this.putClientProperty("JInternalFrame.frameType", "optionDialog");
        this.setDefaultCloseOperation(0);
        this.addInternalFrameListener(new HintWordPaletteAdapter());
        this.addComponentListener(new FrameControlAdapter());
    }

    public void update() throws IOException {
        if (this.controller == null) {
            return;
        }
        this.controller.closeDocument();
        HCFHintWordSet hintWordSet = (HCFHintWordSet)this.comboBox.getSelectedItem();
        InputStream inputStream = this.createInputStream(hintWordSet.getImage());
        DocumentViewController documentViewController = this.controller.getDocumentViewController();
        MyAnnotationCallback annotationCallback = new MyAnnotationCallback(documentViewController);
        documentViewController.setAnnotationCallback((AnnotationCallback)annotationCallback);
        this.controller.openDocument(inputStream, null, null);
        this.controller.setUtilityPaneVisible(false);
        this.controller.setToolBarVisible(false);
    }

    public void updateComboBox(ControlLoop controlLoop) {
        STPAAnalysis analysis = this.getSTPAAnalysis((Notifier)controlLoop);
        EList hintWordSets = HCFHintWordSets.getLanguageHintWordSets((STPAAnalysis)analysis, (ResourceSet)controlLoop.eResource().getResourceSet());
        boolean thisIsListening = Arrays.asList(this.comboBox.getActionListeners()).contains(this);
        this.comboBox.removeActionListener(this);
        this.comboBox.removeAllItems();
        for (int i = 0; i < hintWordSets.size(); ++i) {
            this.comboBox.insertItemAt((HCFHintWordSet)hintWordSets.get(i), i);
        }
        HCFHintWordSet hintWordSet = controlLoop.getHintWordSet();
        this.comboBox.setSelectedItem(hintWordSet);
        if (thisIsListening) {
            this.comboBox.addActionListener(this);
        }
    }

    private JPanel createComboBoxPanel(ControlLoop controlLoop, EList<HCFHintWordSet> hintWordSets) {
        if (this.comboBox == null) {
            this.comboBox = new JComboBox();
        }
        this.comboBox.removeActionListener(this);
        this.comboBox.removeAllItems();
        for (HCFHintWordSet hintWordSet : hintWordSets) {
            this.comboBox.addItem(hintWordSet);
        }
        this.comboBox.setRenderer(this.getComboBoxCellRenderer((Notifier)controlLoop));
        HCFHintWordSet controlLoopHintWordSet = controlLoop.getHintWordSet();
        this.comboBox.setSelectedItem(controlLoopHintWordSet);
        JPanel comboPanel = new JPanel();
        comboPanel.setLayout(new BorderLayout());
        this.comboBox.setPreferredSize(new Dimension(290, 25));
        comboPanel.add(this.comboBox, "West");
        this.comboBox.addActionListener(this);
        return comboPanel;
    }

    private JPanel createHintWordSetPdfPanel() throws IOException {
        if (this.controller == null) {
            this.controller = new SwingController(){

                public void keyPressed(KeyEvent e) {
                }
            };
        } else {
            this.controller.closeDocument();
            this.controller.dispose();
        }
        Properties p = new Properties();
        p.setProperty("application.showLocalStorageDialogs", "false");
        p.setProperty("application.datadir", PropertyManager.getJudeResourceBundle().getString("user.config_dir") + File.separator + "icepdf_viewer");
        p.setProperty("application.statusbar", "false");
        PropertiesManager properties = new PropertiesManager(System.getProperties(), p, ResourceBundle.getBundle("org.icepdf.ri.resources.MessageBundle"));
        SwingViewBuilder factory = new SwingViewBuilder(this.controller, properties);
        JPanel panel = factory.buildViewerPanel();
        this.update();
        panel.setPreferredSize(new Dimension(SwingIconRegistry.scaleValue((int)500), SwingIconRegistry.scaleValue((int)500)));
        this.controller.setZoom((float)SwingIconRegistry.getDefaultScale());
        return panel;
    }

    private InputStream createInputStream(String strURI) throws IOException {
        URI uri = URI.createURI((String)strURI);
        URIConverter uriConverter = this.resourceSet.getURIConverter();
        return uriConverter.createInputStream(uri, null);
    }

    private JDesktopPane getViewDesktopPane() {
        ManagementView managementView = JomtGlobal.viewManager.getManagementView();
        SwingDesktopPane swingDesktopPane = (SwingDesktopPane)managementView.getDesktopPane();
        return (JDesktopPane)swingDesktopPane.getComponent();
    }

    private DefaultListCellRenderer getComboBoxCellRenderer(Notifier notifier) {
        STPAAnalysis analysis = this.getSTPAAnalysis(notifier);
        if (analysis == null) {
            return null;
        }
        LabelProviderListCellRenderer renderer = new LabelProviderListCellRenderer((ILabelProvider)new AdapterFactoryVariantLabelProvider(ItemProviders.getAdapterFactory((EObject)analysis), (Object)ExtraLabelVariant.MODEL_LIST));
        return renderer;
    }

    private STPAAnalysis getSTPAAnalysis(Notifier notifier) {
        Project project = ProjectManagerAdapter.getRootProject((Notifier)notifier);
        return (STPAAnalysis)Facets.getFirstContent((Project)project, (String)STAMPPlugin.FACET_SYMBOLIC_NAME, STPAAnalysis.class, null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.comboBox) {
            SwingInvoker.runLaterInEDT(() -> this.hintWordSetChanged());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hintWordSetChanged() {
        boolean thisIsListening = Arrays.asList(this.comboBox.getActionListeners()).contains(this);
        try {
            int yesno;
            this.comboBox.removeActionListener(this);
            ControlLoop controlLoop = HCFHintWordSetFrame.getCurrentControlLoop();
            if (controlLoop == null) {
                return;
            }
            if (!(this.comboBox.getSelectedItem() instanceof HCFHintWordSet)) {
                return;
            }
            HCFHintWordSet selectedItem = (HCFHintWordSet)this.comboBox.getSelectedItem();
            STPAAnalysis stpaAnalysis = this.getSTPAAnalysis((Notifier)selectedItem);
            HCFAnalysis hcfAnalysis = stpaAnalysis.getHcfAnalysis();
            if (selectedItem != controlLoop.getHintWordSet() && hcfAnalysis.getResults().stream().anyMatch(result -> result.eIsSet((EStructuralFeature)STAMPPackage.Literals.HCF_ANALYSIS_RESULT__HINT_WORD) && this.isClearHintWord(controlLoop, (HCFAnalysisResult)result)) && (yesno = MessageManager.displayYesNoDialog((String)"", (String)Messages.hcf_hintword_set_frame_ask_change_hint_word_set_label)) != 0) {
                this.comboBox.setSelectedItem(controlLoop.getHintWordSet());
                this.comboBox.updateUI();
                return;
            }
            this.executeHintWordSetSetCommand(controlLoop, selectedItem);
        }
        finally {
            if (thisIsListening) {
                this.comboBox.addActionListener(this);
            }
        }
    }

    private boolean isClearHintWord(ControlLoop controlLoop, HCFAnalysisResult result) {
        return controlLoop.getTargetLink().getActions().contains((Object)result.getUnsafeControlAction().getControlAction());
    }

    private void executeHintWordSetSetCommand(ControlLoop controlLoop, HCFHintWordSet hintWordSet) {
        HCFHintWordSet hintWordSetInProject;
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)controlLoop);
        CompoundCommand command = new CompoundCommand();
        STPAAnalysis stpaAnalysis = this.getSTPAAnalysis((Notifier)controlLoop);
        if (stpaAnalysis == null) {
            return;
        }
        if (!HCFHintWordSets.isHCFHintWordSetPresent((HCFHintWordSet)hintWordSet, (STPAAnalysis)stpaAnalysis)) {
            EcoreCopier copier = new EcoreCopier();
            EObject copyObject = copier.copy((EObject)hintWordSet);
            command.append(AddCommand.create((EditingDomain)domain, (Object)stpaAnalysis, (Object)STAMPPackage.Literals.HCF_HINT_WORD_SET, (Object)copyObject));
            hintWordSetInProject = (HCFHintWordSet)copyObject;
            this.comboBox.insertItemAt(hintWordSetInProject, stpaAnalysis.getHCFHintWordSets().size());
        } else {
            hintWordSetInProject = HCFHintWordSets.getHintWordSetInProject((HCFHintWordSet)hintWordSet, (STPAAnalysis)stpaAnalysis);
        }
        if (hintWordSetInProject != controlLoop.getHintWordSet()) {
            for (HCFAnalysisResult result : stpaAnalysis.getHcfAnalysis().getResults()) {
                if (!this.isClearHintWord(controlLoop, result)) continue;
                command.append(SetCommand.create((EditingDomain)domain, (Object)result, (Object)STAMPPackage.Literals.HCF_ANALYSIS_RESULT__HINT_WORD, (Object)SetCommand.UNSET_VALUE));
            }
            command.append(SetCommand.create((EditingDomain)domain, (Object)controlLoop, (Object)STAMPPackage.Literals.CONTROL_LOOP__HINT_WORD_SET, (Object)hintWordSetInProject));
        }
        this.comboBox.setSelectedItem(hintWordSetInProject);
        CommandJob job = new CommandJob(domain, (Command)command);
        Jobs.toCompletableFuture((Job)job, (boolean)true).thenRun(() -> {
            UIViewPeer editorPeer;
            HCFHintWordSetFrame frame = (HCFHintWordSetFrame)DiagramEditor.getPaletteframe();
            if (frame == null) {
                return;
            }
            try {
                this.comboBox.updateUI();
                frame.update();
            }
            catch (IOException e) {
                LOGGER.error("Creation of HCFHintWordSet ComboBox failed.", (Throwable)e);
            }
            Editor editor = JomtGlobal.viewManager.getCurrentEditor();
            if (editor instanceof TableEditor && (editorPeer = editor.getUiViewPeer()) instanceof HCFTableEditorPeer) {
                ((HCFTableEditorPeer)editorPeer).tableEditorActivated(null);
            }
        });
        job.schedule();
    }

    public static ControlLoop getCurrentControlLoop() {
        Diagram diagram;
        Editor editor = JomtGlobal.viewManager.getCurrentEditor();
        if (editor instanceof DiagramEditor) {
            diagram = ((DiagramEditor)editor).getDiagram();
        } else if (editor instanceof TableEditor) {
            diagram = ((TableEditor)editor).getModel();
        } else {
            return null;
        }
        if (diagram instanceof STAMPControlLoopDiagram) {
            return ((STAMPControlLoopDiagram)diagram).getControlLoop();
        }
        if (diagram instanceof HCFTable) {
            return ((HCFTable)diagram).getControlLoop();
        }
        return null;
    }

    private class FrameControlAdapter
    extends ComponentAdapter {
        private FrameControlAdapter() {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            Component component = e.getComponent();
            Point point = component.getLocation();
            if (point.getX() < 0.0) {
                point.x = 0;
            }
            if (point.getY() < 0.0) {
                point.y = 0;
            }
            component.setLocation(point);
        }
    }

    private class HintWordPaletteAdapter
    extends InternalFrameAdapter {
        private HintWordPaletteAdapter() {
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent e) {
            e.getInternalFrame().setVisible(false);
            Editor editor = JomtGlobal.viewManager.getCurrentEditor();
            if (editor == null) {
                return;
            }
            SwingComponent sc = (SwingComponent)editor.getComponent();
            if (sc == null) {
                return;
            }
            Component component = sc.getComponent();
            if (component instanceof JFrame) {
                ((JFrame)component).toFront();
            } else if (component instanceof JInternalFrame) {
                ((JInternalFrame)component).moveToFront();
                try {
                    ((JInternalFrame)component).setSelected(true);
                }
                catch (PropertyVetoException ex) {
                    LOGGER.error("JInternalFrame.setSelected() failed.", (Throwable)ex);
                }
            }
        }
    }
}

