/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.view;

import com.google.common.base.Strings;
import com.google.common.net.MediaType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.astah.emf.common.ecore.EcoreCopier;
import net.astah.emf.common.ecore.resource.DataURIHandlerImpl;
import net.astah.emf.common.resource.ResourceSets;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.emf.edit.job.CommandJob;
import net.astah.emf.edit.job.Jobs;
import net.astah.emf.edit.provider.ExtraLabelVariant;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.emf.edit.provider.swing.AdapterFactoryVariantLabelProvider;
import net.astah.emf.edit.provider.swing.renderer.LabelProviderListCellRenderer;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.util.ResourceBundleList;
import net.astah.golf.util.UIFactory;
import net.astah.golf.widget.BaseLabelProvider;
import net.astah.golf.widget.CFileChooser;
import net.astah.golf.widget.swing.DecoratingLabelProvider;
import net.astah.golf.widget.swing.ILabelDecorator;
import net.astah.golf.widget.swing.ILabelProvider;
import net.astah.golf.widget.swing.SwingIconRegistry;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.JomtWidgetFactory;
import net.astah.jomt.jutil.SaveFileChooser;
import net.astah.jomt.jview.EditableTextComponentMouseAdapther;
import net.astah.jomt.jview.JomtGridBagLayout;
import net.astah.jomt.jview.KeyDialog;
import net.astah.jomt.jview.MessageManager;
import net.astah.project.resource.impl.AstahXMIResourceImpl;
import net.astah.stpa.stamp.HCFHintWord;
import net.astah.stpa.stamp.HCFHintWordSet;
import net.astah.stpa.stamp.STAMPFactory;
import net.astah.stpa.stamp.STAMPPackage;
import net.astah.stpa.stamp.STPAAnalysis;
import net.astah.stpa.stamp.ui.Messages;
import net.astah.stpa.stamp.util.HCFHintWordSets;
import net.astah.stpa.stamp.util.STAMPResourceImpl;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.icepdf.ri.common.MyAnnotationCallback;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.SwingViewBuilder;
import org.icepdf.ri.common.views.AnnotationCallback;
import org.icepdf.ri.common.views.DocumentViewController;
import org.icepdf.ri.util.PropertiesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomizeHintWordDialog
extends KeyDialog
implements ActionListener {
    private static final long serialVersionUID = -5731021336556201031L;
    private static final Logger logger = LoggerFactory.getLogger(CustomizeHintWordDialog.class);
    private static final String EXPORT_HINTWORD_MODEL_ID = "_0";
    private static final String FILE_STYLE_OPEN = "Open Dialog";
    private static final String FILE_STYLE_SAVE = "Save File";
    private static final String HINTWORD_FILE_EXTENSION = "xml";
    private final JComboBox<HCFHintWordSet> hintWordSetCombo;
    private final STPAAnalysis analysis;
    private final TransactionalEditingDomain domain;
    private JComboBox<String> localeCombo;
    private JList<HCFHintWord> hintWordList;
    private JButton renameButton;
    private JButton removeButton;
    private JButton newButton;
    private JButton importButton;
    private JButton exportButton;
    private JButton addButton;
    private JButton editButton;
    private JButton deleteButton;
    private JButton upButton;
    private JButton downButton;
    private JButton dirChooser;
    private JButton previewPdf;
    private JButton applyButton;
    private JButton closeButton;
    private HCFHintWordSet beforeSelectedHintWordSet;

    public CustomizeHintWordDialog(Frame owner, STPAAnalysis analysis) {
        super(owner, true);
        this.analysis = analysis;
        this.domain = TransactionUtil.getEditingDomain((EObject)analysis);
        EList hintWordSets = HCFHintWordSets.getHintWordSets((STPAAnalysis)analysis, (ResourceSet)this.domain.getResourceSet());
        this.hintWordSetCombo = this.createJCombobox((List<HCFHintWordSet>)hintWordSets);
        JPanel topPanel = this.createTopPanel();
        JPanel contentPanel = this.createContentPanel(owner);
        JPanel okPanel = this.createClosePanel();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)topPanel, "North");
        contentPane.add((Component)contentPanel, "Center");
        contentPane.add((Component)okPanel, "South");
        this.beforeSelectedHintWordSet = this.hintWordSetCombo.getItemAt(0);
        if (!HCFHintWordSets.isHCFHintWordSetInApp((HCFHintWordSet)this.beforeSelectedHintWordSet, (STPAAnalysis)analysis)) {
            this.setHintWordSetEditable(true);
            this.removeButton.setEnabled(false);
            if (this.isReferencedOn((EObject)this.beforeSelectedHintWordSet)) {
                this.dirChooser.setEnabled(false);
            }
        } else {
            this.setHintWordSetEditable(false);
        }
        this.setTitle(Messages.hintword_dialog_label);
        this.pack();
        this.setLocationRelativeTo(owner);
    }

    private JComboBox<HCFHintWordSet> createJCombobox(List<HCFHintWordSet> elementList) {
        final JComboBox<HCFHintWordSet> cmb = new JComboBox<HCFHintWordSet>(elementList.toArray(new HCFHintWordSet[0]));
        cmb.setRenderer((ListCellRenderer<HCFHintWordSet>)new LabelProviderListCellRenderer(this.createLabelProvider((EObject)this.analysis)));
        cmb.addPropertyChangeListener("ancestor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    ((LabelProviderListCellRenderer)cmb.getRenderer()).dispose();
                }
            }
        });
        cmb.setEditable(false);
        return cmb;
    }

    protected ILabelProvider createLabelProvider(EObject owner) {
        AdapterFactoryVariantLabelProvider provider = new AdapterFactoryVariantLabelProvider(ItemProviders.getAdapterFactory((EObject)owner), (Object)ExtraLabelVariant.MODEL_LIST);
        if (owner instanceof HCFHintWordSet) {
            return provider;
        }
        return new DecoratingLabelProvider((ILabelProvider)provider, (ILabelDecorator)new HintWordSetLabelDecorator());
    }

    private JPanel createTopPanel() {
        JLabel label = new JLabel(Messages.hintword_dialog_top_label);
        this.hintWordSetCombo.setMinimumSize(this.hintWordSetCombo.getPreferredSize());
        this.hintWordSetCombo.addActionListener(this);
        String renameString = Messages.hintword_dialog_button_rename_label;
        this.renameButton = new JButton(renameString);
        this.renameButton.setToolTipText(renameString);
        this.renameButton.addActionListener(this);
        this.renameButton.setMinimumSize(this.renameButton.getPreferredSize());
        String removeString = Messages.hintword_dialog_button_remove_label;
        this.removeButton = new JButton(removeString);
        this.removeButton.setToolTipText(removeString);
        this.removeButton.addActionListener(this);
        this.removeButton.setMinimumSize(this.removeButton.getPreferredSize());
        String newString = Messages.hintword_dialog_button_new_label;
        this.newButton = new JButton(newString);
        this.newButton.setToolTipText(newString);
        this.newButton.addActionListener(this);
        this.newButton.setMinimumSize(this.newButton.getPreferredSize());
        String importString = Messages.hintword_dialog_button_import_label;
        this.importButton = new JButton(importString);
        this.importButton.setToolTipText(importString);
        this.importButton.addActionListener(this);
        this.importButton.setMinimumSize(this.importButton.getPreferredSize());
        String exportString = Messages.hintword_dialog_button_export_label;
        this.exportButton = new JButton(exportString);
        this.exportButton.setToolTipText(exportString);
        this.exportButton.addActionListener(this);
        this.exportButton.setMinimumSize(this.exportButton.getPreferredSize());
        String applyString = Messages.hintword_dialog_button_apply_label;
        this.applyButton = new JButton(applyString);
        this.applyButton.setToolTipText(applyString);
        this.applyButton.addActionListener(this);
        this.applyButton.setMinimumSize(this.applyButton.getPreferredSize());
        JomtGridBagLayout gridBag = new JomtGridBagLayout();
        JPanel panel = new JPanel((LayoutManager)gridBag);
        gridBag.setLayout((Component)label, 1, 1.0, true);
        panel.add(label);
        gridBag.setLayout(this.hintWordSetCombo, 3, 1.0, false);
        panel.add(this.hintWordSetCombo);
        gridBag.setLayout((Component)this.renameButton, 1, 1.0, false);
        panel.add(this.renameButton);
        gridBag.setLayout((Component)this.removeButton, 1, 1.0, true);
        panel.add(this.removeButton);
        gridBag.setLayout((Component)this.newButton, 1, 1.0, false);
        panel.add(this.newButton);
        gridBag.setLayout((Component)this.importButton, 1, 1.0, false);
        panel.add(this.importButton);
        gridBag.setLayout((Component)this.exportButton, 1, 1.0, false);
        panel.add(this.exportButton);
        gridBag.setLayout((Component)this.applyButton, 2, 1.0, false);
        panel.add(this.applyButton);
        return panel;
    }

    private JPanel createContentPanel(Frame owner) {
        HCFHintWordSet selectedItem = (HCFHintWordSet)this.hintWordSetCombo.getSelectedItem();
        this.localeCombo = new JComboBox();
        this.localeCombo.addItem("ja");
        this.localeCombo.addItem("en");
        this.localeCombo.setSelectedItem(selectedItem.getLanguage());
        this.localeCombo.setEditable(true);
        this.localeCombo.addActionListener(this);
        this.dirChooser = new JButton();
        UIFactory uiFactory = new UIFactory(new ResourceBundleList());
        Icon openIcon = uiFactory.getResourceImageIcon("platform:/plugin/net.astah.core.app/net/astah/jomt/resource/images/open.png");
        this.dirChooser.setIcon(openIcon);
        this.dirChooser.setMargin(new Insets(0, 0, 0, 0));
        this.dirChooser.setText(Messages.hintword_dialog_select_pdf_select_label);
        this.dirChooser.addActionListener(this);
        this.previewPdf = new JButton();
        Icon previewIcon = uiFactory.getResourceImageIcon("platform:/plugin/net.astah.core.app/net/astah/jomt/resource/images/printpreview.png");
        this.previewPdf.setIcon(previewIcon);
        this.previewPdf.setMargin(new Insets(0, 0, 0, 0));
        this.previewPdf.setText(Messages.hintword_dialog_select_pdf_preview_label);
        this.previewPdf.addActionListener(this);
        EList hintWords = selectedItem.getHintWords();
        this.hintWordList = new JList(new Vector(hintWords));
        this.hintWordList.setSelectionMode(0);
        this.hintWordList.setCellRenderer((ListCellRenderer<HCFHintWord>)new LabelProviderListCellRenderer(this.createLabelProvider((EObject)selectedItem)));
        this.hintWordList.setSelectedIndex(0);
        this.hintWordList.addPropertyChangeListener("ancestor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ListCellRenderer cellRenderer;
                if (evt.getNewValue() == null && (cellRenderer = CustomizeHintWordDialog.this.hintWordList.getCellRenderer()) instanceof IDisposable) {
                    ((IDisposable)cellRenderer).dispose();
                }
            }
        });
        JomtGridBagLayout gridBag = new JomtGridBagLayout();
        JPanel contentPanel = new JPanel((LayoutManager)gridBag);
        JLabel localeLabel = new JLabel(Messages.hintword_dialog_select_locale_label);
        JPanel localePanel = new JPanel(new FlowLayout(0, 0, 5));
        localePanel.add(localeLabel);
        localePanel.add(this.localeCombo);
        gridBag.setLayout((Component)localePanel, 1, 1.0, false);
        contentPanel.add(localePanel);
        JLabel pdfFileLabel = new JLabel(Messages.hintword_dialog_select_pdf_label);
        JPanel pdfFilePanel = new JPanel(new FlowLayout(0));
        pdfFilePanel.add(pdfFileLabel);
        pdfFilePanel.add(this.dirChooser);
        pdfFilePanel.add(this.previewPdf);
        gridBag.setLayout((Component)pdfFilePanel, 1, 1.0, true);
        contentPanel.add(pdfFilePanel);
        JLabel hintWordListLabel = new JLabel(Messages.hintword_dialog_select_hintword_label);
        gridBag.setLayout((Component)hintWordListLabel, 1, 1.0, true);
        contentPanel.add(hintWordListLabel);
        JScrollPane hintWordPane = new JScrollPane(this.hintWordList);
        hintWordPane.setPreferredSize(new Dimension(500, 250));
        JPanel hintWordPanel = new JPanel(new BorderLayout());
        hintWordPanel.add("Center", hintWordPane);
        hintWordPanel.add("East", this.createButtonPanel());
        gridBag.setLayout((Component)hintWordPanel, 2, 1.0, true);
        contentPanel.add(hintWordPanel);
        return contentPanel;
    }

    private JPanel createButtonPanel() {
        String addString = Messages.hintword_dialog_button_add_label;
        this.addButton = new JButton(addString);
        this.addButton.setToolTipText(addString);
        this.addButton.addActionListener(this);
        String editString = Messages.hintword_dialog_button_edit_label;
        this.editButton = new JButton(editString);
        this.editButton.setToolTipText(editString);
        this.editButton.addActionListener(this);
        String deleteString = Messages.hintword_dialog_button_delete_label;
        this.deleteButton = new JButton(deleteString);
        this.deleteButton.setToolTipText(deleteString);
        this.deleteButton.addActionListener(this);
        String upString = Messages.hintword_dialog_button_up_label;
        this.upButton = new JButton(upString);
        this.upButton.setToolTipText(upString);
        this.upButton.addActionListener(this);
        String downString = Messages.hintword_dialog_button_down_label;
        this.downButton = new JButton(downString);
        this.downButton.setToolTipText(downString);
        this.downButton.addActionListener(this);
        JPanel okPanel = new JPanel(new GridLayout(5, 0));
        okPanel.add(this.addButton);
        okPanel.add(this.editButton);
        okPanel.add(this.deleteButton);
        okPanel.add(this.upButton);
        okPanel.add(this.downButton);
        return okPanel;
    }

    private JPanel createClosePanel() {
        String closeString = Messages.hintword_dialog_button_close_label;
        this.closeButton = new JButton(closeString);
        this.closeButton.setToolTipText(closeString);
        this.closeButton.addActionListener(this);
        JPanel closePanel = new JPanel(new FlowLayout(2));
        closePanel.add(this.closeButton);
        JPanel closeBasePanel = new JPanel(new BorderLayout());
        closeBasePanel.add((Component)new JSeparator(), "North");
        closeBasePanel.add((Component)closePanel, "South");
        return closeBasePanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        HCFHintWordSet newSelectionHintWordSet;
        int newSelectionHintWordIndex;
        IdentityCommand command;
        HCFHintWordSet selectedHintWordSet = (HCFHintWordSet)this.hintWordSetCombo.getSelectedItem();
        if (e.getSource() == this.hintWordSetCombo) {
            this.selectLocale(selectedHintWordSet);
            this.beforeSelectedHintWordSet = selectedHintWordSet;
            command = IdentityCommand.INSTANCE;
            newSelectionHintWordIndex = 0;
            newSelectionHintWordSet = selectedHintWordSet;
        } else if (e.getSource() == this.newButton) {
            newSelectionHintWordIndex = 0;
            EditNameDialog dialog = new EditNameDialog((JDialog)((Object)this));
            dialog.setVisible(true);
            if (!dialog.isApprove()) {
                dialog.dispose();
                return;
            }
            HCFHintWordSet copyObject = this.copyHintWordSet(selectedHintWordSet, dialog.getName());
            command = this.createAddHintWordSetCommand(copyObject);
            this.hintWordSetCombo.insertItemAt(copyObject, this.analysis.getHCFHintWordSets().size());
            newSelectionHintWordSet = copyObject;
            dialog.dispose();
        } else if (e.getSource() == this.renameButton) {
            newSelectionHintWordIndex = 0;
            newSelectionHintWordSet = selectedHintWordSet;
            EditNameDialog dialog = new EditNameDialog((JDialog)((Object)this), selectedHintWordSet.getName());
            dialog.setVisible(true);
            if (!dialog.isApprove()) {
                dialog.dispose();
                return;
            }
            command = this.createSetCommand((EObject)selectedHintWordSet, dialog.getName());
            dialog.dispose();
        } else if (e.getSource() == this.removeButton) {
            int approve = MessageManager.displayMessageOKDialog((String)"app", (String)Messages.hintword_dialog_hintwordset_remove_message);
            if (approve != 0) {
                return;
            }
            newSelectionHintWordIndex = 0;
            int index = this.hintWordSetCombo.getSelectedIndex();
            if (index > 0) {
                --index;
            }
            newSelectionHintWordSet = (HCFHintWordSet)this.hintWordSetCombo.getModel().getElementAt(index);
            this.beforeSelectedHintWordSet = null;
            this.hintWordSetCombo.removeItem(selectedHintWordSet);
            command = DestroyCommand.create((EditingDomain)this.domain, (Object)selectedHintWordSet);
        } else if (e.getSource() == this.importButton) {
            newSelectionHintWordIndex = 0;
            File file = this.fileSelectDialog(FILE_STYLE_OPEN, HINTWORD_FILE_EXTENSION, "XML Files");
            if (file == null) {
                return;
            }
            EObject object = this.getImportHintWordSet(file);
            if (object == null) {
                MessageManager.displayConfirmMessageDialog((String)"", (String)Messages.hintword_dialog_cannot_import);
                return;
            }
            HCFHintWordSet importObject = (HCFHintWordSet)object;
            command = this.createAddHintWordSetCommand(importObject);
            this.hintWordSetCombo.insertItemAt(importObject, this.analysis.getHCFHintWordSets().size());
            newSelectionHintWordSet = importObject;
        } else if (e.getSource() == this.exportButton) {
            command = IdentityCommand.INSTANCE;
            newSelectionHintWordIndex = 0;
            newSelectionHintWordSet = selectedHintWordSet;
            this.exportHintWordSet(selectedHintWordSet);
        } else if (e.getSource() == this.localeCombo) {
            newSelectionHintWordIndex = 0;
            newSelectionHintWordSet = selectedHintWordSet;
            if (this.beforeSelectedHintWordSet != null && this.beforeSelectedHintWordSet == selectedHintWordSet) {
                String local = (String)this.localeCombo.getSelectedItem();
                command = SetCommand.create((EditingDomain)this.domain, (Object)selectedHintWordSet, (Object)STAMPPackage.Literals.HCF_HINT_WORD_SET__LANGUAGE, (Object)local);
            } else {
                command = IdentityCommand.INSTANCE;
            }
        } else if (e.getSource() == this.dirChooser) {
            newSelectionHintWordIndex = 0;
            newSelectionHintWordSet = selectedHintWordSet;
            String uri = this.createPDFData();
            if (uri == null) {
                return;
            }
            command = SetCommand.create((EditingDomain)this.domain, (Object)selectedHintWordSet, (Object)STAMPPackage.Literals.HCF_HINT_WORD_SET__IMAGE, (Object)uri);
        } else if (e.getSource() == this.previewPdf) {
            newSelectionHintWordIndex = this.hintWordList.getSelectedIndex();
            newSelectionHintWordSet = selectedHintWordSet;
            this.previewPdf();
            command = IdentityCommand.INSTANCE;
        } else if (e.getSource() == this.addButton) {
            newSelectionHintWordSet = selectedHintWordSet;
            EditNameDialog dialog = new EditNameDialog((JDialog)((Object)this));
            dialog.setVisible(true);
            if (!dialog.isApprove()) {
                dialog.dispose();
                return;
            }
            HCFHintWord hintWord = STAMPFactory.eINSTANCE.createHCFHintWord();
            hintWord.setName(dialog.getName());
            command = AddCommand.create((EditingDomain)this.domain, (Object)selectedHintWordSet, (Object)STAMPPackage.Literals.HCF_HINT_WORD_SET__HINT_WORD, (Object)hintWord);
            newSelectionHintWordIndex = this.hintWordList.getModel().getSize();
            dialog.dispose();
        } else if (e.getSource() == this.editButton) {
            newSelectionHintWordSet = selectedHintWordSet;
            HCFHintWord hintWord = this.hintWordList.getSelectedValue();
            newSelectionHintWordIndex = this.hintWordList.getSelectedIndex();
            EditNameDialog dialog = new EditNameDialog((JDialog)((Object)this), hintWord.getName());
            dialog.setVisible(true);
            if (!dialog.isApprove()) {
                dialog.dispose();
                return;
            }
            command = this.createSetCommand((EObject)hintWord, dialog.getName());
            dialog.dispose();
        } else if (e.getSource() == this.deleteButton) {
            newSelectionHintWordIndex = 0;
            newSelectionHintWordSet = selectedHintWordSet;
            HCFHintWord hintWord = this.hintWordList.getSelectedValue();
            command = DestroyCommand.create((EditingDomain)this.domain, (Object)hintWord);
        } else if (e.getSource() == this.upButton) {
            command = this.createMoveUpCommand(selectedHintWordSet, this.hintWordList.getSelectedIndex());
            newSelectionHintWordIndex = this.hintWordList.getSelectedIndex() - 1;
            newSelectionHintWordSet = selectedHintWordSet;
        } else if (e.getSource() == this.downButton) {
            command = this.createMoveDownCommand(selectedHintWordSet, this.hintWordList.getSelectedIndex());
            newSelectionHintWordIndex = this.hintWordList.getSelectedIndex() + 1;
            newSelectionHintWordSet = selectedHintWordSet;
        } else if (e.getSource() == this.applyButton) {
            HCFHintWordSet defaultHintWordSet = selectedHintWordSet;
            if (HCFHintWordSets.isHCFHintWordSetInApp((HCFHintWordSet)selectedHintWordSet, (STPAAnalysis)this.analysis)) {
                HCFHintWordSet hintWordSetInProject = HCFHintWordSets.getHintWordSetInProject((HCFHintWordSet)selectedHintWordSet, (STPAAnalysis)this.analysis);
                defaultHintWordSet = hintWordSetInProject == null ? this.copyHintWordSet(selectedHintWordSet) : hintWordSetInProject;
            }
            command = this.createSetDefaultCommand(defaultHintWordSet);
            newSelectionHintWordIndex = 0;
            newSelectionHintWordSet = defaultHintWordSet;
            this.hintWordSetCombo.removeItem(newSelectionHintWordSet);
            this.hintWordSetCombo.insertItemAt(newSelectionHintWordSet, 0);
        } else {
            if (e.getSource() == this.closeButton) {
                this.setVisible(false);
                return;
            }
            return;
        }
        logger.debug("{}", e.getSource());
        CommandJob job = new CommandJob(this.domain, (Command)command);
        Jobs.toCompletableFuture((Job)job, (boolean)true).thenRun(() -> {
            if (e.getSource() == this.localeCombo || e.getSource() == this.dirChooser || e.getSource() == this.exportButton || e.getSource() == this.hintWordList) {
                return;
            }
            if (newSelectionHintWordSet != selectedHintWordSet || e.getSource() == this.applyButton || e.getSource() == this.renameButton) {
                this.updateHintWordSetList((EList<HCFHintWord>)newSelectionHintWordSet.getHintWords(), newSelectionHintWordSet);
            } else {
                this.updateHintWordList((EList<HCFHintWord>)newSelectionHintWordSet.getHintWords(), newSelectionHintWordIndex);
                if (HCFHintWordSets.isHCFHintWordSetInApp((HCFHintWordSet)newSelectionHintWordSet, (STPAAnalysis)this.analysis)) {
                    this.setHintWordSetEditable(false);
                } else {
                    this.setHintWordSetEditable(true);
                    if (this.isReferencedOn((EObject)newSelectionHintWordSet)) {
                        this.removeButton.setEnabled(false);
                        this.dirChooser.setEnabled(false);
                    } else if (this.hintWordSetCombo.getItemAt(0) == newSelectionHintWordSet) {
                        this.removeButton.setEnabled(false);
                    }
                }
            }
            this.previewPdf.setEnabled(newSelectionHintWordSet.getImage() != null);
        });
        job.schedule();
    }

    private void previewPdf() {
        JPanel panel = this.createHintWordSetPdfPanel();
        if (panel == null) {
            return;
        }
        JDialog dialog = new JDialog((Dialog)((Object)this), null, true);
        dialog.add(panel);
        dialog.setSize(panel.getPreferredSize());
        dialog.setVisible(true);
    }

    private JPanel createHintWordSetPdfPanel() {
        SwingController controller = new SwingController(){

            public void keyPressed(KeyEvent e) {
            }
        };
        Properties p = new Properties();
        p.setProperty("application.showLocalStorageDialogs", "false");
        p.setProperty("application.datadir", PropertyManager.getJudeResourceBundle().getString("user.config_dir") + File.separator + "icepdf_viewer");
        p.setProperty("application.statusbar", "false");
        PropertiesManager properties = new PropertiesManager(System.getProperties(), p, ResourceBundle.getBundle("org.icepdf.ri.resources.MessageBundle"));
        SwingViewBuilder factory = new SwingViewBuilder(controller, properties);
        JPanel panel = factory.buildViewerPanel();
        HCFHintWordSet hintWordSet = (HCFHintWordSet)this.hintWordSetCombo.getSelectedItem();
        URI uri = URI.createURI((String)hintWordSet.getImage());
        URIConverter uriConverter = this.domain.getResourceSet().getURIConverter();
        DataURIHandlerImpl.install((URIConverter)uriConverter);
        InputStream inputStream = null;
        try {
            inputStream = uriConverter.createInputStream(uri, null);
        }
        catch (Exception e) {
            logger.error("Failed to import file.", (Throwable)e);
            return null;
        }
        DocumentViewController documentViewController = controller.getDocumentViewController();
        MyAnnotationCallback annotationCallback = new MyAnnotationCallback(documentViewController);
        documentViewController.setAnnotationCallback((AnnotationCallback)annotationCallback);
        controller.openDocument(inputStream, null, null);
        controller.setUtilityPaneVisible(false);
        controller.setToolBarVisible(false);
        panel.setPreferredSize(new Dimension(SwingIconRegistry.scaleValue((int)500), SwingIconRegistry.scaleValue((int)500)));
        controller.setZoom((float)SwingIconRegistry.getDefaultScale());
        return panel;
    }

    private boolean isReferencedOn(EObject object) {
        return !UML2Util.getNonNavigableInverseReferences((EObject)object).isEmpty();
    }

    private String createPDFData() {
        try {
            File selectedFile = this.fileSelectDialog(FILE_STYLE_OPEN, "pdf", "PDF Files");
            if (selectedFile == null) {
                return null;
            }
            FileInputStream data = new FileInputStream(selectedFile);
            MediaType mediaType = MediaType.create((String)"application", (String)"pdf");
            String uri = DataURIHandlerImpl.builder((InputStream)data).withMediaType(mediaType).buildString();
            return uri;
        }
        catch (IOException ex) {
            MessageManager.displayConfirmMessageDialog((String)"", (String)Messages.hintword_dialog_cannot_convert_pdf);
            return null;
        }
    }

    private EObject getImportHintWordSet(File selectedFile) {
        URI uri = URI.createFileURI((String)selectedFile.getAbsolutePath()).appendFragment(EXPORT_HINTWORD_MODEL_ID);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        try {
            EObject object = resourceSet.getEObject(uri, true);
            STAMPResourceImpl stampResource = new STAMPResourceImpl(uri);
            stampResource.setID(object, null);
            EcoreUtil.remove((EObject)object);
            ResourceSets.dispose((ResourceSet)resourceSet);
            return object;
        }
        catch (Exception ex) {
            logger.error("Failed to import file.", (Throwable)ex);
            return null;
        }
    }

    private void exportHintWordSet(HCFHintWordSet selectedHintWordSet) {
        SaveFileChooser chooser = new SaveFileChooser((Component)((Object)this), HINTWORD_FILE_EXTENSION, "XML Files", null, false){

            protected String getDefaultDirectory() {
                return CustomizeHintWordDialog.this.getInitialDirectory(null);
            }
        };
        chooser.select(selectedFile -> {
            URI uri = URI.createFileURI((String)selectedFile.getAbsolutePath());
            STAMPResourceImpl stampResource = new STAMPResourceImpl(uri);
            stampResource = (STAMPResourceImpl)AstahXMIResourceImpl.init((XMLResourceImpl)stampResource);
            HCFHintWordSet copyObject = this.copyHintWordSet(selectedHintWordSet);
            stampResource.setID((EObject)copyObject, EXPORT_HINTWORD_MODEL_ID);
            stampResource.getContents().add((Object)copyObject);
            try {
                stampResource.save(null);
            }
            catch (IOException ex) {
                MessageManager.displayConfirmMessageDialog((String)"", (String)Messages.hintword_dialog_cannot_export);
                return false;
            }
            return true;
        });
    }

    private void selectLocale(HCFHintWordSet selectedHintWordSet) {
        String language = selectedHintWordSet.getLanguage();
        if (!Strings.isNullOrEmpty((String)language)) {
            this.localeCombo.setSelectedItem(language);
        }
    }

    private File fileSelectDialog(String style, String extension, String description) {
        return this.fileSelectDialog(style, extension, description, null);
    }

    private File fileSelectDialog(String style, String extension, String description, File initial) {
        File file;
        if (PropertyManager.isMacOS()) {
            FileDialog dialog = this.getFileDialog(style, extension, description, initial);
            if (dialog == null) {
                return null;
            }
            file = new File(dialog.getDirectory() + dialog.getFile());
        } else {
            CFileChooser fileChooser = this.getFileChooser(style, extension, description, initial);
            if (fileChooser == null) {
                return null;
            }
            file = fileChooser.getSelectedFile();
        }
        String absolutePath = file.getAbsolutePath();
        if (!absolutePath.endsWith("." + extension)) {
            absolutePath = absolutePath + "." + extension;
        }
        return new File(GolfUtilities.normalizeToNFC((String)absolutePath));
    }

    private FileDialog getFileDialog(String style, final String extension, String description, File initial) {
        String userDir = this.getInitialDirectory(initial);
        FileDialog dialog = new FileDialog((Dialog)((Object)this));
        dialog.setMode(FILE_STYLE_SAVE.equals(style) ? 1 : 0);
        dialog.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith("." + extension);
            }
        });
        dialog.setDirectory(userDir);
        dialog.setVisible(true);
        if (dialog.getFile() == null) {
            return null;
        }
        return dialog;
    }

    private CFileChooser getFileChooser(String style, String extension, String description, File initial) {
        String userDir = this.getInitialDirectory(initial);
        CFileChooser fileChooser = JomtWidgetFactory.instance().createFileChooser(userDir, style);
        fileChooser.setFileFilter(extension, description);
        if (FILE_STYLE_OPEN.equals(style) && !fileChooser.isApproveOpenDialog() || FILE_STYLE_SAVE.equals(style) && !fileChooser.isApproveSaveDialog()) {
            return null;
        }
        return fileChooser;
    }

    private String getInitialDirectory(File initial) {
        if (initial != null) {
            if (initial.isDirectory()) {
                return initial.getPath();
            }
            return initial.getParent();
        }
        return JomtGlobal.getFileDir();
    }

    private HCFHintWordSet copyHintWordSet(HCFHintWordSet object) {
        return this.copyHintWordSet(object, null);
    }

    private HCFHintWordSet copyHintWordSet(HCFHintWordSet object, String newName) {
        EcoreCopier copier = new EcoreCopier();
        HCFHintWordSet copyObject = (HCFHintWordSet)copier.copy((EObject)object);
        if (!Strings.isNullOrEmpty((String)newName)) {
            copyObject.setName(newName);
        }
        return copyObject;
    }

    private void updateHintWordList(EList<HCFHintWord> hintWordListData, int index) {
        this.hintWordList.setListData(new Vector<HCFHintWord>((Collection<HCFHintWord>)hintWordListData));
        this.hintWordList.updateUI();
        this.hintWordList.setSelectedIndex(index);
    }

    private void updateHintWordSetList(EList<HCFHintWord> hintWordListData, HCFHintWordSet newSelectionHintWordSet) {
        this.hintWordList.setListData(new Vector<HCFHintWord>((Collection<HCFHintWord>)hintWordListData));
        this.hintWordSetCombo.updateUI();
        this.hintWordSetCombo.setSelectedItem(newSelectionHintWordSet);
    }

    private void setHintWordSetEditable(boolean editable) {
        this.renameButton.setEnabled(editable);
        this.removeButton.setEnabled(editable);
        this.localeCombo.setEnabled(editable);
        this.dirChooser.setEnabled(editable);
        this.addButton.setEnabled(editable);
        this.editButton.setEnabled(editable);
        this.deleteButton.setEnabled(editable);
        this.upButton.setEnabled(editable);
        this.downButton.setEnabled(editable);
    }

    private Command createMoveUpCommand(HCFHintWordSet hintWordSet, int rowIndex) {
        if (rowIndex < 1) {
            return IdentityCommand.INSTANCE;
        }
        HCFHintWord hintWord = (HCFHintWord)hintWordSet.getHintWords().get(rowIndex);
        return MoveCommand.create((EditingDomain)this.domain, (Object)hintWordSet, (Object)STAMPPackage.Literals.HCF_HINT_WORD_SET__HINT_WORD, (Object)hintWord, (int)(rowIndex - 1));
    }

    private Command createMoveDownCommand(HCFHintWordSet hintWordSet, int rowIndex) {
        if (rowIndex == -1 || rowIndex >= hintWordSet.getHintWords().size() - 1) {
            return IdentityCommand.INSTANCE;
        }
        HCFHintWord hintWord = (HCFHintWord)hintWordSet.getHintWords().get(rowIndex);
        return MoveCommand.create((EditingDomain)this.domain, (Object)hintWordSet, (Object)STAMPPackage.Literals.HCF_HINT_WORD_SET__HINT_WORD, (Object)hintWord, (int)(rowIndex + 1));
    }

    private Command createSetDefaultCommand(HCFHintWordSet defaultHintWordSet) {
        if (this.analysis.getHCFHintWordSets().contains((Object)defaultHintWordSet)) {
            return MoveCommand.create((EditingDomain)this.domain, (Object)this.analysis, (Object)STAMPPackage.Literals.STPA_ANALYSIS__HCF_HINT_WORD_SET, (Object)defaultHintWordSet, (int)0);
        }
        return AddCommand.create((EditingDomain)this.domain, (Object)this.analysis, (Object)STAMPPackage.Literals.STPA_ANALYSIS__HCF_HINT_WORD_SET, (Object)defaultHintWordSet, (int)0);
    }

    private Command createAddHintWordSetCommand(HCFHintWordSet hintWordSet) {
        return AddCommand.create((EditingDomain)this.domain, (Object)this.analysis, (Object)STAMPPackage.Literals.STPA_ANALYSIS__HCF_HINT_WORD_SET, (Object)hintWordSet);
    }

    private Command createSetCommand(EObject object, String name) {
        return SetCommand.create((EditingDomain)this.domain, (Object)object, (Object)STAMPPackage.Literals.NAMED_ELEMENT__NAME, (Object)name);
    }

    private class EditNameDialog
    extends KeyDialog
    implements ActionListener {
        private static final long serialVersionUID = 3521162107246739511L;
        private boolean approve;
        private final JTextField nameText;
        private JLabel alertLabel;
        private EList<HCFHintWordSet> hintWordSets;
        private JButton okButton;

        public EditNameDialog(JDialog owner) {
            this(owner, null);
        }

        public EditNameDialog(JDialog owner, String name) {
            super(owner, true);
            this.hintWordSets = new BasicEList();
            ComboBoxModel model = CustomizeHintWordDialog.this.hintWordSetCombo.getModel();
            for (int i = 0; i < model.getSize(); ++i) {
                this.hintWordSets.add(model.getElementAt(i));
            }
            JPanel textPanel = new JPanel(new GridLayout(2, 0));
            this.alertLabel = new JLabel();
            this.alertLabel.setForeground(Color.red);
            this.nameText = new JTextField(40);
            this.nameText.setText(name);
            this.nameText.addMouseListener((MouseListener)new EditableTextComponentMouseAdapther());
            this.nameText.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.validateDocument();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.validateDocument();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }

                private void validateDocument() {
                    if (EditNameDialog.this.nameText.getText().equals("")) {
                        EditNameDialog.this.alertLabel.setText(Messages.hintword_dialog_new_hintwordset_empty);
                        EditNameDialog.this.okButton.setEnabled(false);
                    } else if (this.isLegal(EditNameDialog.this.nameText.getText())) {
                        EditNameDialog.this.alertLabel.setText("");
                        EditNameDialog.this.okButton.setEnabled(true);
                    } else {
                        EditNameDialog.this.alertLabel.setText(Messages.hintword_dialog_new_hintwordset_unique);
                        EditNameDialog.this.okButton.setEnabled(false);
                    }
                }

                private boolean isLegal(String name) {
                    if (Strings.isNullOrEmpty((String)name)) {
                        return false;
                    }
                    for (HCFHintWordSet hintWordSet : EditNameDialog.this.hintWordSets) {
                        if (!hintWordSet.getName().equals(name)) continue;
                        return false;
                    }
                    return true;
                }
            });
            textPanel.add(this.nameText);
            textPanel.add(this.alertLabel);
            JPanel okPanel = this.createOkPanel();
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)textPanel, "Center");
            contentPane.add((Component)okPanel, "South");
            this.setTitle(Messages.hintword_dialog_label);
            this.pack();
            this.setLocationRelativeTo(owner);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if ("OK".equals(e.getActionCommand())) {
                this.approve = true;
                this.setVisible(false);
            } else if ("Close".equals(e.getActionCommand())) {
                this.approve = false;
                this.setVisible(false);
            }
        }

        public boolean isApprove() {
            return this.approve;
        }

        public String getName() {
            return this.nameText.getText();
        }

        private JPanel createOkPanel() {
            String okString = Messages.hintword_dialog_button_ok_label;
            this.okButton = new JButton(okString);
            this.okButton.setEnabled(false);
            this.okButton.setToolTipText(okString);
            this.okButton.setActionCommand("OK");
            this.okButton.addActionListener(this);
            String closeString = Messages.hintword_dialog_button_close_label;
            JButton closeButton = new JButton(closeString);
            closeButton.setToolTipText(closeString);
            closeButton.setActionCommand("Close");
            closeButton.addActionListener(this);
            JPanel okPanel = new JPanel(new FlowLayout(2));
            if (PropertyManager.isMacOS()) {
                okPanel.add(closeButton);
                okPanel.add(this.okButton);
            } else {
                okPanel.add(this.okButton);
                okPanel.add(closeButton);
            }
            JPanel okBasePanel = new JPanel(new BorderLayout());
            okBasePanel.add((Component)new JSeparator(), "North");
            okBasePanel.add((Component)okPanel, "South");
            return okBasePanel;
        }
    }

    private class HintWordSetLabelDecorator
    extends BaseLabelProvider
    implements ILabelDecorator {
        private HintWordSetLabelDecorator() {
        }

        public String decorateText(String text, Object element) {
            String decorateText = HCFHintWordSets.isHCFHintWordSetInApp((HCFHintWordSet)((HCFHintWordSet)element), (STPAAnalysis)CustomizeHintWordDialog.this.analysis) ? Messages.hintword_dialog_hintwordset_name_built_in_label : Messages.hintword_dialog_hintwordset_name_project_in_label;
            if (element == CustomizeHintWordDialog.this.hintWordSetCombo.getItemAt(0)) {
                return text + decorateText + Messages.hintword_dialog_hintwordset_name_default_label;
            }
            return text + decorateText;
        }

        public Icon decorateImage(Icon image, Object element) {
            return image;
        }
    }
}

