/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.astah.emf.edit.provider.swing.JTreeBuilder;
import net.astah.golf.control.Command;
import net.astah.golf.control.CommandEvent;
import net.astah.golf.control.CommandManager;
import net.astah.golf.draw.GCamera;
import net.astah.golf.model.EntityStoreEvent;
import net.astah.golf.model.EntityStoreListener;
import net.astah.golf.model.IEntityStore;
import net.astah.golf.util.ResourceBundleList;
import net.astah.golf.util.UIFactory;
import net.astah.golf.view.GroupUIView;
import net.astah.golf.view.ModelUIView;
import net.astah.golf.widget.CComponent;
import net.astah.golf.widget.swing.SwingComponent;
import net.astah.jmodel.DiagramViewInfo;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jomt.jcontrol.OpenDiagramEditorCommand;
import net.astah.jomt.jcontrol.OpenTableEditorCommand;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.notation.Diagram;
import net.astah.notation.TableView;
import net.astah.project.Facets;
import net.astah.project.Project;
import net.astah.project.ProjectManagerAdapter;
import net.astah.stpa.stamp.STAMPPlugin;
import net.astah.stpa.stamp.STPAAnalysis;
import net.astah.stpa.stamp.UCAAnalysis;
import net.astah.stpa.stamp.notation.AccidentHazardSafetyConstraintTable;
import net.astah.stpa.stamp.notation.ComponentExtractingTable;
import net.astah.stpa.stamp.notation.CountermeasureTable;
import net.astah.stpa.stamp.notation.HCFTable;
import net.astah.stpa.stamp.notation.PreconditionTable;
import net.astah.stpa.stamp.notation.STAMPControlLoopDiagram;
import net.astah.stpa.stamp.notation.STAMPControlStructureDiagram;
import net.astah.stpa.stamp.notation.UCATable;
import net.astah.stpa.stamp.notation.util.STAMPNotationSwitch;
import net.astah.stpa.stamp.ui.Messages;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;

public class AnalysisProcedureView
extends ModelUIView
implements MouseListener,
EntityStoreListener {
    private final JTree tree;
    private static final Color PREPARED_COLOR = Color.BLUE;
    private static final Color NON_PREPARED_COLOR = Color.BLACK;
    private static final Color SELECTED_COLOR = Color.WHITE;
    private final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
    String packageNode = "platform:/plugin/net.astah.stpa.stamp.notation.edit/icons/full/obj16/PackageNode.png";
    String leafNode = "platform:/plugin/net.astah.stpa.stamp.notation.edit/icons/full/obj16/LeafNode.png";

    public AnalysisProcedureView(IEntityStore doc) {
        final UIFactory uiFactory = new UIFactory(new ResourceBundleList());
        doc.addEntityStoreListener((EntityStoreListener)this);
        this.tree = new JTree(){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent event) {
                TreePath path = this.getPathForLocation(event.getX(), event.getY());
                if (path != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    TreeUserObject treeUserObject = (TreeUserObject)node.getUserObject();
                    return treeUserObject.getToolTipText();
                }
                return null;
            }
        };
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                ToolTipManager.sharedInstance().setDismissDelay(AnalysisProcedureView.this.defaultDismissTimeout);
            }
        });
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public void updateUI() {
                super.updateUI();
                this.setOpenIcon(uiFactory.getResourceImageIcon(AnalysisProcedureView.this.packageNode));
                this.setClosedIcon(uiFactory.getResourceImageIcon(AnalysisProcedureView.this.packageNode));
                this.setLeafIcon(uiFactory.getResourceImageIcon(AnalysisProcedureView.this.leafNode));
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                this.setForeground(AnalysisProcedureView.this.getNodeForegroundColor(value, selected));
                return this;
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setModel(this.getTreeModel());
        this.tree.setLargeModel(true);
        this.init();
    }

    private void init() {
        JScrollPane scrollPane = new JScrollPane(this.tree);
        SwingComponent baseComponent = new SwingComponent((Component)scrollPane);
        this.setBaseComponent((CComponent)baseComponent);
        this.component = baseComponent;
        this.addComponent((CComponent)baseComponent);
        this.expandAll(this.tree, new TreePath(this.tree.getModel().getRoot()));
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    JTree tree = (JTree)e.getSource();
                    TreePath path = tree.getPathForLocation(e.getX(), e.getY());
                    AnalysisProcedureView.this.openOrCreateDiagram(path);
                }
            }
        });
    }

    private void expandAll(JTree tree, TreePath parent) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        Collections.list(node.children()).stream().filter(TreeNode.class::isInstance).map(TreeNode.class::cast).forEach(n -> this.expandAll(tree, parent.pathByAddingChild(n)));
        tree.expandPath(parent);
    }

    public String getViewTitle() {
        return Messages.AnalysisProcedureView_title;
    }

    public void setParent(GroupUIView p) {
        super.setParent(p);
        if (p == null) {
            JTreeBuilder.dispose((JTree)this.tree);
        }
    }

    protected TreeModel getTreeModel() {
        DiagramNodePredicate predicate = new DiagramNodePredicate();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new TreeUserObject(Messages.AnalysisProcedureView_stpa_analysis_procedure_title, predicate));
        DefaultMutableTreeNode step0 = new DefaultMutableTreeNode(new TreeUserObject(Messages.AnalysisProcedureView_step_0_title, predicate));
        root.add(step0);
        DefaultMutableTreeNode preparation1 = new DefaultMutableTreeNode(new TreeUserObject(Messages.AnalysisProcedureView_preparation_1_title, predicate));
        step0.add(preparation1);
        preparation1.add(new DefaultMutableTreeNode(new TreeUserObject(Messages.AnalysisProcedureView_precondition_title, Messages.AnalysisProcedureView_CreatePreconditionCommand, PreconditionTable.class, Messages.AnalysisProcedureView_precondition_tooltip, predicate)));
        preparation1.add(new DefaultMutableTreeNode(new TreeUserObject(Messages.AnalysisProcedureView_accident_hazard_safety_constraint_title, Messages.AnalysisProcedureView_CreateAccidentHazardSafetyConstraintCommand, AccidentHazardSafetyConstraintTable.class, Messages.AnalysisProcedureView_accident_hazard_safety_constraint_tooltip, predicate)));
        preparation1.add(new DefaultMutableTreeNode(new TreeUserObject(Messages.AnalysisProcedureView_component_extracting_title, Messages.AnalysisProcedureView_CreateComponentExtractingCommand, ComponentExtractingTable.class, Messages.AnalysisProcedureView_component_extracting_tooltip, predicate)));
        DefaultMutableTreeNode preparation2 = new DefaultMutableTreeNode(new TreeUserObject(Messages.AnalysisProcedureView_preparation_2_title, predicate));
        step0.add(preparation2);
        preparation2.add(new DefaultMutableTreeNode(new TreeUserObject(Messages.AnalysisProcedureView_control_structure_title, Messages.AnalysisProcedureView_CreateControlStructureDiagramCommand, STAMPControlStructureDiagram.class, Messages.AnalysisProcedureView_control_structure_tooltip, predicate)));
        DefaultMutableTreeNode step1 = new DefaultMutableTreeNode(new TreeUserObject(Messages.AnalysisProcedureView_step_1_title, predicate));
        root.add(step1);
        step1.add(new DefaultMutableTreeNode(new TreeUserObject(Messages.AnalysisProcedureView_uca_title, Messages.AnalysisProcedureView_CreateUCATableCommand, UCATable.class, Messages.AnalysisProcedureView_uca_tooltip, predicate)));
        DefaultMutableTreeNode step2 = new DefaultMutableTreeNode(new TreeUserObject(Messages.AnalysisProcedureView_step_2_title, predicate));
        root.add(step2);
        DefaultMutableTreeNode hcf = new DefaultMutableTreeNode(new TreeUserObject(Messages.AnalysisProcedureView_hcf_title, Messages.AnalysisProcedureView_hcf_tooltip));
        step2.add(hcf);
        hcf.add(new DefaultMutableTreeNode(new TreeUserObject(Messages.AnalysisProcedureView_control_loop_diagram_title, Messages.AnalysisProcedureView_CreateControlLoopDiagramCommand, STAMPControlLoopDiagram.class, Messages.AnalysisProcedureView_control_loop_diagram_tooltip, predicate)));
        hcf.add(new DefaultMutableTreeNode(new TreeUserObject(Messages.AnalysisProcedureView_hcf_diagram_title, Messages.AnalysisProcedureView_CreateHCFTableCommand, HCFTable.class, Messages.AnalysisProcedureView_hcf_diagram_tooltip, predicate)));
        DefaultMutableTreeNode step3 = new DefaultMutableTreeNode(new TreeUserObject(Messages.AnalysisProcedureView_countermeasure_title, Messages.AnalysisProcedureView_CreateCountermeasureTableCommand, CountermeasureTable.class, Messages.AnalysisProcedureView_countermeasure_tooltip, predicate));
        root.add(step3);
        return new DefaultTreeModel(root);
    }

    private void openOrCreateDiagram(TreePath path) {
        if (path == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (node.getUserObject() != null) {
            TreeUserObject treeUserObject = (TreeUserObject)node.getUserObject();
            if (!treeUserObject.isDiagramNode()) {
                return;
            }
            Diagram diagram = treeUserObject.getDiagram();
            if (diagram != null) {
                if (this.isCreateNewDiagram(diagram)) {
                    treeUserObject.createDiagram();
                } else if (diagram instanceof TableView) {
                    this.openMatrixDiagram(diagram);
                } else {
                    this.openDiagram(diagram);
                }
            } else {
                treeUserObject.createDiagram();
            }
        }
    }

    private Diagram getDiagram(Class<? extends Diagram> diagramClass) {
        IJomtEntityStore doc = ModelGlobal.prjManager.getCurrentProject().doc;
        Project project = ProjectManagerAdapter.getRootProject((Notifier)doc.getDomain().getResourceSet());
        return (Diagram)Facets.getFirstContent((Project)project, (String)STAMPPlugin.FACET_SYMBOLIC_NAME, diagramClass, null);
    }

    private boolean isCreateNewDiagram(Diagram diagram) {
        return diagram instanceof STAMPControlLoopDiagram || diagram instanceof HCFTable;
    }

    private void openMatrixDiagram(Diagram diagram) {
        OpenTableEditorCommand command = new OpenTableEditorCommand();
        command.setElement((net.astah.dd.di.Diagram)diagram);
        CommandManager.instance().callCommand((Command)command);
    }

    private void openDiagram(Diagram diagram) {
        OpenDiagramEditorCommand command = new OpenDiagramEditorCommand();
        DiagramViewInfo viewInfo = new DiagramViewInfo((net.astah.dd.di.Diagram)diagram, new GCamera());
        command.setDiagramViewInfo(viewInfo);
        CommandManager.instance().callCommand((Command)command);
    }

    private Color getNodeForegroundColor(Object node, boolean selected) {
        if (selected) {
            return SELECTED_COLOR;
        }
        return this.isPrepared(node) ? PREPARED_COLOR : NON_PREPARED_COLOR;
    }

    private boolean isPrepared(Object node) {
        if (!(node instanceof DefaultMutableTreeNode)) {
            return false;
        }
        Object uo = ((DefaultMutableTreeNode)node).getUserObject();
        return uo instanceof TreeUserObject ? ((TreeUserObject)uo).isPrepared() : false;
    }

    public void entityStoreChanged(EntityStoreEvent e) {
        this.tree.updateUI();
    }

    class TreeUserObject {
        private String name;
        private String commandName;
        private Class<? extends Diagram> targetDiagramClass;
        private String toolTipText;
        private DiagramNodePredicate predicate;

        TreeUserObject(String name, DiagramNodePredicate predicate) {
            this(name, null, null, null, predicate);
        }

        TreeUserObject(String name, String toolTipText) {
            this(name, null, null, toolTipText, null);
        }

        TreeUserObject(String name, String commandName, Class<? extends Diagram> targetDiagramClass, String toolTipText, DiagramNodePredicate predicate) {
            this.name = name;
            this.commandName = commandName;
            this.targetDiagramClass = targetDiagramClass;
            this.toolTipText = toolTipText;
            this.predicate = predicate;
        }

        public String toString() {
            return this.name;
        }

        public Diagram getDiagram() {
            if (this.targetDiagramClass == null) {
                return null;
            }
            return AnalysisProcedureView.this.getDiagram(this.targetDiagramClass);
        }

        public boolean isDiagramNode() {
            return this.targetDiagramClass != null;
        }

        public void createDiagram() {
            CommandEvent event = new CommandEvent((Object)this, 0, this.commandName, 0, 1);
            if (CommandManager.instance() != null) {
                CommandManager.instance().commandPerformed(event);
            }
        }

        public String getToolTipText() {
            return this.toolTipText;
        }

        public boolean isPrepared() {
            if (this.predicate != null) {
                Diagram diagram = this.getDiagram();
                return diagram != null && (Boolean)this.predicate.doSwitch((EObject)diagram) != false;
            }
            return false;
        }
    }

    private static class DiagramNodePredicate
    extends STAMPNotationSwitch<Boolean> {
        private DiagramNodePredicate() {
        }

        public Boolean casePreconditionTable(PreconditionTable object) {
            STPAAnalysis scope = object.getScope();
            return !scope.getPreconditions().isEmpty();
        }

        public Boolean caseAccidentHazardSafetyConstraintTable(AccidentHazardSafetyConstraintTable object) {
            STPAAnalysis scope = object.getScope();
            return !scope.getAccidents().isEmpty();
        }

        public Boolean caseComponentExtractingTable(ComponentExtractingTable object) {
            return object.getScope().getControlStructures().stream().anyMatch(cs -> !cs.getComponents().isEmpty());
        }

        public Boolean caseUCATable(UCATable object) {
            UCAAnalysis analysis = object.getAnalysis();
            return !analysis.getControlActions().isEmpty();
        }

        public Boolean caseCountermeasureTable(CountermeasureTable object) {
            STPAAnalysis scope = object.getScope();
            return !scope.getCountermeasures().isEmpty();
        }

        public Boolean caseHCFTable(HCFTable object) {
            return true;
        }

        public Boolean caseSTAMPControlStructureDiagram(STAMPControlStructureDiagram object) {
            return true;
        }

        public Boolean caseSTAMPControlLoopDiagram(STAMPControlLoopDiagram object) {
            return true;
        }

        public Boolean defaultCase(EObject object) {
            return false;
        }
    }
}

