/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.menu.handler;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.JMenuItem;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.util.DiagramElements;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.emf.edit.job.CommandJob;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.swing.Selections;
import net.astah.stpa.stamp.Component;
import net.astah.stpa.stamp.ProcessModel;
import net.astah.stpa.stamp.STAMPFactory;
import net.astah.stpa.stamp.STAMPPackage;
import net.astah.stpa.stamp.notation.STAMPCompartment;
import net.astah.stpa.stamp.notation.STAMPComponentShape;
import net.astah.stpa.stamp.notation.STAMPNotationPackage;
import net.astah.stpa.stamp.notation.edit.command.SynchronizeProcessModelCommand;
import net.astah.stpa.stamp.ui.menu.handler.Compartments;
import net.astah.ui.menu.annotation.AboutToShow;
import net.astah.ui.menu.annotation.CanExecute;
import net.astah.ui.menu.annotation.Execute;
import net.astah.ui.menu.annotation.Handler;
import net.astah.ui.menu.annotation.MenuCommand;
import net.astah.ui.menu.annotation.MenuItem;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

@Handler
@MenuItem(label="%StampControlStructureDiagram_showProcessModelCompartment_label", tooltip="%StampControlStructureDiagram_showProcessModelCompartment_tooltip", type=MenuItem.ItemKind.CHECK)
@MenuCommand(id="stpa.ShowProcessModelCompartmentCommand", category="edit.show_diagram_element")
public class ShowProcessModelCompartmentHandler {
    private Command command = UnexecutableCommand.INSTANCE;

    @Execute
    public void execute(ISelection selection, List<String> params, ActionEvent e) {
        STAMPComponentShape shape = (STAMPComponentShape)Selections.getFirstElement((ISelection)selection);
        Component component = (Component)DiagramElements.getModelElement((DiagramElement)shape, Component.class);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)component);
        CommandJob job = new CommandJob(domain, this.command);
        job.schedule();
    }

    private Command getCommand(ISelection selection) {
        if (Selections.size((ISelection)selection) != 1) {
            return UnexecutableCommand.INSTANCE;
        }
        Object element = Selections.getFirstElement((ISelection)selection);
        if (!(element instanceof STAMPComponentShape)) {
            return UnexecutableCommand.INSTANCE;
        }
        STAMPComponentShape shape = (STAMPComponentShape)element;
        if (shape.isOmitted()) {
            return UnexecutableCommand.INSTANCE;
        }
        Component component = (Component)DiagramElements.getModelElement((DiagramElement)shape, Component.class);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)component);
        ProcessModel processModel = component.getProcessModel();
        STAMPCompartment compartment = Compartments.getProcessModelCompartment((EList<STAMPCompartment>)shape.getCompartments(), processModel);
        return compartment == null ? this.createCreateCompartmentCommand((EditingDomain)domain, component, processModel, shape) : this.createDeleteCompartmentCommand((EditingDomain)domain, compartment);
    }

    private Command createCreateCompartmentCommand(EditingDomain domain, Component component, ProcessModel existingProcessModel, STAMPComponentShape shape) {
        CompoundCommand command = new CompoundCommand();
        if (existingProcessModel == null) {
            ProcessModel processModel = STAMPFactory.eINSTANCE.createProcessModel();
            command.append(CreateChildCommand.create((EditingDomain)domain, (Object)component, (Object)new CommandParameter((Object)component, (Object)STAMPPackage.Literals.COMPONENT__PROCESS_MODEL, (Object)processModel), Collections.singleton(component)));
            STAMPCompartment compartment = Compartments.createCompartment(processModel);
            command.append(AddCommand.create((EditingDomain)domain, (Object)shape, (Object)STAMPNotationPackage.Literals.STAMP_COMPARTMENTABLE_SHAPE__COMPARTMENT, (Object)compartment));
        } else {
            STAMPCompartment compartment = Compartments.createCompartment(existingProcessModel);
            command.append(AddCommand.create((EditingDomain)domain, (Object)shape, (Object)STAMPNotationPackage.Literals.STAMP_COMPARTMENTABLE_SHAPE__COMPARTMENT, (Object)compartment));
            command.appendIfCanExecute((Command)new SynchronizeProcessModelCommand(domain, compartment));
        }
        return command;
    }

    private Command createDeleteCompartmentCommand(EditingDomain domain, STAMPCompartment compartment) {
        return DestroyCommand.create((EditingDomain)domain, (Object)compartment);
    }

    @CanExecute
    public boolean canExecute(ISelection selection) {
        this.command.dispose();
        this.command = this.getCommand(selection);
        return this.command.canExecute();
    }

    @AboutToShow
    public void aboutToShow(ISelection selection, JMenuItem menuItem, List<String> params) {
        STAMPComponentShape shape = (STAMPComponentShape)Selections.getFirstElement((ISelection)selection);
        Component component = (Component)DiagramElements.getModelElement((DiagramElement)shape, Component.class);
        ProcessModel processModel = component.getProcessModel();
        menuItem.setSelected(this.hasProcessModel((EList<STAMPCompartment>)shape.getCompartments(), processModel));
    }

    private boolean hasProcessModel(EList<STAMPCompartment> compartments, ProcessModel processModel) {
        return Compartments.getProcessModelCompartment(compartments, processModel) != null;
    }
}

