/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.menu.handler;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.util.DiagramElements;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.emf.edit.job.CommandJob;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.swing.Selections;
import net.astah.stpa.stamp.Component;
import net.astah.stpa.stamp.ProcessModel;
import net.astah.stpa.stamp.STAMPFactory;
import net.astah.stpa.stamp.STAMPPackage;
import net.astah.stpa.stamp.notation.STAMPCompartment;
import net.astah.stpa.stamp.notation.STAMPComponentShape;
import net.astah.stpa.stamp.notation.STAMPNotationPackage;
import net.astah.stpa.stamp.notation.edit.command.SynchronizeProcessModelCommand;
import net.astah.stpa.stamp.ui.menu.handler.Compartments;
import net.astah.ui.menu.annotation.CanExecute;
import net.astah.ui.menu.annotation.Execute;
import net.astah.ui.menu.annotation.Handler;
import net.astah.ui.menu.annotation.MenuCommand;
import net.astah.ui.menu.annotation.MenuItem;
import net.astah.ui.menu.annotation.MenuItems;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

@Handler(commands={"stpa.ShowPluralProcessModelCompartmentCommand"})
@MenuItems(value={@MenuItem(commands={@MenuCommand(id="stpa.ShowPluralProcessModelCompartmentCommand", category="edit.show_diagram_element")}, path="ShowPluralProcessModelCompartment", label="%StampControlStructureDiagram_showProcessModelCompartment_label", tooltip="%StampControlStructureDiagram_showProcessModelCompartment_tooltip", type=MenuItem.ItemKind.MENU), @MenuItem(commands={@MenuCommand(id="stpa.ShowPluralProcessModelCompartmentCommand", category="edit.show_diagram_element", parameters={"on"})}, path="ShowPluralProcessModelCompartment.on", label="%StampControlStructureDiagram_showPluralProcessModelCompartment_on_label", tooltip="%StampControlStructureDiagram_showPluralProcessModelCompartment_on_tooltip", type=MenuItem.ItemKind.PUSH), @MenuItem(commands={@MenuCommand(id="stpa.ShowPluralProcessModelCompartmentCommand", category="edit.show_diagram_element", parameters={"off"})}, path="ShowPluralProcessModelCompartment.off", label="%StampControlStructureDiagram_showPluralProcessModelCompartment_off_label", tooltip="%StampControlStructureDiagram_showPluralProcessModelCompartment_off_tooltip", type=MenuItem.ItemKind.PUSH)})
public class ShowPluralProcessModelCompartmentHandler {
    static final String ON = "on";
    static final String OFF = "off";

    @Execute
    public void execute(ISelection selection, List<String> params, ActionEvent e) {
        List shapes = Selections.stream((ISelection)selection).filter(o -> this.isTarget(o)).map(it -> (STAMPComponentShape)it).collect(Collectors.toList());
        EObject element = DiagramElements.getModelElement((DiagramElement)((DiagramElement)shapes.get(0)));
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)element);
        CompoundCommand command = new CompoundCommand();
        for (STAMPComponentShape shape : shapes) {
            Component component = (Component)DiagramElements.getModelElement((DiagramElement)shape, Component.class);
            ProcessModel processModel = component.getProcessModel();
            STAMPCompartment compartment = Compartments.getProcessModelCompartment((EList<STAMPCompartment>)shape.getCompartments(), processModel);
            if (ON.equals(params.get(0))) {
                if (compartment != null) continue;
                this.createCreateCompartmentCommand((EditingDomain)domain, component, processModel, shape, command);
                continue;
            }
            if (compartment == null) continue;
            this.createDeleteCompartmentCommand((EditingDomain)domain, compartment, command);
        }
        CommandJob job = new CommandJob(domain, (Command)command);
        job.schedule();
    }

    private void createCreateCompartmentCommand(EditingDomain domain, Component component, ProcessModel existingProcessModel, STAMPComponentShape shape, CompoundCommand command) {
        if (existingProcessModel == null) {
            ProcessModel processModel = STAMPFactory.eINSTANCE.createProcessModel();
            command.append(CreateChildCommand.create((EditingDomain)domain, (Object)component, (Object)new CommandParameter((Object)component, (Object)STAMPPackage.Literals.COMPONENT__PROCESS_MODEL, (Object)processModel), Collections.singleton(component)));
            STAMPCompartment compartment = Compartments.createCompartment(processModel);
            command.append(AddCommand.create((EditingDomain)domain, (Object)shape, (Object)STAMPNotationPackage.Literals.STAMP_COMPARTMENTABLE_SHAPE__COMPARTMENT, (Object)compartment));
        } else {
            STAMPCompartment compartment = Compartments.createCompartment(existingProcessModel);
            command.append(AddCommand.create((EditingDomain)domain, (Object)shape, (Object)STAMPNotationPackage.Literals.STAMP_COMPARTMENTABLE_SHAPE__COMPARTMENT, (Object)compartment));
            command.appendIfCanExecute((Command)new SynchronizeProcessModelCommand(domain, compartment));
        }
    }

    private void createDeleteCompartmentCommand(EditingDomain domain, STAMPCompartment compartment, CompoundCommand command) {
        command.append(DestroyCommand.create((EditingDomain)domain, (Object)compartment));
    }

    @CanExecute
    public boolean canExecute(ISelection selection) {
        return 2 <= Selections.size((ISelection)selection) && Selections.stream((ISelection)selection).anyMatch(o -> this.isTarget(o));
    }

    private boolean isTarget(Object object) {
        return object instanceof STAMPComponentShape && !((STAMPComponentShape)object).isOmitted();
    }
}

