/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.menu.handler;

import java.util.List;
import java.util.MissingResourceException;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.util.DiagramElements;
import net.astah.emf.edit.provider.ExtraLabelVariant;
import net.astah.emf.edit.provider.LabelProviders;
import net.astah.golf.util.UIFactory;
import net.astah.golf.widget.CIcon;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.swing.Selections;
import net.astah.golf.widget.swing.SwingIcon;
import net.astah.golf.widget.swing.SwingIconRegistry;
import net.astah.stpa.stamp.notation.STAMPCompartmentableShape;
import net.astah.stpa.stamp.notation.STAMPControlLoopDiagram;
import net.astah.stpa.stamp.notation.STAMPControlStructureDiagram;
import net.astah.stpa.stamp.notation.STAMPDiagram;
import net.astah.ui.menu.annotation.AboutToShow;
import net.astah.ui.menu.annotation.CanExecute;
import net.astah.ui.menu.annotation.Handler;
import net.astah.ui.menu.annotation.MenuCommand;
import net.astah.ui.menu.annotation.MenuItem;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Handler(targets={STAMPCompartmentableShape.class, STAMPControlStructureDiagram.class, STAMPControlLoopDiagram.class})
@MenuItem(label="%StampControlStructureDiagram_showInStructureTree_label", tooltip="%StampControlStructureDiagram_showInStructureTree_tooltip", type=MenuItem.ItemKind.MENU)
@MenuCommand(id="stpa.ShowInStructureTreeCommand", category="edit.select_show")
public class ShowInStructureTreeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ShowInStructureTreeHandler.class);

    @CanExecute
    public boolean canExecute(ISelection selection) {
        return Selections.size((ISelection)selection) == 1;
    }

    @AboutToShow
    public void aboutToShow(ISelection selection, JMenuItem menuItem, List<String> params) {
        if (Selections.size((ISelection)selection) > 1) {
            return;
        }
        Object object = Selections.getFirstElement((ISelection)selection);
        if (!(object instanceof DiagramElement)) {
            return;
        }
        Object element = object instanceof STAMPDiagram ? (STAMPDiagram)object : DiagramElements.getModelElement((DiagramElement)((DiagramElement)object));
        if (element == null) {
            return;
        }
        String name = LabelProviders.getText((Object)element, (Object)ExtraLabelVariant.MODEL_TREE);
        String action = "ShowInStructTree%" + EcoreUtil.getURI((EObject)element);
        CIcon cIcon = this.getIcon((EObject)element);
        menuItem.add(UIFactory.createMenuItem((String)name, (String)action, (CIcon)cIcon));
    }

    private CIcon getIcon(EObject element) {
        try {
            Object image = LabelProviders.getImage((Object)element);
            if (image != null) {
                Icon icon = SwingIconRegistry.INSTANCE.getIcon(image);
                return new SwingIcon(icon);
            }
        }
        catch (MissingResourceException e) {
            LOG.warn("Failed to get an image: {}", (Object)e.getMessage());
        }
        return null;
    }
}

