/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.menu.handler;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JMenuItem;
import net.astah.dd.dg.GraphicalElement;
import net.astah.dd.dg.Group;
import net.astah.dd.dg.Rectangle;
import net.astah.dd.dg.Text;
import net.astah.dd.dg.util.DGStyleResolver;
import net.astah.golf.control.GolfAction;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.swing.Selections;
import net.astah.ui.menu.annotation.AboutToShow;
import net.astah.ui.menu.annotation.CanExecute;
import net.astah.ui.menu.annotation.Execute;
import net.astah.ui.menu.annotation.Handler;
import net.astah.ui.menu.annotation.MenuCommand;
import net.astah.ui.menu.annotation.MenuItem;
import net.astah.ui.menu.annotation.MenuItems;
import org.eclipse.emf.ecore.EObject;

@Handler(commands={"stpa.SetTextStyleCommand"})
@MenuItems(value={@MenuItem(commands={@MenuCommand(id="stpa.SetTextStyleCommand", category="edit.text_style")}, path="TextStyle", label="%StampControlStructureDiagram_textStyle_label", tooltip="%StampControlStructureDiagram_textStyle_tooltip", type=MenuItem.ItemKind.MENU), @MenuItem(commands={@MenuCommand(id="stpa.SetTextStyleCommand", category="edit.text_style", parameters={"border_rect"})}, path="TextStyle.border_rect", label="%StampControlStructureDiagram_textStyle_rectangle_label", tooltip="%StampControlStructureDiagram_textStyle_rectangle_tooltip", type=MenuItem.ItemKind.CHECK), @MenuItem(commands={@MenuCommand(id="stpa.SetTextStyleCommand", category="edit.text_style", parameters={"border_none"})}, path="TextStyle.border_none", label="%StampControlStructureDiagram_textStyle_none_label", tooltip="%StampControlStructureDiagram_textStyle_none_tooltip", type=MenuItem.ItemKind.CHECK)})
public class SetTextStyleHandler {
    @Execute
    public void execute(ISelection selection, List<String> params, ActionEvent e) {
        GolfAction action = new GolfAction("net.astah.jomt.jcontrol.SetTextStyle%" + params.get(0));
        action.actionPerformed(e);
    }

    @CanExecute
    public boolean canExecute(ISelection selection) {
        return Selections.size((ISelection)selection) == 1 && this.isText(Selections.getFirstElement((ISelection)selection));
    }

    private boolean isText(Object object) {
        Group group;
        if (object instanceof Rectangle && (group = ((Rectangle)object).getGroup()) != null) {
            return group.getMembers().stream().anyMatch(Text.class::isInstance);
        }
        return false;
    }

    @AboutToShow
    public void aboutToShow(ISelection selection, JMenuItem menuItem, List<String> params) {
        if (params.isEmpty()) {
            return;
        }
        boolean isSameTextStyle = this.isSameTextStyle(Selections.getFirstElement((ISelection)selection), params.get(0));
        menuItem.setSelected(isSameTextStyle);
    }

    private boolean isSameTextStyle(Object object, String textStyle) {
        if (object instanceof Rectangle) {
            Rectangle rect = (Rectangle)object;
            double width = DGStyleResolver.getInstance((EObject)rect).resolveStrokeWidth((GraphicalElement)rect);
            switch (textStyle) {
                case "border_rect": {
                    return width > 0.0;
                }
                case "border_none": {
                    return width == 0.0;
                }
            }
        }
        return false;
    }
}

