/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.menu.handler;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JMenuItem;
import net.astah.dd.dg.Group;
import net.astah.dd.dg.Rectangle;
import net.astah.dd.dg.Text;
import net.astah.golf.control.GolfAction;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.swing.Selections;
import net.astah.ui.menu.annotation.AboutToShow;
import net.astah.ui.menu.annotation.CanExecute;
import net.astah.ui.menu.annotation.Execute;
import net.astah.ui.menu.annotation.Handler;
import net.astah.ui.menu.annotation.MenuCommand;
import net.astah.ui.menu.annotation.MenuItem;
import net.astah.ui.menu.annotation.MenuItems;

@Handler(commands={"stpa.SetRectTypeCommand"})
@MenuItems(value={@MenuItem(commands={@MenuCommand(id="stpa.SetRectTypeCommand", category="edit.rect")}, path="RectType", label="%StampControlStructureDiagram_rectType_label", tooltip="%StampControlStructureDiagram_rectType_tooltip", type=MenuItem.ItemKind.MENU), @MenuItem(commands={@MenuCommand(id="stpa.SetRectTypeCommand", category="edit.rect", parameters={""})}, path="RectType.", label="%StampControlStructureDiagram_rectType_rectangle_label", iconURI="platform:/plugin/net.astah.core.app/net/astah/jomt/resource/images/rect.png", tooltip="%StampControlStructureDiagram_rectType_rectangle_tooltip", type=MenuItem.ItemKind.CHECK), @MenuItem(commands={@MenuCommand(id="stpa.SetRectTypeCommand", category="edit.rect", parameters={"round"})}, path="RectType.round", label="%StampControlStructureDiagram_rectType_round_label", iconURI="platform:/plugin/net.astah.core.app/net/astah/jomt/resource/images/state.png", tooltip="%StampControlStructureDiagram_rectType_round_tooltip", type=MenuItem.ItemKind.CHECK)})
public class SetRectTypeHandler {
    @Execute
    public void execute(ISelection selection, List<String> params, ActionEvent e) {
        GolfAction action = new GolfAction("net.astah.jomt.jcontrol.SetRectType%" + params.get(0));
        action.actionPerformed(e);
    }

    @CanExecute
    public boolean canExecute(ISelection selection) {
        return !Selections.isEmpty((ISelection)selection) && Selections.stream((ISelection)selection).allMatch(object -> this.isTarget(object));
    }

    private boolean isTarget(Object object) {
        return object instanceof Rectangle && !this.isText((Rectangle)object);
    }

    private boolean isText(Rectangle rect) {
        Group group = rect.getGroup();
        if (group != null) {
            return group.getMembers().stream().anyMatch(Text.class::isInstance);
        }
        return false;
    }

    @AboutToShow
    public void aboutToShow(ISelection selection, JMenuItem menuItem, List<String> params) {
        if (params.isEmpty()) {
            return;
        }
        if (Selections.size((ISelection)selection) > 1) {
            return;
        }
        boolean sameRectType = this.isSameRectType(Selections.getFirstElement((ISelection)selection), params.get(0));
        menuItem.setSelected(sameRectType);
    }

    private boolean isSameRectType(Object object, String rectType) {
        if (object instanceof Rectangle) {
            double cornerRadius = ((Rectangle)object).getCornerRadius();
            switch (rectType) {
                case "round": {
                    return cornerRadius > 0.0;
                }
                case "": {
                    return cornerRadius == 0.0;
                }
            }
        }
        return false;
    }
}

