/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.menu.handler;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JMenuItem;
import net.astah.dd.dg.Ellipse;
import net.astah.dd.dg.GraphicalElement;
import net.astah.dd.dg.Line;
import net.astah.dd.dg.Polyline;
import net.astah.dd.dg.Rectangle;
import net.astah.dd.dg.util.DGStyleResolver;
import net.astah.golf.control.GolfAction;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.swing.Selections;
import net.astah.ui.menu.annotation.AboutToShow;
import net.astah.ui.menu.annotation.CanExecute;
import net.astah.ui.menu.annotation.Execute;
import net.astah.ui.menu.annotation.Handler;
import net.astah.ui.menu.annotation.MenuCommand;
import net.astah.ui.menu.annotation.MenuItem;
import net.astah.ui.menu.annotation.MenuItems;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

@Handler(commands={"stpa.SetLineTypeCommand"})
@MenuItems(value={@MenuItem(commands={@MenuCommand(id="stpa.SetLineTypeCommand", category="edit.style")}, path="LineType", label="%StampControlStructureDiagram_lineType_label", tooltip="%StampControlStructureDiagram_lineType_tooltip", type=MenuItem.ItemKind.MENU), @MenuItem(commands={@MenuCommand(id="stpa.SetLineTypeCommand", category="edit.style", parameters={"line"})}, path="LineType.line", iconURI="platform:/plugin/net.astah.core.app/net/astah/jomt/resource/images/lineStyle1.png", type=MenuItem.ItemKind.CHECK), @MenuItem(commands={@MenuCommand(id="stpa.SetLineTypeCommand", category="edit.style", parameters={"dash1"})}, path="LineType.dash1", iconURI="platform:/plugin/net.astah.core.app/net/astah/jomt/resource/images/lineStyle2.png", type=MenuItem.ItemKind.CHECK), @MenuItem(commands={@MenuCommand(id="stpa.SetLineTypeCommand", category="edit.style", parameters={"dash2"})}, path="LineType.dash2", iconURI="platform:/plugin/net.astah.core.app/net/astah/jomt/resource/images/lineStyle3.png", type=MenuItem.ItemKind.CHECK)})
public class SetLineTypeHandler {
    @Execute
    public void execute(ISelection selection, List<String> params, ActionEvent e) {
        GolfAction action = new GolfAction("net.astah.jomt.jcontrol.SetLineType%" + params.get(0));
        action.actionPerformed(e);
    }

    @CanExecute
    public boolean canExecute(ISelection selection) {
        return !Selections.isEmpty((ISelection)selection) && Selections.stream((ISelection)selection).allMatch(object -> this.isCommonElement(object));
    }

    private boolean isCommonElement(Object object) {
        return object instanceof Line || object instanceof Rectangle || object instanceof Ellipse || object instanceof Polyline;
    }

    @AboutToShow
    public void aboutToShow(ISelection selection, JMenuItem menuItem, List<String> params) {
        if (params.isEmpty()) {
            return;
        }
        if (Selections.size((ISelection)selection) > 1) {
            return;
        }
        boolean isSameLineType = this.isSameLineType(Selections.getFirstElement((ISelection)selection), params.get(0));
        menuItem.setSelected(isSameLineType);
    }

    private boolean isSameLineType(Object object, String type) {
        if (object instanceof GraphicalElement) {
            GraphicalElement element = (GraphicalElement)object;
            String lineType = this.getLineType(element);
            return lineType.equals(type);
        }
        return false;
    }

    private String getLineType(GraphicalElement element) {
        EList dashLengths = DGStyleResolver.getInstance((EObject)element).resolveStrokeDashLengths(element);
        String lineType = "line";
        if (!dashLengths.isEmpty() && dashLengths.size() == 2) {
            double length1;
            double length0 = (Double)dashLengths.get(0);
            if (length0 == (length1 = ((Double)dashLengths.get(1)).doubleValue())) {
                lineType = "dash1";
            } else if (length0 == length1 * 2.0) {
                lineType = "dash2";
            }
        }
        return lineType;
    }
}

