/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.menu.handler;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JMenuItem;
import net.astah.golf.control.GolfAction;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.swing.Selections;
import net.astah.notation.Curve;
import net.astah.notation.Edge;
import net.astah.notation.Line;
import net.astah.notation.LineConstraint;
import net.astah.notation.RightAngleCurve;
import net.astah.notation.RightAngleLine;
import net.astah.stpa.stamp.notation.STAMPEdge;
import net.astah.ui.menu.annotation.AboutToShow;
import net.astah.ui.menu.annotation.CanExecute;
import net.astah.ui.menu.annotation.Execute;
import net.astah.ui.menu.annotation.Handler;
import net.astah.ui.menu.annotation.MenuCommand;
import net.astah.ui.menu.annotation.MenuItem;
import net.astah.ui.menu.annotation.MenuItems;

@Handler(commands={"stpa.SetLineShapeCommand"})
@MenuItems(value={@MenuItem(commands={@MenuCommand(id="stpa.SetLineShapeCommand", category="edit.linestyle")}, path="LineStyle", label="%StampControlStructureDiagram_lineStyle_label", tooltip="%StampControlStructureDiagram_lineStyle_tooltip", type=MenuItem.ItemKind.MENU), @MenuItem(commands={@MenuCommand(id="stpa.SetLineShapeCommand", category="edit.linestyle", parameters={"line"})}, path="LineStyle.line", label="%StampControlStructureDiagram_lineStyle_line_label", iconURI="platform:/plugin/net.astah.core.app/net/astah/jomt/resource/images/rightAngleOff.png", tooltip="%StampControlStructureDiagram_lineStyle_line_tooltip", type=MenuItem.ItemKind.CHECK), @MenuItem(commands={@MenuCommand(id="stpa.SetLineShapeCommand", category="edit.linestyle", parameters={"line_right_angle"})}, path="LineStyle.line_right_angle", label="%StampControlStructureDiagram_lineStyle_rightAngleLine_label", iconURI="platform:/plugin/net.astah.core.app/net/astah/jomt/resource/images/rightAngleOn.png", tooltip="%StampControlStructureDiagram_lineStyle_rightAngleLine_tooltip", type=MenuItem.ItemKind.CHECK), @MenuItem(commands={@MenuCommand(id="stpa.SetLineShapeCommand", category="edit.linestyle", parameters={"curve"})}, path="LineStyle.curve", label="%StampControlStructureDiagram_lineStyle_curve_label", iconURI="platform:/plugin/net.astah.core.app/net/astah/jomt/resource/images/curve.png", tooltip="%StampControlStructureDiagram_lineStyle_curve_tooltip", type=MenuItem.ItemKind.CHECK), @MenuItem(commands={@MenuCommand(id="stpa.SetLineShapeCommand", category="edit.linestyle", parameters={"curve_right_angle"})}, path="LineStyle.curve_right_angle", label="%StampControlStructureDiagram_lineStyle_rightAngleCurve_label", iconURI="platform:/plugin/net.astah.core.app/net/astah/jomt/resource/images/curve_right_angle.png", tooltip="%StampControlStructureDiagram_lineStyle_rightAngleCurve_tooltip", type=MenuItem.ItemKind.CHECK)})
public class SetLineShapeHandler {
    @Execute
    public void execute(ISelection selection, List<String> params, ActionEvent e) {
        GolfAction action = new GolfAction("net.astah.ui.control.SetLineShape%" + params.get(0));
        action.actionPerformed(e);
    }

    @CanExecute
    public boolean canExecute(ISelection selection) {
        return Selections.stream((ISelection)selection).anyMatch(STAMPEdge.class::isInstance);
    }

    @AboutToShow
    public void aboutToShow(ISelection selection, JMenuItem menuItem, List<String> params) {
        if (params.isEmpty()) {
            return;
        }
        if (Selections.size((ISelection)selection) > 1) {
            return;
        }
        boolean isSameLineShape = this.isSameLineShape(Selections.getFirstElement((ISelection)selection), params.get(0));
        menuItem.setSelected(isSameLineShape);
    }

    private boolean isSameLineShape(Object object, String lineShape) {
        if (object instanceof Edge) {
            LineConstraint line = ((Edge)object).getLine();
            switch (lineShape) {
                case "line": {
                    return line instanceof Line;
                }
                case "line_right_angle": {
                    return line instanceof RightAngleLine;
                }
                case "curve": {
                    return line instanceof Curve;
                }
                case "curve_right_angle": {
                    return line instanceof RightAngleCurve;
                }
            }
        }
        return false;
    }
}

