/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.menu.handler;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JMenuItem;
import net.astah.dd.dg.GraphicalElement;
import net.astah.dd.dg.Line;
import net.astah.dd.dg.MarkedElement;
import net.astah.dd.dg.Marker;
import net.astah.dd.dg.Polyline;
import net.astah.dd.dg.util.DGStyleResolver;
import net.astah.golf.control.GolfAction;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.swing.Selections;
import net.astah.notation.resource.NotationResources;
import net.astah.ui.menu.annotation.AboutToShow;
import net.astah.ui.menu.annotation.CanExecute;
import net.astah.ui.menu.annotation.Execute;
import net.astah.ui.menu.annotation.Handler;
import net.astah.ui.menu.annotation.MenuCommand;
import net.astah.ui.menu.annotation.MenuItem;
import net.astah.ui.menu.annotation.MenuItems;
import org.eclipse.emf.ecore.EObject;

@Handler(commands={"stpa.SetLineArrowCommand"})
@MenuItems(value={@MenuItem(commands={@MenuCommand(id="stpa.SetLineArrowCommand", category="edit.style")}, path="LineArrow", label="%StampControlStructureDiagram_lineArrow_label", tooltip="%StampControlStructureDiagram_lineArrow_tooltip", type=MenuItem.ItemKind.MENU), @MenuItem(commands={@MenuCommand(id="stpa.SetLineArrowCommand", category="edit.style", parameters={"noarrow"})}, path="LineArrow.noarrow", iconURI="platform:/plugin/net.astah.core.app/net/astah/jomt/resource/images/lineWithNoArrow.png", type=MenuItem.ItemKind.CHECK), @MenuItem(commands={@MenuCommand(id="stpa.SetLineArrowCommand", category="edit.style", parameters={"startarrow"})}, path="LineArrow.startarrow", iconURI="platform:/plugin/net.astah.core.app/net/astah/jomt/resource/images/lineWithLArrow.png", type=MenuItem.ItemKind.CHECK), @MenuItem(commands={@MenuCommand(id="stpa.SetLineArrowCommand", category="edit.style", parameters={"endarrow"})}, path="LineArrow.endarrow", iconURI="platform:/plugin/net.astah.core.app/net/astah/jomt/resource/images/lineWithRArrow.png", type=MenuItem.ItemKind.CHECK), @MenuItem(commands={@MenuCommand(id="stpa.SetLineArrowCommand", category="edit.style", parameters={"botharrow"})}, path="LineArrow.botharrow", iconURI="platform:/plugin/net.astah.core.app/net/astah/jomt/resource/images/lineWithArrows.png", type=MenuItem.ItemKind.CHECK)})
public class SetLineArrowHandler {
    @Execute
    public void execute(ISelection selection, List<String> params, ActionEvent e) {
        GolfAction action = new GolfAction("net.astah.jomt.jcontrol.SetLineArrow%" + params.get(0));
        action.actionPerformed(e);
    }

    @CanExecute
    public boolean canExecute(ISelection selection) {
        return !Selections.isEmpty((ISelection)selection) && Selections.stream((ISelection)selection).allMatch(object -> this.isTarget(object));
    }

    private boolean isTarget(Object object) {
        return object instanceof Line || this.isFreehand(object);
    }

    private boolean isFreehand(Object object) {
        if (object instanceof Polyline) {
            Polyline polyline = (Polyline)object;
            double strokeOpacity = DGStyleResolver.getInstance((EObject)polyline).resolveStrokeOpacity((GraphicalElement)polyline);
            return strokeOpacity >= 1.0;
        }
        return false;
    }

    @AboutToShow
    public void aboutToShow(ISelection selection, JMenuItem menuItem, List<String> params) {
        if (params.isEmpty()) {
            return;
        }
        if (Selections.size((ISelection)selection) > 1) {
            return;
        }
        boolean isSameLineArrow = this.isSameLineArrow(Selections.getFirstElement((ISelection)selection), params.get(0));
        menuItem.setSelected(isSameLineArrow);
    }

    private boolean isSameLineArrow(Object object, String lineArrow) {
        if (object instanceof MarkedElement) {
            MarkedElement element = (MarkedElement)object;
            Marker start = element.getStartMarker();
            Marker end = element.getEndMarker();
            Marker startMarker = NotationResources.getLibraryMarker((EObject)((EObject)object), (String)"Arrowhead-Start");
            Marker endMarker = NotationResources.getLibraryMarker((EObject)((EObject)object), (String)"Arrowhead-End");
            switch (lineArrow) {
                case "noarrow": {
                    return start == null && end == null;
                }
                case "endarrow": {
                    return start == null && endMarker.equals(end);
                }
                case "startarrow": {
                    return startMarker.equals(start) && end == null;
                }
                case "botharrow": {
                    return startMarker.equals(start) && endMarker.equals(end);
                }
            }
        }
        return false;
    }
}

