/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.menu.handler;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JFrame;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.emf.edit.job.CommandJob;
import net.astah.golf.widget.IListSelection;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.ITableSelection;
import net.astah.golf.widget.swing.SwingFrame;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jview.Editor;
import net.astah.jomt.jview.EditorPeer;
import net.astah.stpa.stamp.Hazard;
import net.astah.stpa.stamp.IdentifiedElement;
import net.astah.stpa.stamp.STAMPPackage;
import net.astah.stpa.stamp.STPAAnalysis;
import net.astah.stpa.stamp.SafetyConstraint;
import net.astah.stpa.stamp.ui.Messages;
import net.astah.stpa.stamp.ui.view.SelectElementDialog;
import net.astah.stpa.stamp.ui.view.swing.AccidentHazardSafetyConstraintTableEditorPeer;
import net.astah.table.Element;
import net.astah.table.TablePackage;
import net.astah.table.Tuple;
import net.astah.ui.menu.annotation.CanExecute;
import net.astah.ui.menu.annotation.Execute;
import net.astah.ui.menu.annotation.Handler;
import net.astah.ui.menu.annotation.MenuCommand;
import net.astah.ui.menu.annotation.MenuItem;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

@Handler
@MenuItem(commands={@MenuCommand(id="stpa.SelectSafetyConstraintCommand", category="edit.table")}, label="%StampTable_selectSafetyConstraint_label", tooltip="%StampTable_selectSafetyConstraint_tooltip", type=MenuItem.ItemKind.PUSH)
public class SelectSafetyConstraintHandler {
    private final int SAFETY_CONSTRAINT_ID_COLUMN = 4;
    private Command command = UnexecutableCommand.INSTANCE;

    @Execute
    public void execute(ISelection selection, List<String> params, ActionEvent e) {
        if (selection instanceof ITableSelection) {
            ITableSelection tableSelection = (ITableSelection)selection;
            IListSelection rowSelection = tableSelection.getRowSelection();
            this.command = this.selectSafetyConstraint((Tuple)rowSelection.getFirstElement());
            CommandJob job = new CommandJob(this.getDomain(), this.command);
            job.schedule();
        }
    }

    private TransactionalEditingDomain getDomain() {
        Editor editor = JomtGlobal.viewManager.getCurrentEditor();
        return TransactionUtil.getEditingDomain((Object)editor.getEditModel());
    }

    @CanExecute
    public boolean canExecute(ISelection selection) {
        return selection instanceof ITableSelection && this.isTarget((ITableSelection)selection);
    }

    private boolean isTarget(ITableSelection selection) {
        Object element = selection.getRowSelection().getFirstElement();
        if (element instanceof Tuple) {
            AccidentHazardSafetyConstraintTableEditorPeer editorPeer = this.getEditorPeer();
            return this.hasHazard((Tuple)element, editorPeer) && this.existSafetyConstraints(editorPeer) && this.isSafetyConstraint(selection.getColumnSelection());
        }
        return false;
    }

    private boolean hasHazard(Tuple tuple, AccidentHazardSafetyConstraintTableEditorPeer editorPeer) {
        return ((Element)tuple.getElements().get(editorPeer.HAZARD_INDEX)).getObject() != null;
    }

    private boolean existSafetyConstraints(AccidentHazardSafetyConstraintTableEditorPeer editorPeer) {
        STPAAnalysis scope = editorPeer.getScope();
        return !scope.getSafetyConstraints().isEmpty();
    }

    private boolean isSafetyConstraint(IListSelection columnSelection) {
        int[] indices = columnSelection.getIndices();
        if (indices.length > 0) {
            return indices[0] >= 4;
        }
        return false;
    }

    private Command selectSafetyConstraint(Tuple rowTuple) {
        AccidentHazardSafetyConstraintTableEditorPeer editorPeer = this.getEditorPeer();
        Hazard hazard = (Hazard)((Element)rowTuple.getElements().get(editorPeer.HAZARD_INDEX)).getObject();
        JFrame parent = (JFrame)((SwingFrame)JomtGlobal.viewManager.getManagementView().getComponent()).getComponent();
        ArrayList<IdentifiedElement> list = new ArrayList<IdentifiedElement>((Collection<IdentifiedElement>)editorPeer.getScope().getSafetyConstraints());
        SelectElementDialog dialog = new SelectElementDialog(parent, list, (IdentifiedElement)((Element)rowTuple.getElements().get(editorPeer.SAFETY_CONSTRAINT_INDEX)).getObject());
        dialog.setTitle(hazard.getId() + " " + Messages.accident_hazard_safety_constraint_table_select_safety_constraint_label);
        dialog.pack();
        dialog.setVisible(true);
        if (dialog.getResultState() == 1) {
            return this.createSetSafetyConstraintCommand(rowTuple, (SafetyConstraint)dialog.getSelectedElement(), editorPeer);
        }
        return this.command;
    }

    private Command createSetSafetyConstraintCommand(Tuple rowTuple, SafetyConstraint safetyConstraint, AccidentHazardSafetyConstraintTableEditorPeer editorPeer) {
        STPAAnalysis scope = editorPeer.getScope();
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)scope);
        EList elements = rowTuple.getElements();
        EObject hazard = ((Element)elements.get(editorPeer.HAZARD_INDEX)).getObject();
        SafetyConstraint oldSafetyConstraint = (SafetyConstraint)((Element)elements.get(editorPeer.SAFETY_CONSTRAINT_INDEX)).getObject();
        CompoundCommand command = new CompoundCommand();
        if (oldSafetyConstraint != null) {
            if (oldSafetyConstraint != safetyConstraint && oldSafetyConstraint.getHazards().size() == 1) {
                command.append(DestroyCommand.create((EditingDomain)domain, (Object)oldSafetyConstraint));
                command.append(AddCommand.create((EditingDomain)domain, (Object)hazard, (Object)STAMPPackage.Literals.HAZARD__SAFETY_CONSTRAINT, (Object)safetyConstraint));
            }
        } else {
            command.append(AddCommand.create((EditingDomain)domain, (Object)hazard, (Object)STAMPPackage.Literals.HAZARD__SAFETY_CONSTRAINT, (Object)safetyConstraint));
        }
        command.append(SetCommand.create((EditingDomain)this.getDomain(), (Object)elements.get(editorPeer.SAFETY_CONSTRAINT_INDEX), (Object)TablePackage.Literals.ELEMENT__OBJECT, (Object)safetyConstraint));
        return command.unwrap();
    }

    private AccidentHazardSafetyConstraintTableEditorPeer getEditorPeer() {
        Editor editor = JomtGlobal.viewManager.getCurrentEditor();
        EditorPeer editorPeer = editor.getEditorPeer();
        return (AccidentHazardSafetyConstraintTableEditorPeer)editorPeer;
    }
}

