/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.menu.handler;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JFrame;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.emf.edit.job.CommandJob;
import net.astah.golf.widget.IListSelection;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.ITableSelection;
import net.astah.golf.widget.swing.SwingFrame;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jview.Editor;
import net.astah.jomt.jview.EditorPeer;
import net.astah.stpa.stamp.Accident;
import net.astah.stpa.stamp.Hazard;
import net.astah.stpa.stamp.IdentifiedElement;
import net.astah.stpa.stamp.STAMPPackage;
import net.astah.stpa.stamp.STPAAnalysis;
import net.astah.stpa.stamp.ui.Messages;
import net.astah.stpa.stamp.ui.view.SelectElementDialog;
import net.astah.stpa.stamp.ui.view.swing.AccidentHazardSafetyConstraintTableEditorPeer;
import net.astah.table.Element;
import net.astah.table.TablePackage;
import net.astah.table.Tuple;
import net.astah.ui.menu.annotation.CanExecute;
import net.astah.ui.menu.annotation.Execute;
import net.astah.ui.menu.annotation.Handler;
import net.astah.ui.menu.annotation.MenuCommand;
import net.astah.ui.menu.annotation.MenuItem;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

@Handler
@MenuItem(commands={@MenuCommand(id="stpa.SelectHazardCommand", category="edit.table")}, label="%StampTable_selectHazard_label", tooltip="%StampTable_selectHazard_tooltip", type=MenuItem.ItemKind.PUSH)
public class SelectHazardHandler {
    private final int HAZARD_ID_COLUMN = 2;
    private final int HAZARD_COLUMN = 3;
    private Command command = UnexecutableCommand.INSTANCE;

    @Execute
    public void execute(ISelection selection, List<String> params, ActionEvent e) {
        if (selection instanceof ITableSelection) {
            ITableSelection tableSelection = (ITableSelection)selection;
            IListSelection rowSelection = tableSelection.getRowSelection();
            this.command = this.selectHazard((Tuple)rowSelection.getFirstElement());
            CommandJob job = new CommandJob(this.getDomain(), this.command);
            job.schedule();
        }
    }

    private TransactionalEditingDomain getDomain() {
        Editor editor = JomtGlobal.viewManager.getCurrentEditor();
        return TransactionUtil.getEditingDomain((Object)editor.getEditModel());
    }

    @CanExecute
    public boolean canExecute(ISelection selection) {
        return selection instanceof ITableSelection && this.isTarget((ITableSelection)selection);
    }

    private boolean isTarget(ITableSelection selection) {
        Object element = selection.getRowSelection().getFirstElement();
        if (element instanceof Tuple) {
            return this.existHazards() && this.isHazard(selection.getColumnSelection());
        }
        return false;
    }

    private boolean existHazards() {
        AccidentHazardSafetyConstraintTableEditorPeer editorPeer = this.getEditorPeer();
        STPAAnalysis scope = editorPeer.getScope();
        return !scope.getHazards().isEmpty();
    }

    private boolean isHazard(IListSelection columnSelection) {
        int[] indices = columnSelection.getIndices();
        if (indices.length > 0) {
            return indices[0] == 2 || indices[0] == 3;
        }
        return false;
    }

    private Command selectHazard(Tuple rowTuple) {
        AccidentHazardSafetyConstraintTableEditorPeer editorPeer = this.getEditorPeer();
        Accident accident = (Accident)((Element)rowTuple.getElements().get(editorPeer.ACCIDENT_INDEX)).getObject();
        JFrame parent = (JFrame)((SwingFrame)JomtGlobal.viewManager.getManagementView().getComponent()).getComponent();
        ArrayList<IdentifiedElement> list = new ArrayList<IdentifiedElement>((Collection<IdentifiedElement>)editorPeer.getScope().getHazards());
        SelectElementDialog dialog = new SelectElementDialog(parent, list, (IdentifiedElement)((Element)rowTuple.getElements().get(editorPeer.HAZARD_INDEX)).getObject());
        dialog.setTitle(accident.getId() + " " + Messages.accident_hazard_safety_constraint_table_select_hazard_label);
        dialog.pack();
        dialog.setVisible(true);
        if (dialog.getResultState() == 1) {
            return this.createSetHazardCommand(rowTuple, (Hazard)dialog.getSelectedElement(), editorPeer);
        }
        return this.command;
    }

    private Command createSetHazardCommand(Tuple rowTuple, Hazard hazard, AccidentHazardSafetyConstraintTableEditorPeer editorPeer) {
        STPAAnalysis scope = editorPeer.getScope();
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)scope);
        EList elements = rowTuple.getElements();
        EObject accident = ((Element)elements.get(editorPeer.ACCIDENT_INDEX)).getObject();
        Hazard oldHazard = (Hazard)((Element)elements.get(editorPeer.HAZARD_INDEX)).getObject();
        if (oldHazard == hazard) {
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand command = new CompoundCommand();
        if (oldHazard != null) {
            command.append(DestroyCommand.create((EditingDomain)domain, (Object)new DestroyCommand.Reference(accident, (EStructuralFeature)STAMPPackage.Literals.ACCIDENT__HAZARD, (Object)oldHazard)));
        }
        command.append(AddCommand.create((EditingDomain)domain, (Object)accident, (Object)STAMPPackage.Literals.ACCIDENT__HAZARD, (Object)hazard));
        command.append(SetCommand.create((EditingDomain)this.getDomain(), (Object)elements.get(editorPeer.HAZARD_INDEX), (Object)TablePackage.Literals.ELEMENT__OBJECT, (Object)hazard));
        return command;
    }

    private AccidentHazardSafetyConstraintTableEditorPeer getEditorPeer() {
        Editor editor = JomtGlobal.viewManager.getCurrentEditor();
        EditorPeer editorPeer = editor.getEditorPeer();
        return (AccidentHazardSafetyConstraintTableEditorPeer)editorPeer;
    }
}

