/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.menu.handler;

import java.awt.event.ActionEvent;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.emf.edit.job.CommandJob;
import net.astah.golf.widget.IListSelection;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.ITableSelection;
import net.astah.golf.widget.swing.SwingFrame;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jview.Editor;
import net.astah.jomt.jview.EditorPeer;
import net.astah.stpa.stamp.Countermeasure;
import net.astah.stpa.stamp.HazardCausalFactor;
import net.astah.stpa.stamp.IdentifiedElement;
import net.astah.stpa.stamp.STAMPPackage;
import net.astah.stpa.stamp.STPAAnalysis;
import net.astah.stpa.stamp.ui.Messages;
import net.astah.stpa.stamp.ui.view.SelectElementDialog;
import net.astah.stpa.stamp.ui.view.swing.CountermeasureTableEditorPeer;
import net.astah.table.Element;
import net.astah.table.Tuple;
import net.astah.ui.menu.annotation.CanExecute;
import net.astah.ui.menu.annotation.Execute;
import net.astah.ui.menu.annotation.Handler;
import net.astah.ui.menu.annotation.MenuCommand;
import net.astah.ui.menu.annotation.MenuItem;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

@Handler
@MenuItem(commands={@MenuCommand(id="stpa.SelectCountermeasureCommand", category="edit.table")}, label="%StampTable_selectCountermeasure_label", tooltip="%StampTable_selectCountermeasure_tooltip", type=MenuItem.ItemKind.PUSH)
public class SelectCountermeasureHandler {
    private int COUNTERMEASURE_ID_COLUMN = 2;
    private int COUNTERMEASURE_COLUMN = 3;
    private Command command = UnexecutableCommand.INSTANCE;

    @Execute
    public void execute(ISelection selection, List<String> params, ActionEvent e) {
        if (selection instanceof ITableSelection) {
            ITableSelection tableSelection = (ITableSelection)selection;
            this.command = this.selectCountermeasure((Tuple)tableSelection.getFirstElement());
            CommandJob job = new CommandJob(this.getDomain(), this.command);
            job.schedule();
        }
    }

    private TransactionalEditingDomain getDomain() {
        Editor editor = JomtGlobal.viewManager.getCurrentEditor();
        return TransactionUtil.getEditingDomain((Object)editor.getEditModel());
    }

    @CanExecute
    public boolean canExecute(ISelection selection) {
        return selection instanceof ITableSelection && this.isTarget((ITableSelection)selection);
    }

    private boolean isTarget(ITableSelection selection) {
        Object element = selection.getFirstElement();
        if (element instanceof Tuple) {
            return this.existCountermeasures((Tuple)element) && this.isCountermeasure(selection.getColumnSelection());
        }
        return false;
    }

    private boolean existCountermeasures(Tuple rowTuple) {
        CountermeasureTableEditorPeer editorPeer = this.getEditorPeer();
        STPAAnalysis scope = editorPeer.getScope();
        HazardCausalFactor hcf = (HazardCausalFactor)((Element)rowTuple.getElements().get(0)).getObject();
        Countermeasure countermeasure = (Countermeasure)((Element)rowTuple.getElements().get(1)).getObject();
        return scope.getCountermeasures().stream().anyMatch(m -> m != countermeasure && !m.getHazardCausalFactors().contains((Object)hcf));
    }

    private boolean isCountermeasure(IListSelection columnSelection) {
        int[] indices = columnSelection.getIndices();
        if (indices.length > 0) {
            return indices[0] == this.COUNTERMEASURE_COLUMN || indices[0] == this.COUNTERMEASURE_ID_COLUMN;
        }
        return false;
    }

    private Command selectCountermeasure(Tuple rowTuple) {
        CountermeasureTableEditorPeer editorPeer = this.getEditorPeer();
        HazardCausalFactor hcf = (HazardCausalFactor)((Element)rowTuple.getElements().get(0)).getObject();
        Countermeasure countermeasure = (Countermeasure)((Element)rowTuple.getElements().get(1)).getObject();
        JFrame parent = (JFrame)((SwingFrame)JomtGlobal.viewManager.getManagementView().getComponent()).getComponent();
        List<IdentifiedElement> list = editorPeer.getScope().getCountermeasures().stream().filter(m -> m == countermeasure || !m.getHazardCausalFactors().contains((Object)hcf)).sorted(Comparator.comparing(IdentifiedElement::getId, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
        SelectElementDialog dialog = new SelectElementDialog(parent, list, (IdentifiedElement)countermeasure);
        dialog.setTitle(Messages.countermeasure_table_select_countermeasure_label);
        dialog.pack();
        dialog.setVisible(true);
        if (dialog.getResultState() == 1) {
            return this.createSetCountermeasureCommand(rowTuple, (Countermeasure)dialog.getSelectedElement(), editorPeer);
        }
        return this.command;
    }

    private Command createSetCountermeasureCommand(Tuple rowTuple, Countermeasure countermeasure, CountermeasureTableEditorPeer editorPeer) {
        STPAAnalysis scope = editorPeer.getScope();
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)scope);
        EList elements = rowTuple.getElements();
        Countermeasure oldCountermeasure = (Countermeasure)((Element)elements.get(1)).getObject();
        CompoundCommand command = new CompoundCommand();
        if (oldCountermeasure != null) {
            if (oldCountermeasure != countermeasure) {
                if (oldCountermeasure.getHazardCausalFactors().size() == 1) {
                    command.append(DestroyCommand.create((EditingDomain)domain, (Object)oldCountermeasure));
                } else {
                    command.append(RemoveCommand.create((EditingDomain)domain, (Object)((Element)rowTuple.getElements().get(0)).getObject(), (Object)STAMPPackage.Literals.HAZARD_CAUSAL_FACTOR__COUNTERMEASURE, (Object)oldCountermeasure));
                }
            } else {
                return UnexecutableCommand.INSTANCE;
            }
        }
        command.append(AddCommand.create((EditingDomain)domain, (Object)((Element)rowTuple.getElements().get(0)).getObject(), (Object)STAMPPackage.Literals.HAZARD_CAUSAL_FACTOR__COUNTERMEASURE, (Object)countermeasure));
        return command;
    }

    private CountermeasureTableEditorPeer getEditorPeer() {
        Editor editor = JomtGlobal.viewManager.getCurrentEditor();
        EditorPeer editorPeer = editor.getEditorPeer();
        return (CountermeasureTableEditorPeer)editorPeer;
    }
}

