/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.menu.handler;

import java.awt.event.ActionEvent;
import java.util.List;
import net.astah.emf.edit.job.CommandJob;
import net.astah.golf.widget.IListSelection;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.ITableSelection;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jview.Editor;
import net.astah.jomt.jview.EditorPeer;
import net.astah.stpa.stamp.ui.view.swing.AccidentHazardSafetyConstraintTableEditorPeer;
import net.astah.table.Grid;
import net.astah.table.Tuple;
import net.astah.table.edit.command.DeleteTupleElementCommand;
import net.astah.ui.menu.annotation.CanExecute;
import net.astah.ui.menu.annotation.Execute;
import net.astah.ui.menu.annotation.Handler;
import net.astah.ui.menu.annotation.MenuCommand;
import net.astah.ui.menu.annotation.MenuItem;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

@Handler
@MenuItem(commands={@MenuCommand(id="stpa.DeleteSafetyConstraintCommand", category="edit.table")}, label="%StampTable_deleteSafetyConstraint_label", tooltip="%StampTable_deleteSafetyConstraint_tooltip", type=MenuItem.ItemKind.PUSH)
public class DeleteSafetyConstraintHandler {
    private final int SAFETY_CONSTRAINT_ID_COLUMN = 4;
    private Command command = UnexecutableCommand.INSTANCE;

    @Execute
    public void execute(ISelection selection, List<String> params, ActionEvent e) {
        Editor editor = JomtGlobal.viewManager.getCurrentEditor();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Object)editor.getEditModel());
        CommandJob job = new CommandJob(domain, this.command);
        job.schedule();
    }

    @CanExecute
    public boolean canExecute(ISelection selection) {
        this.command.dispose();
        this.command = UnexecutableCommand.INSTANCE;
        if (selection instanceof ITableSelection) {
            this.command = this.getCommand((ITableSelection)selection);
        }
        return this.command.canExecute();
    }

    private Command getCommand(ITableSelection selection) {
        Object element = selection.getRowSelection().getFirstElement();
        if (element instanceof Tuple && this.isSafetyConstraint(selection.getColumnSelection())) {
            Tuple tuple = (Tuple)element;
            AccidentHazardSafetyConstraintTableEditorPeer editorPeer = this.getEditorPeer();
            return this.createDeleteTupleElementCommand(tuple.getGrid(), tuple.getIndex(), editorPeer.SAFETY_CONSTRAINT_INDEX);
        }
        return this.command;
    }

    private boolean isSafetyConstraint(IListSelection columnSelection) {
        int[] indices = columnSelection.getIndices();
        if (indices.length > 0) {
            return indices[0] >= 4;
        }
        return false;
    }

    private Command createDeleteTupleElementCommand(Grid grid, int rowIndex, int elementIndex) {
        EList rowTuples = grid.getRowTuples();
        if (rowIndex >= 0 && rowIndex < rowTuples.size()) {
            Tuple rowTuple = (Tuple)rowTuples.get(rowIndex);
            return DeleteTupleElementCommand.create((EditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)grid), (Object)grid, (Object)rowTuple, (int)elementIndex);
        }
        return UnexecutableCommand.INSTANCE;
    }

    private AccidentHazardSafetyConstraintTableEditorPeer getEditorPeer() {
        Editor editor = JomtGlobal.viewManager.getCurrentEditor();
        EditorPeer editorPeer = editor.getEditorPeer();
        return (AccidentHazardSafetyConstraintTableEditorPeer)editorPeer;
    }
}

