/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.menu.handler;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.stream.Collectors;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.util.DiagramElements;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.emf.edit.job.CommandJob;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.swing.Selections;
import net.astah.stpa.stamp.Component;
import net.astah.stpa.stamp.ProcessModel;
import net.astah.stpa.stamp.notation.STAMPComponentShape;
import net.astah.ui.menu.annotation.CanExecute;
import net.astah.ui.menu.annotation.Execute;
import net.astah.ui.menu.annotation.Handler;
import net.astah.ui.menu.annotation.MenuCommand;
import net.astah.ui.menu.annotation.MenuItem;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

@Handler(targets={STAMPComponentShape.class})
@MenuItem(label="%StampControlStructureDiagram_deleteProcessModel_label", tooltip="%StampControlStructureDiagram_deleteProcessModel_tooltip", type=MenuItem.ItemKind.PUSH)
@MenuCommand(id="stpa.DeleteProcessModelCommand", category="edit.delete_process_model")
public class DeleteProcessModelHandler {
    private Command command = UnexecutableCommand.INSTANCE;

    @Execute
    public void execute(ISelection selection, List<String> params, ActionEvent e) {
        STAMPComponentShape shape = (STAMPComponentShape)Selections.getFirstElement((ISelection)selection);
        Component component = (Component)DiagramElements.getModelElement((DiagramElement)shape, Component.class);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)component);
        CommandJob job = new CommandJob(domain, this.command);
        job.schedule();
    }

    private Command getCommand(ISelection selection) {
        if (Selections.size((ISelection)selection) != 1) {
            return UnexecutableCommand.INSTANCE;
        }
        STAMPComponentShape shape = (STAMPComponentShape)Selections.getFirstElement((ISelection)selection);
        Component component = (Component)DiagramElements.getModelElement((DiagramElement)shape, Component.class);
        ProcessModel processModel = component.getProcessModel();
        if (processModel == null) {
            return UnexecutableCommand.INSTANCE;
        }
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)component);
        List collection = shape.getCompartments().stream().filter(compartment -> compartment.getModelElements().contains((Object)processModel)).collect(Collectors.toList());
        if (collection.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        collection.add(processModel);
        return DestroyCommand.create((EditingDomain)domain, collection);
    }

    @CanExecute
    public boolean canExecute(ISelection selection) {
        this.command.dispose();
        this.command = this.getCommand(selection);
        return this.command.canExecute();
    }
}

