/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.menu.handler;

import java.awt.event.ActionEvent;
import java.util.List;
import net.astah.emf.edit.job.CommandJob;
import net.astah.golf.widget.IListSelection;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.ITableSelection;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jview.Editor;
import net.astah.table.Grid;
import net.astah.table.Tuple;
import net.astah.table.edit.command.DeleteTupleElementCommand;
import net.astah.ui.menu.annotation.CanExecute;
import net.astah.ui.menu.annotation.Execute;
import net.astah.ui.menu.annotation.Handler;
import net.astah.ui.menu.annotation.MenuCommand;
import net.astah.ui.menu.annotation.MenuItem;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

@Handler
@MenuItem(commands={@MenuCommand(id="stpa.DeleteHazardCausalFactorCommand", category="edit.table")}, label="%StampTable_deleteHazardCausalFactor_label", tooltip="%StampTable_deleteHazardCausalFactor_tooltip", type=MenuItem.ItemKind.PUSH)
public class DeleteHazardCausalFactorHandler {
    private final int HAZARD_CAUSAL_FACTOR__COLUMN = 1;
    private Command command = UnexecutableCommand.INSTANCE;

    @Execute
    public void execute(ISelection selection, List<String> params, ActionEvent e) {
        Editor editor = JomtGlobal.viewManager.getCurrentEditor();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Object)editor.getEditModel());
        CommandJob job = new CommandJob(domain, this.command);
        job.schedule();
    }

    @CanExecute
    public boolean canExecute(ISelection selection) {
        this.command.dispose();
        this.command = UnexecutableCommand.INSTANCE;
        if (selection instanceof ITableSelection) {
            this.command = this.getCommand((ITableSelection)selection);
        }
        return this.command.canExecute();
    }

    private Command getCommand(ITableSelection selection) {
        Object element = selection.getFirstElement();
        if (element instanceof Tuple && this.isHazardCausalFactor(selection.getColumnSelection())) {
            Tuple tuple = (Tuple)element;
            return this.createDeleteTupleElementCommand(tuple.getGrid(), tuple.getIndex(), 0);
        }
        return this.command;
    }

    private boolean isHazardCausalFactor(IListSelection columnSelection) {
        int[] indices = columnSelection.getIndices();
        if (indices.length > 0) {
            return indices[0] <= 1;
        }
        return false;
    }

    private Command createDeleteTupleElementCommand(Grid grid, int rowIndex, int elementIndex) {
        EList rowTuples = grid.getRowTuples();
        if (rowIndex >= 0 && rowIndex < rowTuples.size()) {
            Tuple rowTuple = (Tuple)rowTuples.get(rowIndex);
            return DeleteTupleElementCommand.create((EditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)grid), (Object)grid, (Object)rowTuple, (int)elementIndex);
        }
        return UnexecutableCommand.INSTANCE;
    }
}

