/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.menu.handler;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import net.astah.emf.edit.job.CommandJob;
import net.astah.emf.edit.job.Jobs;
import net.astah.golf.widget.IListSelection;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.ITableSelection;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jview.Editor;
import net.astah.jomt.jview.EditorPeer;
import net.astah.stpa.stamp.Hazard;
import net.astah.stpa.stamp.STAMPFactory;
import net.astah.stpa.stamp.STAMPPackage;
import net.astah.stpa.stamp.STPAAnalysis;
import net.astah.stpa.stamp.SafetyConstraint;
import net.astah.stpa.stamp.ui.view.swing.AccidentHazardSafetyConstraintTableEditorPeer;
import net.astah.table.Element;
import net.astah.table.Grid;
import net.astah.table.TablePackage;
import net.astah.table.Tuple;
import net.astah.table.edit.command.AddRowCommand;
import net.astah.table.ui.TableEditors;
import net.astah.ui.menu.annotation.CanExecute;
import net.astah.ui.menu.annotation.Execute;
import net.astah.ui.menu.annotation.Handler;
import net.astah.ui.menu.annotation.MenuCommand;
import net.astah.ui.menu.annotation.MenuItem;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

@Handler
@MenuItem(commands={@MenuCommand(id="stpa.AddSafetyConstraintCommand", category="edit.table")}, label="%StampTable_addSafetyConstraint_label", tooltip="%StampTable_addSafetyConstraint_tooltip", type=MenuItem.ItemKind.PUSH)
public class AddSafetyConstraintHandler {
    private final int SAFETY_CONSTRAINT_ID_COLUMN = 4;
    private final int SAFETY_CONSTRAINT_COLUMN = 5;
    private Command command = UnexecutableCommand.INSTANCE;
    private int newRow = -1;

    @Execute
    public void execute(ISelection selection, List<String> params, ActionEvent e) {
        CommandJob job = new CommandJob(this.getDomain(), this.command);
        Jobs.toCompletableFuture((Job)job, (boolean)true).thenRun(() -> TableEditors.startCellEditing((int)this.newRow, (int)5));
        job.schedule();
    }

    private TransactionalEditingDomain getDomain() {
        Editor editor = JomtGlobal.viewManager.getCurrentEditor();
        return TransactionUtil.getEditingDomain((Object)editor.getEditModel());
    }

    @CanExecute
    public boolean canExecute(ISelection selection) {
        this.command.dispose();
        this.command = UnexecutableCommand.INSTANCE;
        if (selection instanceof ITableSelection) {
            this.command = this.getCommand((ITableSelection)selection);
        }
        return this.command.canExecute();
    }

    private Command getCommand(ITableSelection selection) {
        Object element = selection.getRowSelection().getFirstElement();
        if (element instanceof Tuple && this.isSafetyConstraint(selection.getColumnSelection())) {
            Tuple tuple = (Tuple)element;
            return this.createAddSafetyConstraintCommand(tuple.getGrid(), tuple.getIndex());
        }
        return this.command;
    }

    private boolean isSafetyConstraint(IListSelection columnSelection) {
        int[] indices = columnSelection.getIndices();
        if (indices.length > 0) {
            return indices[0] >= 4;
        }
        return false;
    }

    public Command createAddSafetyConstraintCommand(Grid grid, int row) {
        EList rowTuples = grid.getRowTuples();
        if (row >= 0 && row < rowTuples.size()) {
            Tuple rowTuple = (Tuple)rowTuples.get(row);
            return this.createAddSafetyConstraintCommand(grid, row, rowTuple);
        }
        return this.command;
    }

    private Command createAddSafetyConstraintCommand(Grid grid, int row, Tuple rowTuple) {
        AccidentHazardSafetyConstraintTableEditorPeer editorPeer = this.getEditorPeer();
        STPAAnalysis scope = editorPeer.getScope();
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)scope);
        SafetyConstraint safetyConstraint = STAMPFactory.eINSTANCE.createSafetyConstraint();
        EList elements = rowTuple.getElements();
        EObject accident = ((Element)elements.get(editorPeer.ACCIDENT_INDEX)).getObject();
        Hazard hazard = (Hazard)((Element)elements.get(editorPeer.HAZARD_INDEX)).getObject();
        Command command = CreateChildCommand.create((EditingDomain)domain, (Object)scope, (Object)new CommandParameter((Object)scope, (Object)STAMPPackage.Literals.STPA_ANALYSIS__SAFETY_CONSTRAINT, (Object)safetyConstraint), Collections.singleton(scope)).chain(AddCommand.create((EditingDomain)domain, (Object)hazard, (Object)STAMPPackage.Literals.HAZARD__SAFETY_CONSTRAINT, (Object)safetyConstraint));
        Element element = (Element)elements.get(editorPeer.SAFETY_CONSTRAINT_INDEX);
        if (element.getObject() == null) {
            this.newRow = row;
            return command.chain(SetCommand.create((EditingDomain)this.getDomain(), (Object)element, (Object)TablePackage.Literals.ELEMENT__OBJECT, (Object)safetyConstraint));
        }
        this.newRow = row + 1;
        EList safetyConstraints = hazard.getSafetyConstraints();
        int index = safetyConstraints.indexOf((Object)element.getObject());
        this.newRow = row - index + safetyConstraints.size();
        Tuple newRowTuple = AddRowCommand.prepareNewTuple((Grid)grid, (int)row);
        EList newElements = newRowTuple.getElements();
        ((Element)newElements.get(editorPeer.ACCIDENT_INDEX)).setObject(accident);
        ((Element)newElements.get(editorPeer.HAZARD_INDEX)).setObject((EObject)hazard);
        ((Element)newElements.get(editorPeer.SAFETY_CONSTRAINT_INDEX)).setObject((EObject)safetyConstraint);
        return AddCommand.create((EditingDomain)this.getDomain(), (Object)grid, (Object)TablePackage.Literals.GRID__ROW_TUPLE, (Object)newRowTuple, (int)(row + 1)).chain(command);
    }

    private AccidentHazardSafetyConstraintTableEditorPeer getEditorPeer() {
        Editor editor = JomtGlobal.viewManager.getCurrentEditor();
        EditorPeer editorPeer = editor.getEditorPeer();
        return (AccidentHazardSafetyConstraintTableEditorPeer)editorPeer;
    }
}

