/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.menu.handler;

import java.awt.event.ActionEvent;
import java.util.List;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.util.DiagramElements;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.swing.Selections;
import net.astah.stpa.stamp.Component;
import net.astah.stpa.stamp.ProcessModel;
import net.astah.stpa.stamp.notation.STAMPCompartment;
import net.astah.stpa.stamp.notation.STAMPComponentShape;
import net.astah.stpa.stamp.ui.control.AddProcessVariableCommand;
import net.astah.ui.menu.annotation.CanExecute;
import net.astah.ui.menu.annotation.Execute;
import net.astah.ui.menu.annotation.Handler;
import net.astah.ui.menu.annotation.MenuCommand;
import net.astah.ui.menu.annotation.MenuItem;

@Handler(targets={STAMPComponentShape.class})
@MenuItem(label="%StampControlStructureDiagram_addProcessVariable_label", tooltip="%StampControlStructureDiagram_addProcessVariable_tooltip", type=MenuItem.ItemKind.PUSH)
@MenuCommand(id="stpa.AddProcessVariableCommand", category="edit.add_process_model")
public class AddProcessVariableHandler {
    @Execute
    public void execute(ISelection selection, List<String> params, ActionEvent e) {
        STAMPComponentShape shape = (STAMPComponentShape)Selections.getFirstElement((ISelection)selection);
        AddProcessVariableCommand command = new AddProcessVariableCommand();
        DiagramElement compartment = shape.getOwnedElements().stream().filter(d -> d instanceof STAMPCompartment).findFirst().orElse(null);
        if (compartment == null) {
            return;
        }
        command.setOwnerDiagramElement(compartment);
        command.execute();
    }

    @CanExecute
    public boolean canExecute(ISelection selection) {
        if (Selections.size((ISelection)selection) != 1) {
            return false;
        }
        STAMPComponentShape shape = (STAMPComponentShape)Selections.getFirstElement((ISelection)selection);
        Component component = (Component)DiagramElements.getModelElement((DiagramElement)shape, Component.class);
        ProcessModel processModel = component.getProcessModel();
        return processModel != null && shape.getCompartments().stream().anyMatch(compartment -> compartment.getModelElements().contains((Object)processModel));
    }
}

