/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.menu.handler;

import java.awt.event.ActionEvent;
import java.util.List;
import net.astah.emf.edit.job.CommandJob;
import net.astah.emf.edit.job.Jobs;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.ITableSelection;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jview.Editor;
import net.astah.jomt.jview.EditorPeer;
import net.astah.stpa.stamp.ui.view.swing.PreconditionTableEditorPeer;
import net.astah.table.Grid;
import net.astah.table.Tuple;
import net.astah.table.edit.command.AddRowCommand;
import net.astah.table.ui.TableEditors;
import net.astah.ui.menu.annotation.CanExecute;
import net.astah.ui.menu.annotation.Execute;
import net.astah.ui.menu.annotation.Handler;
import net.astah.ui.menu.annotation.MenuCommand;
import net.astah.ui.menu.annotation.MenuItem;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

@Handler
@MenuItem(commands={@MenuCommand(id="stpa.AddPreconditionCommand", category="edit.table")}, label="%StampTable_addPrecondition_label", tooltip="%StampTable_addPrecondition_tooltip", type=MenuItem.ItemKind.PUSH)
public class AddPreconditionHandler {
    private Command command = UnexecutableCommand.INSTANCE;
    private static final int NAME_COLUMN = 1;

    @Execute
    public void execute(ISelection selection, List<String> params, ActionEvent e) {
        Editor editor = JomtGlobal.viewManager.getCurrentEditor();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Object)editor.getEditModel());
        CommandJob job = new CommandJob(domain, this.command);
        Jobs.toCompletableFuture((Job)job, (boolean)true).thenRun(() -> TableEditors.startCellEditing((int)-1, (int)1));
        job.schedule();
    }

    @CanExecute
    public boolean canExecute(ISelection selection) {
        this.command.dispose();
        this.command = UnexecutableCommand.INSTANCE;
        if (selection instanceof ITableSelection) {
            this.command = this.getCommand((ITableSelection)selection);
        }
        return this.command.canExecute();
    }

    private Command getCommand(ITableSelection selection) {
        if (selection.isEmpty()) {
            Grid grid = this.getGrid();
            if (grid != null) {
                return this.createCommand(grid);
            }
        } else {
            Object element = selection.getRowSelection().getFirstElement();
            if (element instanceof Tuple) {
                return this.createCommand((Tuple)element);
            }
        }
        return this.command;
    }

    private Command createCommand(Tuple tuple) {
        Grid grid = tuple.getGrid();
        int index = tuple.getIndex();
        Tuple rowTuple = AddRowCommand.prepareNewTuple((Grid)grid, (int)index);
        return AddRowCommand.create((EditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)tuple), (Object)grid, (Object)rowTuple, (int)index);
    }

    private Command createCommand(Grid grid) {
        Tuple rowTuple = AddRowCommand.prepareNewTuple((Grid)grid, (int)-1);
        return AddRowCommand.create((EditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)grid), (Object)grid, (Object)rowTuple, (int)0);
    }

    private Grid getGrid() {
        Editor editor = JomtGlobal.viewManager.getCurrentEditor();
        EditorPeer editorPeer = editor.getEditorPeer();
        return ((PreconditionTableEditorPeer)editorPeer).getGrid();
    }
}

