/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.menu.handler;

import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import net.astah.emf.edit.job.CommandJob;
import net.astah.emf.edit.job.Jobs;
import net.astah.golf.widget.IListSelection;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.ITableSelection;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jview.Editor;
import net.astah.jomt.jview.EditorPeer;
import net.astah.stpa.stamp.Countermeasure;
import net.astah.stpa.stamp.HazardCausalFactor;
import net.astah.stpa.stamp.STAMPFactory;
import net.astah.stpa.stamp.STAMPPackage;
import net.astah.stpa.stamp.STPAAnalysis;
import net.astah.stpa.stamp.ui.view.swing.CountermeasureTableEditorPeer;
import net.astah.table.Element;
import net.astah.table.Grid;
import net.astah.table.TablePackage;
import net.astah.table.Tuple;
import net.astah.table.edit.command.AddRowCommand;
import net.astah.table.ui.TableEditors;
import net.astah.ui.menu.annotation.CanExecute;
import net.astah.ui.menu.annotation.Execute;
import net.astah.ui.menu.annotation.Handler;
import net.astah.ui.menu.annotation.MenuCommand;
import net.astah.ui.menu.annotation.MenuItem;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

@Handler
@MenuItem(commands={@MenuCommand(id="stpa.AddCountermeasureCommand", category="edit.table")}, label="%StampTable_addCountermeasure_label", tooltip="%StampTable_addCountermeasure_tooltip", type=MenuItem.ItemKind.PUSH)
public class AddCountermeasureHandler {
    private Command command = UnexecutableCommand.INSTANCE;
    private int affectedRow = -1;

    @Execute
    public void execute(ISelection selection, List<String> params, ActionEvent e) {
        CommandJob job = new CommandJob(this.getDomain(), this.command);
        Jobs.toCompletableFuture((Job)job, (boolean)true).thenRun(() -> TableEditors.startCellEditing((int)this.affectedRow, (int)3));
        job.schedule();
    }

    private TransactionalEditingDomain getDomain() {
        Editor editor = JomtGlobal.viewManager.getCurrentEditor();
        return TransactionUtil.getEditingDomain((Object)editor.getEditModel());
    }

    @CanExecute
    public boolean canExecute(ISelection selection) {
        this.command.dispose();
        this.command = UnexecutableCommand.INSTANCE;
        if (selection instanceof ITableSelection) {
            this.command = this.getCommand((ITableSelection)selection);
        }
        return this.command.canExecute();
    }

    private Command getCommand(ITableSelection selection) {
        Object element = selection.getFirstElement();
        if (element instanceof Tuple && this.isCountermeasure(selection.getColumnSelection())) {
            return this.createCommand((Tuple)element);
        }
        return this.command;
    }

    private boolean isCountermeasure(IListSelection columnSelection) {
        int[] indices = columnSelection.getIndices();
        if (indices.length > 0) {
            return indices[0] == 2 || indices[0] == 3;
        }
        return false;
    }

    public Command createCommand(Tuple tuple) {
        int row = tuple.getIndex();
        Grid grid = tuple.getGrid();
        EList rowTuples = grid.getRowTuples();
        if (row >= 0 && row < rowTuples.size()) {
            Tuple rowTuple = (Tuple)rowTuples.get(row);
            return this.createAddCountermeasureCommand(grid, row, rowTuple);
        }
        return this.command;
    }

    protected Command createAddCountermeasureCommand(Grid grid, int row, Tuple rowTuple) {
        STPAAnalysis scope = this.getEditorPeer().getScope();
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)scope);
        Countermeasure newValue = STAMPFactory.eINSTANCE.createCountermeasure();
        EList elements = rowTuple.getElements();
        Element valueElement = (Element)elements.get(1);
        Countermeasure value = (Countermeasure)valueElement.getObject();
        Element hcfElement = (Element)elements.get(0);
        HazardCausalFactor hcf = (HazardCausalFactor)hcfElement.getObject();
        int index = hcf.getCountermeasures().indexOf((Object)value);
        this.affectedRow = row + (index < 0 ? 0 : 1);
        CompoundCommand command = new CompoundCommand();
        command.append(CreateChildCommand.create((EditingDomain)domain, (Object)scope, (Object)new CommandParameter((Object)scope, (Object)STAMPPackage.Literals.STPA_ANALYSIS__COUNTERMEASURE, (Object)newValue), Collections.singleton(scope)));
        command.append(AddCommand.create((EditingDomain)domain, (Object)hcf, (Object)STAMPPackage.Literals.HAZARD_CAUSAL_FACTOR__COUNTERMEASURE, (Object)newValue, (int)(index + 1)));
        if (value == null) {
            command.append(SetCommand.create((EditingDomain)this.getDomain(), (Object)valueElement, (Object)TablePackage.Literals.ELEMENT__OBJECT, (Object)newValue));
        } else {
            Tuple newRowTuple = AddRowCommand.prepareNewTuple((Grid)grid, (int)row);
            EList newElements = newRowTuple.getElements();
            ((Element)newElements.get(0)).setObject((EObject)hcf);
            ((Element)newElements.get(1)).setObject((EObject)newValue);
            command.append(AddCommand.create((EditingDomain)this.getDomain(), (Object)grid, (Object)TablePackage.Literals.GRID__ROW_TUPLE, (Object)newRowTuple, (int)this.affectedRow));
        }
        return command;
    }

    private CountermeasureTableEditorPeer getEditorPeer() {
        Editor editor = JomtGlobal.viewManager.getCurrentEditor();
        EditorPeer editorPeer = editor.getEditorPeer();
        return (CountermeasureTableEditorPeer)editorPeer;
    }
}

