/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.control.mode;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.List;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.Shape;
import net.astah.dd.di.edit.command.DiagramContext;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.dd.di.util.DiagramElements;
import net.astah.golf.control.Command;
import net.astah.golf.control.CommandEvent;
import net.astah.golf.draw.GNode;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.view.swing.InputEventSupport;
import net.astah.golf.widget.CCanvas;
import net.astah.jomt.jcontrol.mode.DiagramMode;
import net.astah.jomt.jcontrol.mode.DrawingRubberSupport;
import net.astah.notation.editor.IViewElement;
import net.astah.notation.editor.ViewElements;
import net.astah.stpa.stamp.STAMPFactory;
import net.astah.stpa.stamp.notation.STAMPComponentShape;
import net.astah.stpa.stamp.notation.STAMPNotationFactory;
import net.astah.stpa.stamp.notation.STAMPShape;
import net.astah.ui.control.CreateShapeCommand;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;

public class CreateComponentMode
extends DiagramMode {
    protected STAMPComponentShape owingElement = null;
    protected GNode containerRect = new GNode();

    public void mouseClicked(MouseEvent e) {
        e.consume();
    }

    protected STAMPShape createShape() {
        return STAMPNotationFactory.eINSTANCE.createSTAMPComponentShape();
    }

    protected EModelElement createModelElement() {
        return STAMPFactory.eINSTANCE.createComponent();
    }

    protected STAMPShape prepareShape() {
        STAMPShape shape = this.createShape();
        DiagramElements.setModelElement((DiagramElement)shape, (EObject)this.createModelElement());
        return shape;
    }

    protected CreateShapeCommand createCommand() {
        return new CreateShapeCommand();
    }

    public void mouseReleased(MouseEvent e) {
        if (!InputEventSupport.isLeftMouseButton((MouseEvent)e)) {
            return;
        }
        double x = this.camera.toWorldCoordX(e.getX());
        double y = this.camera.toWorldCoordY(e.getY());
        Pnt2d p = new Pnt2d(x, y);
        CreateShapeCommand command = this.createCommand();
        command.setShape((Shape)this.prepareShape());
        command.setLocation(Geometries.toPoint((Point2D)p));
        command.setContext((Object)new DiagramContext(this.getDiagram(), null, p, (DiagramElement)this.owingElement));
        Diagram owner = this.owingElement == null ? this.getDiagram() : this.owingElement;
        command.setOwningElement((DiagramElement)owner);
        command.setShiftPressedState(e.isShiftDown());
        this.fireCommandPerformed(new CommandEvent(e.getSource(), e.getID(), "CreateComponent", (Command)command, e.getModifiers()));
        this.clear();
        e.consume();
    }

    public void mousePressed(MouseEvent e) {
        if (InputEventSupport.isRightMouseButton((MouseEvent)e)) {
            return;
        }
        e.consume();
    }

    public void mouseDragged(MouseEvent e) {
        if (InputEventSupport.isRightMouseButton((MouseEvent)e)) {
            return;
        }
        this.mouseMoved(e);
    }

    public void mouseMoved(MouseEvent e) {
        DrawingRubberSupport.clearOldRubber((CCanvas)this.canvas);
        this.scene.removeTempNode(this.containerRect);
        this.containerRect.removeAllChildren();
        IViewElement owningViewElement = this.getOwningViewElement(this.getMouseLocation(e));
        if (owningViewElement != null && owningViewElement.getModel() instanceof STAMPComponentShape) {
            this.containerRect.addChild(owningViewElement.createFeedbackShape());
            this.owingElement = (STAMPComponentShape)owningViewElement.getModel();
            this.canvas.repaintSync();
            this.canvas.drawTempFront();
        } else {
            this.owingElement = null;
        }
        if (!this.containerRect.getChildren().isEmpty()) {
            this.scene.addTempNode(this.containerRect);
        }
        DrawingRubberSupport.drawNewRubber((CCanvas)this.canvas);
        e.consume();
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.clear();
        }
    }

    private void clear() {
        this.scene.removeTempNode(this.containerRect);
        this.canvas.clear();
        this.canvas.draw();
        this.canvas.repaint();
        this.containerRect.removeAllChildren();
    }

    private IViewElement getOwningViewElement(Pnt2d mouseLocation) {
        List pickedNodes = (List)this.ignoreRimmedPick(() -> this.getPickedNodes(mouseLocation, 1, false));
        pickedNodes.removeIf(node -> !(node.getModel() instanceof STAMPComponentShape));
        if (!pickedNodes.isEmpty()) {
            GNode minDepthNode = CreateComponentMode.getMinDepthNode((List)pickedNodes);
            return (IViewElement)ViewElements.getAncestor((GNode)minDepthNode, IViewElement.class);
        }
        return null;
    }
}

