/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.control.mode;

import com.google.common.collect.Lists;
import java.awt.dnd.DropTargetDropEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.di.DIPackage;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.Edge;
import net.astah.dd.di.Shape;
import net.astah.dd.di.util.DiagramElements;
import net.astah.emf.edit.job.CommandJob;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.widget.ISelection;
import net.astah.golf.widget.swing.Selections;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.ProjectView;
import net.astah.notation.Location;
import net.astah.notation.LocationConstraint;
import net.astah.notation.NotationFactory;
import net.astah.stpa.stamp.Component;
import net.astah.stpa.stamp.ControlStructure;
import net.astah.stpa.stamp.Link;
import net.astah.stpa.stamp.LinkEnd;
import net.astah.stpa.stamp.LinkableElement;
import net.astah.stpa.stamp.STPAAnalysis;
import net.astah.stpa.stamp.notation.STAMPComponentShape;
import net.astah.stpa.stamp.notation.STAMPControlLoopDiagram;
import net.astah.stpa.stamp.notation.STAMPControlStructureDiagram;
import net.astah.stpa.stamp.notation.STAMPEdge;
import net.astah.stpa.stamp.notation.STAMPNotationFactory;
import net.astah.stpa.stamp.notation.STAMPShape;
import net.astah.stpa.stamp.notation.util.STAMPDiagramElements;
import net.astah.stpa.stamp.ui.control.ControlStructureDiagramLayoutCommand;
import net.astah.ui.control.CreateEdgeCommand;
import net.astah.ui.control.CreateShapeCommand;
import net.astah.ui.control.mode.DiagramDnDMode;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class ControlStructureDiagramDnDMode
extends DiagramDnDMode {
    protected void dropExecute(DropTargetDropEvent dtde) {
        IJomtEntityStore doc = ModelGlobal.prjManager.getCurrentProject().doc;
        if (doc == null) {
            return;
        }
        TransactionalEditingDomain domain = (TransactionalEditingDomain)doc.getDomain();
        boolean isInTransaction = doc.isInTransaction();
        if (isInTransaction) {
            return;
        }
        Pnt2d p = this.getLocation(dtde);
        Location location = NotationFactory.eINSTANCE.createLocation(p.getX(), p.getY());
        ProjectView pv = JomtGlobal.viewManager.getProjectView();
        Diagram diagram = this.getDiagram();
        ControlStructure controlStructure = this.getControlStructure(diagram);
        if (controlStructure == null) {
            return;
        }
        CompoundCommand command = new CompoundCommand();
        ArrayList<DiagramElement> layoutTargets = new ArrayList<DiagramElement>();
        ArrayList components = Lists.newArrayList((Iterable)Selections.iterable((ISelection)pv.getSelection(), Component.class));
        EList links = controlStructure.getLinks();
        for (Component component : components) {
            this.createComponentShapeCommand(component, diagram, layoutTargets, command);
            this.createLinkEnds(domain, (EList<Link>)links, component, diagram, layoutTargets, command);
        }
        this.createEdges(domain, (EList<Link>)links, layoutTargets, diagram, command);
        this.createLayoutCommand(domain, layoutTargets, location, diagram, command);
        if (!command.canExecute()) {
            return;
        }
        CommandJob job = new CommandJob(domain, (Command)command);
        job.schedule();
    }

    private ControlStructure getControlStructure(Diagram diagram) {
        STPAAnalysis analysis;
        if (diagram instanceof STAMPControlStructureDiagram) {
            return (ControlStructure)DiagramElements.getModelElement((DiagramElement)diagram, ControlStructure.class);
        }
        if (diagram instanceof STAMPControlLoopDiagram && !(analysis = ((STAMPControlLoopDiagram)diagram).getControlLoop().getHintWordSet().getOwner()).getControlStructures().isEmpty()) {
            return (ControlStructure)analysis.getControlStructures().get(0);
        }
        return null;
    }

    private void createComponentShapeCommand(Component component, Diagram diagram, List<DiagramElement> layoutTargets, CompoundCommand command) {
        Shape parent = STAMPDiagramElements.getDiagramElements((EObject)component.eContainer(), (DiagramElement)diagram, STAMPShape.class).stream().map(m -> m).findFirst().orElse((Shape)diagram);
        STAMPComponentShape shape = STAMPNotationFactory.eINSTANCE.createSTAMPComponentShape();
        DiagramElements.setModelElement((DiagramElement)shape, (EObject)component);
        shape.getModelElements().add((Object)component);
        shape.setLocation((LocationConstraint)NotationFactory.eINSTANCE.createLocation(0.0, 0.0));
        layoutTargets.add((DiagramElement)shape);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)parent);
        command.append(CreateChildCommand.create((EditingDomain)domain, (Object)parent, (Object)new CommandParameter((Object)parent, (Object)DIPackage.Literals.DIAGRAM_ELEMENT__OWNED_ELEMENT, (Object)shape, 0), Collections.singleton(parent)));
    }

    private void createLinkEnds(TransactionalEditingDomain domain, EList<Link> links, Component component, Diagram diagram, List<DiagramElement> layoutTargets, CompoundCommand command) {
        List inputLinks = links.stream().filter(link -> link.getTarget() == component && link.getSource() instanceof LinkEnd).collect(Collectors.toList());
        for (Link inputLink : inputLinks) {
            LinkEnd linkEnd = (LinkEnd)inputLink.getSource();
            if (this.isExistLinkEnd(diagram, layoutTargets, linkEnd)) continue;
            STAMPShape shape = STAMPNotationFactory.eINSTANCE.createSTAMPShape();
            shape.getModelElements().add((Object)linkEnd);
            CreateShapeCommand cmd = this.createCreateShapeCommand((DiagramElement)diagram, shape);
            command.append(cmd.createTransactionalCommand(domain));
            layoutTargets.add((DiagramElement)shape);
        }
        List outputLinks = links.stream().filter(link -> link.getSource() == component && link.getTarget() instanceof LinkEnd).collect(Collectors.toList());
        for (Link inputLink : outputLinks) {
            LinkEnd linkEnd = (LinkEnd)inputLink.getTarget();
            if (this.isExistLinkEnd(diagram, layoutTargets, linkEnd)) continue;
            STAMPShape shape = STAMPNotationFactory.eINSTANCE.createSTAMPShape();
            shape.getModelElements().add((Object)linkEnd);
            CreateShapeCommand cmd = this.createCreateShapeCommand((DiagramElement)diagram, shape);
            command.append(cmd.createTransactionalCommand(domain));
            layoutTargets.add((DiagramElement)shape);
        }
    }

    private boolean isExistLinkEnd(Diagram diagram, List<DiagramElement> layoutTargets, LinkEnd linkEnd) {
        boolean isExistInTargets = layoutTargets.stream().anyMatch(target -> DiagramElements.getModelElement((DiagramElement)target) == linkEnd);
        boolean isExistInDiagram = diagram.getOwnedElements().stream().anyMatch(element -> DiagramElements.getModelElement((DiagramElement)element) == linkEnd);
        return isExistInTargets || isExistInDiagram;
    }

    private CreateShapeCommand createCreateShapeCommand(DiagramElement parent, STAMPShape shape) {
        CreateShapeCommand cmd = new CreateShapeCommand();
        cmd.setOwningElement(parent);
        cmd.setShape((Shape)shape);
        cmd.setLocation(DCFactory.eINSTANCE.createPoint(0.0, 0.0));
        return cmd;
    }

    private void createLayoutCommand(TransactionalEditingDomain domain, List<DiagramElement> layoutTargets, Location location, Diagram diagram, CompoundCommand command) {
        command.append((Command)new ControlStructureDiagramLayoutCommand((EditingDomain)domain, diagram, layoutTargets, location));
    }

    private void createEdges(TransactionalEditingDomain domain, EList<Link> links, List<DiagramElement> layoutTargets, Diagram diagram, CompoundCommand command) {
        for (Link link : links) {
            Optional linkEdge;
            STAMPShape sourceShape = this.getRelationShape(link.getSource(), layoutTargets, diagram);
            STAMPShape targetShape = this.getRelationShape(link.getTarget(), layoutTargets, diagram);
            if (targetShape == null || sourceShape == null || !(linkEdge = STAMPDiagramElements.getDiagramElements((EObject)link, (DiagramElement)diagram, STAMPEdge.class).stream().findFirst()).equals(Optional.empty())) continue;
            CreateEdgeCommand createEdgeCommand = new CreateEdgeCommand();
            STAMPEdge edge = STAMPNotationFactory.eINSTANCE.createSTAMPEdge();
            edge.getModelElements().add((Object)link);
            createEdgeCommand.setEdge((Edge)edge);
            createEdgeCommand.setSource((DiagramElement)sourceShape);
            createEdgeCommand.setTarget((DiagramElement)targetShape);
            createEdgeCommand.setOwningElement((DiagramElement)diagram);
            createEdgeCommand.setLine((Object)NotationFactory.eINSTANCE.createRightAngleLine());
            command.append(createEdgeCommand.createTransactionalCommand(domain));
            layoutTargets.add((DiagramElement)edge);
        }
    }

    private STAMPShape getRelationShape(LinkableElement linkableElement, List<DiagramElement> layoutTargets, Diagram diagram) {
        DiagramElement element;
        Optional<DiagramElement> optionalElement = layoutTargets.stream().filter(layoutTarget -> DiagramElements.getModelElement((DiagramElement)layoutTarget) == linkableElement).findFirst();
        if (optionalElement.isPresent() && (element = optionalElement.get()) instanceof STAMPShape) {
            return (STAMPShape)element;
        }
        return STAMPDiagramElements.getDiagramElements((EObject)linkableElement, (DiagramElement)diagram, STAMPShape.class).stream().findFirst().orElse(null);
    }
}

