/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.control;

import java.beans.PropertyVetoException;
import net.astah.golf.control.Command;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.project.Facets;
import net.astah.project.Project;
import net.astah.project.ProjectManagerAdapter;
import net.astah.stpa.stamp.ControlLoop;
import net.astah.stpa.stamp.HCFHintWordSet;
import net.astah.stpa.stamp.STAMPPlugin;
import net.astah.stpa.stamp.STPAAnalysis;
import net.astah.stpa.stamp.ui.Messages;
import net.astah.stpa.stamp.ui.view.HCFHintWordSetFrame;
import net.astah.stpa.stamp.util.HCFHintWordSets;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenHintWordImageCommand
extends Command {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenHintWordImageCommand.class);

    public void execute() {
        ControlLoop controlLoop = HCFHintWordSetFrame.getCurrentControlLoop();
        if (controlLoop == null) {
            return;
        }
        HCFHintWordSetFrame palette = (HCFHintWordSetFrame)DiagramEditor.getPaletteframe();
        if (palette != null) {
            palette.updateComboBox(controlLoop);
            palette.setVisible(!palette.isVisible());
        } else {
            this.createHintWordSetForm(controlLoop);
        }
    }

    private void createHintWordSetForm(ControlLoop controlLoop) {
        HCFHintWordSetFrame palette = this.createHintWordSetFrame(controlLoop);
        if (palette == null) {
            return;
        }
        EList<HCFHintWordSet> hintWordSets = this.getHintWordSets(controlLoop);
        palette.createHintWordSetFrame(hintWordSets, controlLoop);
    }

    private EList<HCFHintWordSet> getHintWordSets(ControlLoop controlLoop) {
        Project project = ProjectManagerAdapter.getRootProject((Notifier)controlLoop);
        STPAAnalysis analysis = (STPAAnalysis)Facets.getFirstContent((Project)project, (String)STAMPPlugin.FACET_SYMBOLIC_NAME, STPAAnalysis.class, null);
        return HCFHintWordSets.getLanguageHintWordSets((STPAAnalysis)analysis, (ResourceSet)controlLoop.eResource().getResourceSet());
    }

    private HCFHintWordSetFrame createHintWordSetFrame(ControlLoop controlLoop) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)controlLoop);
        try {
            HCFHintWordSetFrame palette = new HCFHintWordSetFrame((EditingDomain)domain, Messages.hcf_hintword_set_frame_header, true, true, false, true);
            palette.initializeFrame();
            return palette;
        }
        catch (PropertyVetoException e) {
            LOGGER.error("error has occurred.", (Throwable)e);
            return null;
        }
    }
}

