/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.control;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.Edge;
import net.astah.dd.di.Shape;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.dd.di.util.DiagramElements;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.notation.NotationFactory;
import net.astah.stpa.stamp.Component;
import net.astah.stpa.stamp.ControlStructure;
import net.astah.stpa.stamp.Link;
import net.astah.stpa.stamp.LinkEnd;
import net.astah.stpa.stamp.LinkableElement;
import net.astah.stpa.stamp.notation.STAMPComponentShape;
import net.astah.stpa.stamp.notation.STAMPEdge;
import net.astah.stpa.stamp.notation.STAMPNotationFactory;
import net.astah.stpa.stamp.notation.STAMPShape;
import net.astah.stpa.stamp.notation.util.STAMPDiagramElements;
import net.astah.stpa.stamp.ui.control.ControlStructureDiagramLayoutCommand;
import net.astah.ui.control.CreateEdgeCommand;
import net.astah.ui.control.CreateShapeCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class ModifyControlStructureDiagramElementsCommand
extends CompoundCommand {
    TransactionalEditingDomain domain;
    Diagram diagram;
    List<LinkableElement> elements;
    List<Link> links;
    Point2D point;
    private final List<DiagramElement> layoutTargets = new ArrayList<DiagramElement>();

    public ModifyControlStructureDiagramElementsCommand(TransactionalEditingDomain domain, ControlStructure controlStructure) {
        this(domain, Lists.newArrayList((Iterator)Iterators.filter((Iterator)EcoreUtil.getAllContents((EObject)controlStructure, (boolean)false), LinkableElement.class)), controlStructure);
    }

    public ModifyControlStructureDiagramElementsCommand(TransactionalEditingDomain domain, List<LinkableElement> elements, ControlStructure controlStructure) {
        this(domain, elements, controlStructure, null);
    }

    public ModifyControlStructureDiagramElementsCommand(TransactionalEditingDomain domain, List<LinkableElement> elements, ControlStructure controlStructure, Point2D point) {
        this.domain = domain;
        this.diagram = STAMPDiagramElements.getDiagramElements((EObject)controlStructure, null, Diagram.class).stream().findFirst().orElse(null);
        this.elements = elements;
        this.links = controlStructure.getLinks();
        this.point = point;
    }

    protected boolean prepare() {
        return this.diagram != null;
    }

    public void execute() {
        LayoutCalculator layoutCalculator = new LayoutCalculator();
        this.createLinkEnds(layoutCalculator);
        this.deleteComponentShapes();
        this.createComponentShapes(layoutCalculator);
        this.createEdges();
        this.appendAndExecute((Command)new ControlStructureDiagramLayoutCommand((EditingDomain)this.domain, this.diagram, this.layoutTargets));
    }

    private void deleteComponentShapes() {
        HashSet componentShapes = new HashSet();
        for (LinkableElement element : this.elements) {
            Component component;
            if (!(element instanceof Component) || !this.isAnalysisTarget(component = (Component)element)) continue;
            componentShapes.addAll(STAMPDiagramElements.getDiagramElements((EObject)component, (DiagramElement)this.diagram, STAMPShape.class));
        }
        AbstractTreeIterator<DiagramElement> componentIterator = new AbstractTreeIterator<DiagramElement>((Object)this.diagram, false){
            private static final long serialVersionUID = 1L;

            public Iterator<DiagramElement> getChildren(Object object) {
                return Iterators.filter((Iterator)((DiagramElement)object).getOwnedElements().iterator(), m -> m instanceof STAMPShape && DiagramElements.getModelElement((DiagramElement)m) instanceof Component);
            }
        };
        ArrayList deleteShapes = Lists.newArrayList((Iterator)componentIterator);
        deleteShapes.removeAll(componentShapes);
        if (!deleteShapes.isEmpty()) {
            this.appendAndExecute((Command)new DestroyCommand((EditingDomain)this.domain, (Collection)deleteShapes));
        }
    }

    private void createComponentShapes(LayoutCalculator layoutCalculator) {
        for (LinkableElement element : this.elements) {
            Component component;
            if (!(element instanceof Component) || !this.isAnalysisTarget(component = (Component)element) || this.existDiagramElement((EObject)component, STAMPShape.class)) continue;
            CreateShapeCommand cmd = new CreateShapeCommand();
            Shape parent = STAMPDiagramElements.getDiagramElements((EObject)component.eContainer(), (DiagramElement)this.diagram, STAMPShape.class).stream().map(m -> m).findFirst().orElse((Shape)this.diagram);
            cmd.setOwningElement((DiagramElement)parent);
            STAMPComponentShape shape = STAMPNotationFactory.eINSTANCE.createSTAMPComponentShape();
            shape.getModelElements().add((Object)component);
            cmd.setShape((Shape)shape);
            cmd.setLocation(DCFactory.eINSTANCE.createPoint(0.0, 0.0));
            this.appendAndExecute(cmd.createTransactionalCommand(this.domain));
            this.layoutTargets.add((DiagramElement)shape);
        }
    }

    private void createLinkEnds(LayoutCalculator layoutCalculator) {
        for (LinkableElement element : this.elements) {
            LinkEnd linkEnd;
            if (!(element instanceof LinkEnd) || this.existDiagramElement((EObject)(linkEnd = (LinkEnd)element), STAMPShape.class)) continue;
            CreateShapeCommand cmd = new CreateShapeCommand();
            Shape parent = STAMPDiagramElements.getDiagramElements((EObject)linkEnd.getOwner(), (DiagramElement)this.diagram, STAMPShape.class).stream().map(m -> m).findFirst().orElse((Shape)this.diagram);
            cmd.setOwningElement((DiagramElement)parent);
            STAMPShape shape = STAMPNotationFactory.eINSTANCE.createSTAMPShape();
            shape.getModelElements().add((Object)linkEnd);
            cmd.setShape((Shape)shape);
            cmd.setLocation(DCFactory.eINSTANCE.createPoint(0.0, 0.0));
            this.appendAndExecute(cmd.createTransactionalCommand(this.domain));
            this.layoutTargets.add((DiagramElement)shape);
        }
    }

    private void createEdges() {
        for (Link link : this.links) {
            STAMPShape sourceShape = STAMPDiagramElements.getDiagramElements((EObject)link.getSource(), (DiagramElement)this.diagram, STAMPShape.class).stream().findFirst().orElse(null);
            STAMPShape targetShape = STAMPDiagramElements.getDiagramElements((EObject)link.getTarget(), (DiagramElement)this.diagram, STAMPShape.class).stream().findFirst().orElse(null);
            if (targetShape == null || sourceShape == null || this.existDiagramElement((EObject)link, STAMPEdge.class)) continue;
            CreateEdgeCommand cmd = new CreateEdgeCommand();
            STAMPEdge edge = STAMPNotationFactory.eINSTANCE.createSTAMPEdge();
            edge.getModelElements().add((Object)link);
            cmd.setEdge((Edge)edge);
            cmd.setSource((DiagramElement)sourceShape);
            cmd.setTarget((DiagramElement)targetShape);
            cmd.setLine((Object)NotationFactory.eINSTANCE.createRightAngleLine());
            this.appendAndExecute(cmd.createTransactionalCommand(this.domain));
            this.layoutTargets.add((DiagramElement)edge);
        }
    }

    private <T extends DiagramElement> boolean existDiagramElement(EObject model, Class<T> targetClass) {
        List elements = STAMPDiagramElements.getDiagramElements((EObject)model, (DiagramElement)this.diagram, targetClass);
        return !elements.isEmpty();
    }

    private boolean isAnalysisTarget(Component component) {
        boolean containerResult = component.eContainer() instanceof Component ? this.isAnalysisTarget((Component)component.eContainer()) : true;
        return component.isAnalysisTarget() && containerResult;
    }
}

