/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.control;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.astah.common.collect.Streams;
import net.astah.dd.dc.Point;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.dd.di.util.DiagramElements;
import net.astah.emf.common.ecore.EComparators;
import net.astah.emf.common.notify.EFeaturePath;
import net.astah.emf.edit.command.Commands;
import net.astah.golf.model.IEntityStore;
import net.astah.golf.view.UIView;
import net.astah.jomt.jcontrol.OpenTableEditorCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.StructureView;
import net.astah.project.Facet;
import net.astah.project.Facets;
import net.astah.project.Project;
import net.astah.project.ProjectManagerAdapter;
import net.astah.stpa.stamp.ControlLink;
import net.astah.stpa.stamp.STAMPFactory;
import net.astah.stpa.stamp.STAMPPlugin;
import net.astah.stpa.stamp.STPAAnalysis;
import net.astah.stpa.stamp.UCAAnalysis;
import net.astah.stpa.stamp.UCAGuideWordSet;
import net.astah.stpa.stamp.notation.STAMPCompartmentableShape;
import net.astah.stpa.stamp.notation.STAMPComponentShape;
import net.astah.stpa.stamp.notation.STAMPControlStructureDiagram;
import net.astah.stpa.stamp.notation.STAMPNotationFactory;
import net.astah.stpa.stamp.notation.STAMPNotationPackage;
import net.astah.stpa.stamp.notation.UCATable;
import net.astah.stpa.stamp.notation.edit.command.CreateSTAMPNotationRootCommand;
import net.astah.stpa.stamp.ui.Messages;
import net.astah.stpa.stamp.ui.control.CreateSTAMPDiagramFromPrjCommand;
import net.astah.uml.exception.IllegalModelTypeException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;

public class CreateUCATableFromPrjCommand
extends CreateSTAMPDiagramFromPrjCommand {
    protected Diagram createNewDiagram(IEntityStore doc, EObject owner) {
        STAMPControlStructureDiagram selectedCSDiagram = this.getSelectedControlStructureDiagramInStructureView();
        EditingDomain domain = doc.getDomain();
        Project project = ProjectManagerAdapter.getRootProject((Notifier)owner);
        Facet facet = project.getFacet(STAMPPlugin.FACET_SYMBOLIC_NAME);
        STPAAnalysis analysis = (STPAAnalysis)facet.getContents().get(0);
        STAMPControlStructureDiagram controlStructureDiagram = null;
        if (selectedCSDiagram != null) {
            controlStructureDiagram = selectedCSDiagram;
        } else {
            List diagrams = Streams.stream((Collection)facet.getContents(), STAMPControlStructureDiagram.class).collect(Collectors.toList());
            if (diagrams.size() == 0) {
                MessageManager.displayConfirmMessageDialog((String)"", (String)Messages.create_uca_table_confirm_no_cs);
            } else if (diagrams.size() == 1) {
                controlStructureDiagram = (STAMPControlStructureDiagram)diagrams.get(0);
            } else {
                DiagramEditor currentEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
                if (currentEditor != null && currentEditor.getDiagram() instanceof STAMPControlStructureDiagram) {
                    controlStructureDiagram = (STAMPControlStructureDiagram)JomtGlobal.viewManager.getCurrentDiagramEditor().getDiagram();
                } else {
                    MessageManager.displayConfirmMessageDialog((String)"", (String)(this.isStructureViewSelected() ? Messages.create_uca_table_confirm_many_cs : Messages.create_uca_table_confirm_many_cs_2));
                }
            }
        }
        if (controlStructureDiagram == null) {
            return null;
        }
        UCATable ucaTable = this.getUCATable(controlStructureDiagram);
        if (ucaTable != null) {
            return ucaTable;
        }
        UCAAnalysis ucaAnalysis = analysis.getUcaAnalysis();
        if (ucaAnalysis == null) {
            ucaAnalysis = STAMPFactory.eINSTANCE.createUCAAnalysis();
        }
        analysis.setUcaAnalysis(ucaAnalysis);
        ucaAnalysis.setGuideWordSet((UCAGuideWordSet)analysis.getUCAGuideWordSets().get(0));
        this.registerControlActionsOrder(controlStructureDiagram, ucaAnalysis);
        UCATable table = STAMPNotationFactory.eINSTANCE.createUCATable();
        Commands.execute((Command)new CreateSTAMPNotationRootCommand(domain, facet, owner, (EObject)table));
        table.setAnalysis(ucaAnalysis);
        table.setControlStructureDiagram(controlStructureDiagram);
        return table;
    }

    private STAMPControlStructureDiagram getSelectedControlStructureDiagramInStructureView() {
        if (!this.isStructureViewSelected()) {
            return null;
        }
        Set selectedModelElements = JomtGlobal.viewManager.getProjectView().getSelectedModelElements();
        if (selectedModelElements == null) {
            return null;
        }
        ArrayList csDiagrams = Lists.newArrayList((Iterable)Iterables.filter((Iterable)selectedModelElements, STAMPControlStructureDiagram.class));
        if (csDiagrams.isEmpty()) {
            return null;
        }
        if (csDiagrams.size() > 1) {
            csDiagrams.sort(EComparators.eObjectPath());
        }
        return (STAMPControlStructureDiagram)csDiagrams.get(0);
    }

    private boolean isStructureViewSelected() {
        UIView selectedUIViewTab = JomtGlobal.viewManager.getProjectView().getSelectedUIViewTab();
        return selectedUIViewTab instanceof StructureView;
    }

    private UCATable getUCATable(STAMPControlStructureDiagram controlStructureDiagram) {
        EFeaturePath path = EFeaturePath.build((EStructuralFeature)STAMPNotationPackage.Literals.UCA_TABLE__CONTROL_STRUCTURE_DIAGRAM);
        return path.getInverseReferences((EObject)controlStructureDiagram).stream().map(UCATable.class::cast).findFirst().orElse(null);
    }

    private void registerControlActionsOrder(STAMPControlStructureDiagram diagram, UCAAnalysis analysis) {
        ArrayList componentShapes = Lists.newArrayList((Iterator)Iterators.filter((Iterator)DiagramElements.getAllContents((DiagramElement)diagram), STAMPComponentShape.class));
        Comparator locationComparator = EComparators.cast(DiagramElement.class, (Comparator)new ElementLocationComparator());
        Collections.sort(componentShapes, locationComparator);
        for (STAMPCompartmentableShape shape : componentShapes) {
            EList sourceEdges = shape.getSourceEdges();
            ArrayList sortedEdges = Lists.newArrayList((Iterable)sourceEdges);
            sortedEdges.sort((o1, o2) -> {
                EObject m1 = DiagramElements.getModelElement((DiagramElement)o1);
                EObject m2 = DiagramElements.getModelElement((DiagramElement)o2);
                return EComparators.eObjectPath().compare(m1, m2);
            });
            List actions = sortedEdges.stream().map(edge -> (ControlLink)DiagramElements.getModelElement((DiagramElement)edge, ControlLink.class)).filter(Objects::nonNull).flatMap(link -> link.getActions().stream()).collect(Collectors.toList());
            analysis.getControlActions().addAll(actions);
        }
    }

    protected void setDiagramName(IEntityStore doc, Diagram diagram) {
        ResourceSet resourceSet = doc.getDomain().getResourceSet();
        if (!Strings.isNullOrEmpty((String)diagram.getName())) {
            return;
        }
        String prefix = PropertyManager.getProjectViewResourceBundle().getString("uml.uca_table.label");
        diagram.setName(Facets.generateName((Notifier)resourceSet, (String)STAMPPlugin.FACET_SYMBOLIC_NAME, (EClass)diagram.eClass(), (String)prefix));
    }

    protected String getNameString() {
        throw new UnsupportedOperationException();
    }

    protected void doPostProcessing() throws IllegalModelTypeException {
    }

    protected net.astah.golf.control.Command createOpenEditorCommand(Diagram diagram) {
        OpenTableEditorCommand command = new OpenTableEditorCommand();
        command.setModel((Object)diagram);
        return command;
    }

    static class ElementLocationComparator
    implements Comparator<DiagramElement> {
        private final LayoutCalculator layoutCalculator = new LayoutCalculator();

        ElementLocationComparator() {
        }

        @Override
        public int compare(DiagramElement o1, DiagramElement o2) {
            return this.compareLocation(o1, o2);
        }

        private int compareLocation(DiagramElement shape1, DiagramElement shape2) {
            Point point1 = this.layoutCalculator.getBoundsLocation((Object)shape1);
            Point point2 = this.layoutCalculator.getBoundsLocation((Object)shape2);
            double distanceX = point1.getX() - point2.getX();
            if (distanceX != 0.0) {
                return distanceX > 0.0 ? 1 : -1;
            }
            double distanceY = point1.getY() - point2.getY();
            if (distanceY != 0.0) {
                return distanceY > 0.0 ? 1 : -1;
            }
            return 0;
        }
    }
}

