/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.control;

import com.google.common.base.Strings;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import net.astah.dd.di.Diagram;
import net.astah.emf.common.ecore.EComparators;
import net.astah.emf.common.notify.EFeaturePath;
import net.astah.emf.edit.command.Commands;
import net.astah.emf.edit.provider.swing.renderer.LabelProviderListCellRenderer;
import net.astah.golf.model.IEntityStore;
import net.astah.golf.widget.swing.ILabelProvider;
import net.astah.golf.widget.swing.SwingFrame;
import net.astah.jomt.jcontrol.OpenTableEditorCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.MessageManager;
import net.astah.project.Facet;
import net.astah.project.Facets;
import net.astah.project.Project;
import net.astah.project.ProjectManagerAdapter;
import net.astah.stpa.stamp.ControlAction;
import net.astah.stpa.stamp.ControlLoop;
import net.astah.stpa.stamp.HCFAnalysis;
import net.astah.stpa.stamp.HCFHintWordSet;
import net.astah.stpa.stamp.STAMPPlugin;
import net.astah.stpa.stamp.STPAAnalysis;
import net.astah.stpa.stamp.UnsafeControlAction;
import net.astah.stpa.stamp.notation.HCFTable;
import net.astah.stpa.stamp.notation.STAMPNotationFactory;
import net.astah.stpa.stamp.notation.STAMPNotationPackage;
import net.astah.stpa.stamp.notation.edit.command.CreateSTAMPNotationRootCommand;
import net.astah.stpa.stamp.ui.Messages;
import net.astah.stpa.stamp.ui.control.CreateSTAMPDiagramFromPrjCommand;
import net.astah.stpa.stamp.ui.view.SelectElementListDialog;
import net.astah.uml.exception.IllegalModelTypeException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;

public class CreateHCFTableFromPrjCommand
extends CreateSTAMPDiagramFromPrjCommand {
    protected Diagram createNewDiagram(IEntityStore doc, EObject owner) {
        ControlAction controlAction;
        ControlLoop controlLoop;
        EditingDomain domain = doc.getDomain();
        Project project = ProjectManagerAdapter.getRootProject((Notifier)owner);
        Facet facet = project.getFacet(STAMPPlugin.FACET_SYMBOLIC_NAME);
        STPAAnalysis analysis = (STPAAnalysis)facet.getContents().get(0);
        JFrame parent = (JFrame)((SwingFrame)JomtGlobal.viewManager.getManagementView().getComponent()).getComponent();
        ArrayList list = new ArrayList(analysis.getUnsafeControlActions());
        if (list.isEmpty()) {
            MessageManager.displayConfirmMessageDialog((String)"", (String)Messages.create_hcf_table_confirm_no_uca);
            return null;
        }
        list.sort(EComparators.comparingFeature((String)"id"));
        UnsafeControlAction initialSelected = (UnsafeControlAction)list.get(0);
        SelectElementListDialog<UnsafeControlAction> dialog = new SelectElementListDialog<UnsafeControlAction>((Frame)parent, list, initialSelected){
            private static final long serialVersionUID = 1L;

            @Override
            protected ListCellRenderer<? super UnsafeControlAction> createListCellRenderer() {
                return new UCAListCellRenderer(this.createLabelProvider());
            }
        };
        dialog.setTitle(Messages.hcf_table_select_uca_label);
        dialog.setDescription(Messages.hcf_table_select_uca_description_label);
        dialog.setVisible(true);
        if (dialog.getResultState() != 1) {
            dialog.dispose();
            return null;
        }
        UnsafeControlAction uca = (UnsafeControlAction)dialog.getSelectedElement();
        dialog.dispose();
        Set hcfTables = EFeaturePath.build((EStructuralFeature)STAMPNotationPackage.Literals.HCF_TABLE__UNSAFE_CONTROL_ACTION).getInverseReferences((EObject)uca);
        if (!hcfTables.isEmpty()) {
            return (HCFTable)hcfTables.iterator().next();
        }
        HCFAnalysis hcfAnalysis = analysis.getHcfAnalysis();
        if (hcfAnalysis == null) {
            hcfAnalysis = analysis.createHcfAnalysis();
        }
        if ((controlLoop = this.getControlLoop(hcfAnalysis, controlAction = uca.getControlAction())) == null) {
            controlLoop = hcfAnalysis.createControlLoop();
            controlLoop.setTargetLink(controlAction.getOwner());
            HCFHintWordSet defaultHintWordSet = (HCFHintWordSet)analysis.getHCFHintWordSets().get(0);
            controlLoop.setHintWordSet(defaultHintWordSet);
        }
        HCFTable table = STAMPNotationFactory.eINSTANCE.createHCFTable();
        Commands.execute((Command)new CreateSTAMPNotationRootCommand(domain, facet, owner, (EObject)table));
        table.setControlLoop(controlLoop);
        table.setUnsafeControlAction(uca);
        return table;
    }

    private ControlLoop getControlLoop(HCFAnalysis hcfAnalysis, ControlAction controlAction) {
        EList controlLoops = hcfAnalysis.getControlLoops();
        return controlLoops.stream().filter(loop -> loop.getTargetLink() == controlAction.getLink()).findFirst().orElse(null);
    }

    protected void setDiagramName(IEntityStore doc, Diagram diagram) {
        ResourceSet resourceSet = doc.getDomain().getResourceSet();
        if (!Strings.isNullOrEmpty((String)diagram.getName())) {
            return;
        }
        String prefix = PropertyManager.getProjectViewResourceBundle().getString("uml.hcf_table.label");
        diagram.setName(Facets.generateName((Notifier)resourceSet, (String)STAMPPlugin.FACET_SYMBOLIC_NAME, (EClass)diagram.eClass(), (String)prefix));
    }

    protected String getNameString() {
        throw new UnsupportedOperationException();
    }

    protected void doPostProcessing() throws IllegalModelTypeException {
    }

    protected net.astah.golf.control.Command createOpenEditorCommand(Diagram diagram) {
        OpenTableEditorCommand command = new OpenTableEditorCommand();
        command.setModel((Object)diagram);
        return command;
    }

    private static class UCAListCellRenderer
    extends LabelProviderListCellRenderer {
        private static final long serialVersionUID = 1L;
        private final EFeaturePath featurePath = EFeaturePath.build((EStructuralFeature)STAMPNotationPackage.Literals.HCF_TABLE__UNSAFE_CONTROL_ACTION);

        public UCAListCellRenderer(ILabelProvider labelProvider) {
            super(labelProvider);
        }

        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            assert (component instanceof JLabel);
            JLabel label = (JLabel)component;
            JLabel checkLabel = new JLabel("\u25cb ");
            checkLabel.setFont(label.getFont());
            StringBuffer text = new StringBuffer();
            if (this.featurePath.getInverseReferences((EObject)value).isEmpty()) {
                label.setBorder(new CompoundBorder(label.getBorder(), new EmptyBorder(0, checkLabel.getPreferredSize().width, 0, 0)));
            } else {
                text.append(checkLabel.getText());
            }
            text.append(label.getText());
            label.setText(text.toString());
            return label;
        }
    }
}

