/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.control;

import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.util.DiagramElements;
import net.astah.golf.control.Command;
import net.astah.golf.draw.GCamera;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.DiagramViewInfo;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jomt.jcontrol.CommandSupport;
import net.astah.jomt.jcontrol.OpenDiagramEditorCommand;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.stpa.stamp.ControlStructure;
import net.astah.stpa.stamp.notation.ComponentExtractingTable;
import net.astah.stpa.stamp.ui.control.CreateControlStructureDiagramFromPrjCommand;
import net.astah.stpa.stamp.ui.control.ModifyControlStructureDiagramElementsCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class CreateControlStructureDiagramFromTableCommand
extends Command {
    private ComponentExtractingTable table;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (ModelGlobal.prjManager == null || ModelGlobal.prjManager.getCurrentProject() == null) {
            return;
        }
        IJomtEntityStore doc = ModelGlobal.prjManager.getCurrentProject().doc;
        if (doc == null) {
            return;
        }
        if (this.table == null) {
            this.table = this.getSelectedComponentExtractingTable();
        }
        if (this.table == null) {
            return;
        }
        if (this.table.getControlStructureDiagram() != null) {
            this.openCreatedDiagram((Diagram)this.table.getControlStructureDiagram());
            return;
        }
        TransactionalEditingDomain domain = (TransactionalEditingDomain)doc.getDomain();
        try {
            doc.beginTransaction();
            Diagram createdDiagram = this.createDiagram(domain);
            ModifyControlStructureDiagramElementsCommand command = new ModifyControlStructureDiagramElementsCommand(domain, (ControlStructure)DiagramElements.getModelElement((DiagramElement)createdDiagram));
            if (command.canExecute()) {
                command.execute();
            }
            doc.commitTransaction();
            this.openCreatedDiagram(createdDiagram);
        }
        catch (BadTransactionException e) {
            MessageManager.requireBugReport((Throwable)e);
            doc.abortTransaction();
        }
        catch (Exception e) {
            MessageManager.requireBugReport((Throwable)e);
            doc.abortTransaction();
        }
    }

    private ComponentExtractingTable getSelectedComponentExtractingTable() {
        return (ComponentExtractingTable)CommandSupport.instance().getSelectedModelElementFromProjectView();
    }

    private void openCreatedDiagram(Diagram diagram) {
        OpenDiagramEditorCommand cmd = new OpenDiagramEditorCommand();
        DiagramViewInfo viewInfo = new DiagramViewInfo(diagram, new GCamera());
        cmd.setDiagramViewInfo(viewInfo);
        this.callCommand((Command)cmd);
    }

    private Diagram createDiagram(TransactionalEditingDomain domain) {
        CreateControlStructureDiagramFromPrjCommand cmd = new CreateControlStructureDiagramFromPrjCommand();
        cmd.setUseTransaction(false);
        cmd.setOpenEditorAfterCreate(false);
        this.callCommand((Command)cmd);
        return cmd.getDiagram();
    }

    public void setComponentExtractingTable(ComponentExtractingTable table) {
        this.table = table;
    }
}

