/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.control;

import com.google.common.collect.Iterables;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.util.DiagramElements;
import net.astah.emf.edit.command.Commands;
import net.astah.golf.model.IEntityStore;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.project.Facet;
import net.astah.project.Facets;
import net.astah.project.Project;
import net.astah.project.ProjectManagerAdapter;
import net.astah.stpa.stamp.ControlStructure;
import net.astah.stpa.stamp.STAMPPlugin;
import net.astah.stpa.stamp.STPAAnalysis;
import net.astah.stpa.stamp.notation.ComponentExtractingTable;
import net.astah.stpa.stamp.notation.STAMPControlStructureDiagram;
import net.astah.stpa.stamp.notation.STAMPDiagram;
import net.astah.stpa.stamp.notation.STAMPNotationFactory;
import net.astah.stpa.stamp.notation.edit.command.CreateSTAMPNotationRootCommand;
import net.astah.stpa.stamp.ui.control.CreateSTAMPDiagramFromPrjCommand;
import net.astah.uml.exception.IllegalModelTypeException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;

public class CreateControlStructureDiagramFromPrjCommand
extends CreateSTAMPDiagramFromPrjCommand {
    protected STAMPDiagram createNewDiagram(IEntityStore doc, EObject namedElement) {
        EditingDomain domain = doc.getDomain();
        Project project = ProjectManagerAdapter.getRootProject((Notifier)namedElement);
        Facet facet = project.getFacet(STAMPPlugin.FACET_SYMBOLIC_NAME);
        STPAAnalysis analysis = (STPAAnalysis)facet.getContents().get(0);
        ControlStructure controlStructure = analysis.getControlStructures().stream().findFirst().orElseGet(() -> ((STPAAnalysis)analysis).createControlStructure());
        STAMPControlStructureDiagram diagram = STAMPNotationFactory.eINSTANCE.createSTAMPControlStructureDiagram();
        Commands.execute((Command)new CreateSTAMPNotationRootCommand(domain, facet, namedElement, (EObject)diagram));
        DiagramElements.setModelElement((DiagramElement)diagram, (EObject)controlStructure);
        ComponentExtractingTable table = (ComponentExtractingTable)Iterables.getFirst((Iterable)Iterables.filter((Iterable)facet.getContents(), ComponentExtractingTable.class), null);
        if (table != null && table.getControlStructureDiagram() == null) {
            diagram.setComponentExtractingTable(table);
        }
        return diagram;
    }

    protected void setDiagramName(IEntityStore doc, Diagram diagram) {
        ResourceSet resourceSet = doc.getDomain().getResourceSet();
        String prefix = PropertyManager.getProjectViewResourceBundle().getString("uml.control_structure_diagram.label");
        diagram.setName(Facets.generateName((Notifier)resourceSet, (String)STAMPPlugin.FACET_SYMBOLIC_NAME, (EClass)diagram.eClass(), (String)prefix));
    }

    protected String getNameString() {
        throw new UnsupportedOperationException();
    }

    protected void doPostProcessing() throws IllegalModelTypeException {
    }
}

