/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.control;

import net.astah.golf.control.Command;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.project.Facets;
import net.astah.project.Project;
import net.astah.project.ProjectManagerAdapter;
import net.astah.stpa.stamp.STAMPPlugin;
import net.astah.stpa.stamp.notation.ComponentExtractingTable;
import net.astah.stpa.stamp.notation.STAMPControlStructureDiagram;
import net.astah.stpa.stamp.ui.control.CreateControlStructureDiagramFromPrjCommand;
import net.astah.stpa.stamp.ui.control.CreateControlStructureDiagramFromTableCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;

public class CreateControlStructureDiagramDelegateCommand
extends Command {
    private String arg;
    private Project project;

    public void setArgumentString(String arg) {
        this.arg = arg;
    }

    public void execute() {
        this.project = this.getRootProject();
        this.callCommand(this.createCommand());
    }

    private Project getRootProject() {
        net.astah.jmodel.Project currentProject = ModelGlobal.prjManager.getCurrentProject();
        if (currentProject == null) {
            return null;
        }
        EditingDomain domain = currentProject.doc.getDomain();
        if (domain == null) {
            return null;
        }
        ResourceSet resourceSet = domain.getResourceSet();
        if (resourceSet == null) {
            return null;
        }
        Project rootProject = ProjectManagerAdapter.getRootProject((Notifier)resourceSet);
        return rootProject;
    }

    private Command createCommand() {
        Object command;
        ComponentExtractingTable extractingTable = this.getComponentExtractingTable();
        if (!this.existControlStructureDiagram() && extractingTable != null) {
            CreateControlStructureDiagramFromTableCommand fromTableCommand = new CreateControlStructureDiagramFromTableCommand();
            fromTableCommand.setComponentExtractingTable(extractingTable);
            command = fromTableCommand;
        } else {
            command = new CreateControlStructureDiagramFromPrjCommand();
        }
        if (this.arg != null) {
            command.setArgumentString(this.arg);
        }
        return command;
    }

    private boolean existControlStructureDiagram() {
        return Facets.getContents((Project)this.project, (String)STAMPPlugin.FACET_SYMBOLIC_NAME).stream().anyMatch(STAMPControlStructureDiagram.class::isInstance);
    }

    private ComponentExtractingTable getComponentExtractingTable() {
        return (ComponentExtractingTable)Facets.getFirstContent((Project)this.project, (String)STAMPPlugin.FACET_SYMBOLIC_NAME, ComponentExtractingTable.class, null);
    }
}

