/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.control;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import net.astah.common.collect.Streams;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.util.DiagramElements;
import net.astah.emf.common.ecore.EComparators;
import net.astah.emf.common.notify.EFeaturePath;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.stpa.stamp.ControlLink;
import net.astah.stpa.stamp.STAMPPackage;
import net.astah.stpa.stamp.notation.STAMPControlLoopDiagram;
import net.astah.stpa.stamp.notation.STAMPEdge;
import net.astah.stpa.stamp.notation.STAMPNotationPackage;
import net.astah.stpa.stamp.notation.STAMPShape;
import net.astah.stpa.stamp.ui.Messages;
import net.astah.stpa.stamp.ui.control.CreateControlLoopDiagramCommand;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.emf.ecore.EObject;

public class CreateControlLoopDiagramFromPrjCommand
extends CreateControlLoopDiagramCommand {
    public static final String OPEN_IF_EXISTS = "openIfExists";
    private boolean openIfExists = false;

    public CreateControlLoopDiagramFromPrjCommand() {
        this.setSelectedDiagramElement();
    }

    private void setSelectedDiagramElement() {
        DiagramEditor currentDiagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        if (currentDiagramEditor == null) {
            return;
        }
        Object[] selectedModels = currentDiagramEditor.getSelectedModels();
        if (ArrayUtils.isEmpty((Object[])selectedModels)) {
            return;
        }
        DiagramElement selected = (DiagramElement)selectedModels[0];
        if (selected instanceof STAMPShape && this.isControlLink(selected.getOwningElement())) {
            selected = selected.getOwningElement();
        }
        this.setSelectedDiagramElement(selected);
    }

    public void setArgumentString(String arg) {
        this.openIfExists = OPEN_IF_EXISTS.equalsIgnoreCase(arg);
    }

    public void execute() {
        Iterable<STAMPControlLoopDiagram> clDiagrams;
        if (this.openIfExists && !Iterables.isEmpty(clDiagrams = this.getCLDiagrams(this.getSelectedDiagramElement()))) {
            STAMPControlLoopDiagram diagram = this.selectCLDiagram(clDiagrams);
            if (diagram != null) {
                this.callCommand(this.createOpenEditorCommand((Diagram)diagram));
            }
            return;
        }
        if (!this.isControlLink(this.getSelectedDiagramElement())) {
            MessageManager.displayErrorMessageDialog((String)Messages.cl_cannot_create);
            return;
        }
        super.execute();
    }

    private boolean isControlLink(Object object) {
        return object instanceof STAMPEdge && DiagramElements.isModelElementPresent((DiagramElement)((STAMPEdge)object), ControlLink.class);
    }

    private Iterable<STAMPControlLoopDiagram> getCLDiagrams(DiagramElement diagramElement) {
        if (diagramElement == null) {
            return Collections.emptyList();
        }
        ControlLink controlLink = (ControlLink)DiagramElements.getModelElement((DiagramElement)diagramElement, ControlLink.class);
        if (controlLink == null) {
            return Collections.emptyList();
        }
        EFeaturePath path = EFeaturePath.builder().addInverse(STAMPPackage.Literals.CONTROL_LOOP__TARGET_LINK).addInverse(STAMPNotationPackage.Literals.STAMP_CONTROL_LOOP_DIAGRAM__CONTROL_LOOP).create();
        return Streams.stream((Collection)path.getReferences((EObject)controlLink), STAMPControlLoopDiagram.class).sorted(EComparators.eObjectPath()).collect(Collectors.toList());
    }

    private STAMPControlLoopDiagram selectCLDiagram(Iterable<STAMPControlLoopDiagram> diagrams) {
        return (STAMPControlLoopDiagram)Iterables.getFirst(diagrams, null);
    }
}

