/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.control;

import com.google.common.collect.Iterables;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.astah.dd.dc.Bounds;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dc.Point;
import net.astah.dd.di.DIPackage;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.Edge;
import net.astah.dd.di.edit.command.DiagramContext;
import net.astah.dd.di.edit.command.MoveTogetherCommand;
import net.astah.dd.di.edit.command.SetBoundsCommand;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.dd.di.util.DiagramElements;
import net.astah.emf.common.ecore.DataTypes;
import net.astah.emf.common.ecore.EComparators;
import net.astah.emf.edit.command.CommandUtils;
import net.astah.emf.edit.command.Commands;
import net.astah.emf.edit.command.DeferringCommandWrapper;
import net.astah.emf.edit.command.PasteCommand;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.geom2D.Tpl2d;
import net.astah.golf.geom2D.Vec2d;
import net.astah.golf.model.IEntityStore;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.notation.LineConstraint;
import net.astah.notation.LocationConstraint;
import net.astah.notation.NotationFactory;
import net.astah.notation.Shape;
import net.astah.notation.Vector;
import net.astah.notation.edit.layout.DiagramElementOperations;
import net.astah.project.Facet;
import net.astah.project.Facets;
import net.astah.project.Project;
import net.astah.project.ProjectManagerAdapter;
import net.astah.stpa.stamp.Component;
import net.astah.stpa.stamp.ControlAction;
import net.astah.stpa.stamp.ControlLink;
import net.astah.stpa.stamp.ControlLoop;
import net.astah.stpa.stamp.HCFAnalysis;
import net.astah.stpa.stamp.HCFHintWordSet;
import net.astah.stpa.stamp.Link;
import net.astah.stpa.stamp.LinkEnd;
import net.astah.stpa.stamp.STAMPPlugin;
import net.astah.stpa.stamp.STPAAnalysis;
import net.astah.stpa.stamp.Signal;
import net.astah.stpa.stamp.notation.STAMPComponentShape;
import net.astah.stpa.stamp.notation.STAMPControlLoopDiagram;
import net.astah.stpa.stamp.notation.STAMPDiagramElement;
import net.astah.stpa.stamp.notation.STAMPEdge;
import net.astah.stpa.stamp.notation.STAMPLabel;
import net.astah.stpa.stamp.notation.STAMPNotationFactory;
import net.astah.stpa.stamp.notation.edit.command.CreateSTAMPNotationRootCommand;
import net.astah.stpa.stamp.notation.edit.command.SynchronizeLabelCommand;
import net.astah.stpa.stamp.notation.provider.STAMPComponentShapeItemProvider;
import net.astah.stpa.stamp.ui.control.AddControlActionCommand;
import net.astah.stpa.stamp.ui.control.AddFeedbackCommand;
import net.astah.stpa.stamp.ui.control.AddSignalCommand;
import net.astah.stpa.stamp.ui.control.CreateSTAMPDiagramFromPrjCommand;
import net.astah.ui.control.CreateEdgeCommand;
import net.astah.ui.control.CreateShapeCommand;
import net.astah.uml.exception.IllegalModelTypeException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.StrictCompoundCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateControlLoopDiagramCommand
extends CreateSTAMPDiagramFromPrjCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateControlLoopDiagramCommand.class);
    private DiagramElement selectedDiagramElement = null;
    private Collection<?> copyResults;
    private final List<DiagramElement> diagramSelections = new ArrayList<DiagramElement>();
    private DiagramElement diagramElement;
    private DiagramElement sourceElement;
    private DiagramElement targetElement;
    private final List<net.astah.notation.Edge> externalLinks = new ArrayList<net.astah.notation.Edge>();

    public void setSelectedDiagramElement(DiagramElement selectedDiagramElement) {
        this.selectedDiagramElement = selectedDiagramElement;
    }

    public DiagramElement getSelectedDiagramElement() {
        return this.selectedDiagramElement;
    }

    protected Diagram createNewDiagram(IEntityStore doc, EObject owner) {
        ControlLoop controlLoop;
        if (this.selectedDiagramElement == null) {
            return null;
        }
        this.diagramElement = this.selectedDiagramElement instanceof STAMPLabel ? this.selectedDiagramElement.getOwningElement() : this.selectedDiagramElement;
        this.collectElements();
        if (!this.copyRelatedDiagramElements()) {
            return null;
        }
        EditingDomain domain = doc.getDomain();
        Project project = ProjectManagerAdapter.getRootProject((Notifier)owner);
        Facet facet = project.getFacet(STAMPPlugin.FACET_SYMBOLIC_NAME);
        STPAAnalysis analysis = (STPAAnalysis)facet.getContents().get(0);
        HCFAnalysis hcfAnalysis = analysis.getHcfAnalysis();
        if (hcfAnalysis == null) {
            hcfAnalysis = analysis.createHcfAnalysis();
        }
        if ((controlLoop = this.getControlLoop(hcfAnalysis)) == null) {
            return null;
        }
        if (controlLoop.getTargetLink() == null && this.diagramElement instanceof STAMPEdge) {
            DiagramElements.ifModelElementPresent((DiagramElement)this.diagramElement, ControlLink.class, m -> controlLoop.setTargetLink(m));
        }
        if (controlLoop.getHintWordSet() == null) {
            HCFHintWordSet defaultHintWordSet = (HCFHintWordSet)analysis.getHCFHintWordSets().get(0);
            controlLoop.setHintWordSet(defaultHintWordSet);
        }
        STAMPControlLoopDiagram controlLoopDiagram = STAMPNotationFactory.eINSTANCE.createSTAMPControlLoopDiagram();
        Commands.execute((Command)new CreateSTAMPNotationRootCommand(domain, facet, owner, (EObject)controlLoopDiagram));
        controlLoopDiagram.setControlLoop(controlLoop);
        return controlLoopDiagram;
    }

    protected void setDiagramName(IEntityStore doc, Diagram diagram) {
        ResourceSet resourceSet = doc.getDomain().getResourceSet();
        String prefix = PropertyManager.getProjectViewResourceBundle().getString("uml.control_loop_diagram.label");
        diagram.setName(Facets.generateName((Notifier)resourceSet, (String)STAMPPlugin.FACET_SYMBOLIC_NAME, (EClass)diagram.eClass(), (String)prefix));
    }

    protected String getNameString() {
        throw new UnsupportedOperationException();
    }

    protected void postOpenEditor() {
        super.postOpenEditor();
        JomtGlobal.viewManager.getCurrentDiagramEditor().setSelected(true);
    }

    protected void doPostProcessing() throws IllegalModelTypeException {
        final Diagram controlLoopDiagram = this.getDiagram();
        final TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)controlLoopDiagram);
        Diagram controlStructureDiagram = DiagramElementOperations.getDiagram((DiagramElement)this.diagramElement);
        final LayoutCalculator layoutCalculator = new LayoutCalculator();
        Pnt2d pasteLocation = new Pnt2d(0.0, 0.0);
        DiagramContext diagramContext = new DiagramContext(controlStructureDiagram, this.diagramSelections, this.toAbsolute(pasteLocation, this.diagramSelections, layoutCalculator));
        StrictCompoundCommand command = new StrictCompoundCommand();
        command.append(PasteCommand.create((EditingDomain)domain, (Object)diagramContext, (Object)controlLoopDiagram, (Object)DIPackage.Literals.DIAGRAM_ELEMENT__OWNED_ELEMENT, this.copyResults, (int)-1));
        Bounds totalBounds = layoutCalculator.getTotalBounds(this.diagramSelections);
        final Vec2d pasteVector = new Vec2d(pasteLocation.getX() - totalBounds.getX(), pasteLocation.getY() - totalBounds.getY());
        for (net.astah.notation.Edge edge : this.externalLinks) {
            boolean souceIsExternal = this.isExternal(edge.getSource(), this.sourceElement, this.targetElement);
            DiagramElement externalEnd = souceIsExternal ? edge.getSource() : edge.getTarget();
            DiagramElement oppositeEnd = souceIsExternal ? edge.getTarget() : edge.getSource();
            DiagramElement copiedOppositeEnd = this.getCopiedElement(oppositeEnd);
            if (!(externalEnd instanceof Shape)) continue;
            Shape copyEnd = this.appendCopyEndCommand((CompoundCommand)command, domain, (Shape)externalEnd, oppositeEnd, edge, souceIsExternal, pasteVector, layoutCalculator);
            net.astah.notation.Edge copyEdge = this.appendCopyEdgeCommand((CompoundCommand)command, domain, edge, (DiagramElement)copyEnd, copiedOppositeEnd, souceIsExternal, pasteVector);
            this.appendCopySignalsCommand((CompoundCommand)command, domain, edge, copyEdge);
        }
        for (final DiagramElement sel : Iterables.filter(this.diagramSelections, Shape.class)) {
            command.append((Command)new DeferringCommandWrapper(){

                protected Command createCommand() {
                    Bounds selBounds = layoutCalculator.getBounds((Object)sel);
                    Bounds expectedBounds = DCFactory.eINSTANCE.createBounds(selBounds.getX() + pasteVector.getX(), selBounds.getY() + pasteVector.getY(), selBounds.getWidth(), selBounds.getHeight());
                    DiagramElement copiedElement = CreateControlLoopDiagramCommand.this.getCopiedElement(sel);
                    Bounds copiedBounds = layoutCalculator.getBounds((Object)copiedElement);
                    if (copiedElement != null && !DataTypes.eEquals((EObject)expectedBounds, (EObject)copiedBounds)) {
                        return SetBoundsCommand.create((EditingDomain)domain, null, (Object)copiedElement, (Object)expectedBounds);
                    }
                    return IdentityCommand.INSTANCE;
                }
            });
        }
        command.append((Command)new DeferringCommandWrapper(){

            protected Command createCommand() {
                double marginX = 100.0;
                double marginY = 100.0;
                LayoutCalculator layoutCalculator = new LayoutCalculator();
                EList ownedElements = controlLoopDiagram.getOwnedElements();
                Bounds totalBounds = layoutCalculator.getTotalBounds((Iterable)ownedElements, true);
                double x = 100.0 - totalBounds.getX();
                double y = 100.0 - totalBounds.getY();
                Vector vector = NotationFactory.eINSTANCE.createVector(x, y);
                return MoveTogetherCommand.create((EditingDomain)domain, null, (Object)controlLoopDiagram, (Object)vector, (Collection)ownedElements);
            }
        });
        IJomtEntityStore doc = ModelGlobal.prjManager.getCurrentProject().doc;
        try {
            if (this.useTransaction) {
                doc.beginTransaction();
            }
            CommandUtils.execute((EditingDomain)domain, (Command)command);
            if (this.useTransaction) {
                doc.commitTransaction();
            }
        }
        catch (Exception ex) {
            LOGGER.error("error has occurred.", (Throwable)ex);
        }
    }

    private Pnt2d toAbsolute(Pnt2d location, Collection<DiagramElement> elements, LayoutCalculator layoutCalculator) {
        Pnt2d absolute = new Pnt2d((Tpl2d)location);
        Iterator<DiagramElement> iterator = elements.iterator();
        if (!iterator.hasNext()) {
            return absolute;
        }
        DiagramElement ancestor = iterator.next();
        while (iterator.hasNext()) {
            DiagramElement element = iterator.next();
            ancestor = DiagramElements.getCommonAncestor((DiagramElement)ancestor, (DiagramElement)element);
        }
        Point boundsLocation = layoutCalculator.getBoundsLocation((Object)ancestor);
        if (boundsLocation != null) {
            absolute.add((Tpl2d)Geometries.toPnt2d((Point)boundsLocation));
        }
        return absolute;
    }

    private Shape appendCopyEndCommand(CompoundCommand command, TransactionalEditingDomain domain, Shape externalEnd, DiagramElement oppositeEnd, net.astah.notation.Edge edge, boolean souceIsExternal, Vec2d pasteVector, LayoutCalculator layoutCalculator) {
        Pnt2d location = this.decideLocation((DiagramElement)externalEnd, oppositeEnd, edge, souceIsExternal, layoutCalculator);
        location.add((Tpl2d)pasteVector);
        Shape copyEnd = (Shape)STAMPNotationFactory.eINSTANCE.create(externalEnd.eClass());
        if (copyEnd instanceof STAMPComponentShape) {
            ((STAMPComponentShape)copyEnd).setIsOmitted(true);
        }
        ECollections.setEList((EList)copyEnd.getModelElements(), (List)externalEnd.getModelElements());
        CreateShapeCommand createShapeCommand = new CreateShapeCommand();
        createShapeCommand.setOwningElement(this.decideOwningElement((DiagramElement)externalEnd));
        createShapeCommand.setShape((net.astah.dd.di.Shape)copyEnd);
        createShapeCommand.setLocation(Geometries.toPoint((Point2D)location));
        command.append(createShapeCommand.createTransactionalCommand(domain));
        return copyEnd;
    }

    private net.astah.notation.Edge appendCopyEdgeCommand(CompoundCommand command, TransactionalEditingDomain domain, net.astah.notation.Edge edge, DiagramElement copyEnd, DiagramElement copiedOppositeEnd, boolean souceIsExternal, Vec2d pasteVector) {
        STAMPEdge copyEdge = STAMPNotationFactory.eINSTANCE.createSTAMPEdge();
        ECollections.setEList((EList)copyEdge.getModelElements(), (List)edge.getModelElements());
        CreateEdgeCommand createEdgeCommand = new CreateEdgeCommand();
        DiagramElement owningElement = this.decideOwningElement((DiagramElement)edge);
        createEdgeCommand.setOwningElement(owningElement);
        createEdgeCommand.setEdge((Edge)copyEdge);
        if (souceIsExternal) {
            createEdgeCommand.setSource(copyEnd);
            createEdgeCommand.setTarget(copiedOppositeEnd);
        } else {
            createEdgeCommand.setSource(copiedOppositeEnd);
            createEdgeCommand.setTarget(copyEnd);
        }
        if (!souceIsExternal && edge.getSourceAnchor() != null) {
            createEdgeCommand.setSourceAnchor((Object)EcoreUtil.copy((EObject)edge.getSourceAnchor()));
        }
        if (souceIsExternal && edge.getTargetAnchor() != null) {
            createEdgeCommand.setTargetAnchor((Object)EcoreUtil.copy((EObject)edge.getTargetAnchor()));
        }
        LineConstraint copyLine = (LineConstraint)NotationFactory.eINSTANCE.create(edge.getLine().eClass());
        createEdgeCommand.setLine((Object)copyLine);
        command.append(createEdgeCommand.createTransactionalCommand(domain));
        return copyEdge;
    }

    private DiagramElement decideOwningElement(DiagramElement element) {
        return this.getDiagram();
    }

    private void appendCopySignalsCommand(CompoundCommand command, TransactionalEditingDomain domain, net.astah.notation.Edge edge, net.astah.notation.Edge copyEdge) {
        for (STAMPLabel signal : Iterables.filter((Iterable)Iterables.filter((Iterable)edge.getOwnedElements(), STAMPLabel.class), label -> this.isSignal((DiagramElement)label))) {
            STAMPLabel copySignal = (STAMPLabel)STAMPNotationFactory.eINSTANCE.create(signal.eClass());
            ECollections.setEList((EList)copySignal.getModelElements(), (List)signal.getModelElements());
            if (signal.getLocation() != null) {
                copySignal.setLocation((LocationConstraint)EcoreUtil.copy((EObject)signal.getLocation()));
            }
            AddSignalCommand addSignalCommand = this.hasModel((DiagramElement)signal, ControlAction.class) ? new AddControlActionCommand() : new AddFeedbackCommand();
            addSignalCommand.setParent((STAMPEdge)copyEdge);
            addSignalCommand.setShape((net.astah.dd.di.Shape)copySignal);
            command.append(addSignalCommand.createTransactionalCommand(domain));
            command.append((Command)new SynchronizeLabelCommand((EditingDomain)domain, copySignal));
        }
    }

    private DiagramElement getCopiedElement(DiagramElement copySource) {
        for (DiagramElement element : Iterables.filter(this.copyResults, DiagramElement.class)) {
            if (!element.getModelElements().containsAll((Collection)copySource.getModelElements())) continue;
            return element;
        }
        return null;
    }

    private Pnt2d decideLocation(DiagramElement externalEnd, DiagramElement oppositeEnd, net.astah.notation.Edge edge, boolean souceIsExternal, LayoutCalculator layoutCalculator) {
        Point secondPoint;
        Rectangle2d endBounds = Geometries.toRectangle2d((Bounds)layoutCalculator.getBounds((Object)externalEnd));
        List waypoints = layoutCalculator.getWaypoints((Object)edge, layoutCalculator.getOrigin((Object)edge));
        if (souceIsExternal) {
            Point firstPoint = (Point)waypoints.get(waypoints.size() - 1);
            secondPoint = (Point)waypoints.get(0);
        } else {
            Point firstPoint = (Point)waypoints.get(0);
            secondPoint = (Point)waypoints.get(waypoints.size() - 1);
        }
        Point center = DCFactory.eINSTANCE.createPoint(secondPoint);
        double width = STAMPComponentShapeItemProvider.OMITTED_LAYOUT.getMinWidth();
        double height = STAMPComponentShapeItemProvider.OMITTED_LAYOUT.getMinHeight();
        double distanceX = 75.0 + width / 2.0;
        double distanceY = 75.0 + height / 2.0;
        int outcode = endBounds.outcode(center.getX(), center.getY());
        if (outcode != 0) {
            if ((outcode & 1) != 0) {
                center.setX(endBounds.getMinX() - distanceX);
            } else if ((outcode & 4) != 0) {
                center.setX(endBounds.getMaxX() + distanceX);
            }
            if ((outcode & 2) != 0) {
                center.setY(endBounds.getMinY() - distanceY);
            } else if ((outcode & 8) != 0) {
                center.setY(endBounds.getMaxY() + distanceY);
            }
        }
        Pnt2d location = new Pnt2d(center.getX() - width / 2.0, center.getY() - height / 2.0);
        return location;
    }

    private void collectElements() {
        this.diagramSelections.clear();
        this.externalLinks.clear();
        this.sourceElement = null;
        this.targetElement = null;
        if (this.diagramElement instanceof STAMPEdge) {
            STAMPDiagramElement source = ((STAMPEdge)this.diagramElement).getSTAMPSource();
            STAMPDiagramElement target = ((STAMPEdge)this.diagramElement).getSTAMPTarget();
            this.sourceElement = source;
            this.targetElement = target;
            Stream<Edge> elementsByFocusedLink = Stream.concat(Stream.concat(Stream.of(source), Stream.of(target)), Stream.concat(source.getSourceEdges().stream().filter(s -> s.getTarget() == target && s.getTarget() != s.getSource()), source.getTargetEdges().stream().filter(s -> s.getSource() == target && s.getTarget() != s.getSource())));
            Stream<Edge> externalLinksToLinkEnd = Stream.concat(Stream.concat(source.getSourceEdges().stream(), target.getSourceEdges().stream()).filter(e -> this.isLink((DiagramElement)e) && this.isExternalLinkEnd(e.getTarget(), (DiagramElement)target, (DiagramElement)source)), Stream.concat(source.getTargetEdges().stream(), target.getTargetEdges().stream()).filter(e -> this.isLink((DiagramElement)e) && this.isExternalLinkEnd(e.getSource(), (DiagramElement)target, (DiagramElement)source)));
            Stream<DiagramElement> linkEndsByExternalLink = Stream.concat(Stream.concat(source.getSourceEdges().stream(), target.getSourceEdges().stream()).filter(e -> this.isLink((DiagramElement)e) && this.isExternalLinkEnd(e.getTarget(), (DiagramElement)target, (DiagramElement)source)).map(e -> e.getTarget()), Stream.concat(source.getTargetEdges().stream(), target.getTargetEdges().stream()).filter(e -> this.isLink((DiagramElement)e) && this.isExternalLinkEnd(e.getSource(), (DiagramElement)target, (DiagramElement)source)).map(e -> e.getSource()));
            this.diagramSelections.addAll(Stream.concat(elementsByFocusedLink, Stream.concat(externalLinksToLinkEnd, linkEndsByExternalLink)).distinct().sorted(EComparators.eObjectPath()).collect(Collectors.toList()));
            this.externalLinks.addAll(Stream.concat(Stream.concat(source.getSTAMPSourceEdges().stream(), target.getSTAMPSourceEdges().stream()).filter(edge -> this.isLink((DiagramElement)edge) && this.isExternalComponent(edge.getTarget(), (DiagramElement)target, (DiagramElement)source)), Stream.concat(source.getSTAMPTargetEdges().stream(), target.getSTAMPTargetEdges().stream()).filter(edge -> this.isLink((DiagramElement)edge) && this.isExternalComponent(edge.getSource(), (DiagramElement)target, (DiagramElement)source))).distinct().sorted(EComparators.eObjectPath()).collect(Collectors.toList()));
        }
    }

    private boolean hasModel(DiagramElement element, Class<?> type) {
        return DiagramElements.isModelElementPresent((DiagramElement)element, type);
    }

    private boolean isLink(DiagramElement element) {
        return this.hasModel(element, Link.class);
    }

    private boolean isLinkEnd(DiagramElement element) {
        return this.hasModel(element, LinkEnd.class);
    }

    private boolean isSignal(DiagramElement element) {
        return this.hasModel(element, Signal.class);
    }

    private boolean isComponent(DiagramElement element) {
        return this.hasModel(element, Component.class);
    }

    private boolean isExternal(DiagramElement end, DiagramElement internalSource, DiagramElement internalTarget) {
        return end != internalSource && end != internalTarget;
    }

    private boolean isExternalLinkEnd(DiagramElement end, DiagramElement internalSource, DiagramElement internalTarget) {
        return this.isLinkEnd(end) && this.isExternal(end, internalSource, internalTarget);
    }

    private boolean isExternalComponent(DiagramElement end, DiagramElement internalSource, DiagramElement internalTarget) {
        return this.isComponent(end) && this.isExternal(end, internalSource, internalTarget);
    }

    private boolean copyRelatedDiagramElements() {
        EditingDomain domain;
        Command copyCommand;
        this.copyResults = null;
        if (!this.diagramSelections.isEmpty() && (copyCommand = CopyCommand.create((EditingDomain)(domain = ModelGlobal.prjManager.getCurrentProject().doc.getDomain()), this.diagramSelections)).canExecute()) {
            copyCommand.execute();
            this.copyResults = copyCommand.getResult().stream().filter(DiagramElement.class::isInstance).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return this.copyResults != null && !this.copyResults.isEmpty();
    }

    private ControlLoop getControlLoop(HCFAnalysis hcfAnalysis) {
        EObject element = DiagramElements.getModelElement((DiagramElement)this.diagramElement);
        if (element != null && element instanceof ControlLink) {
            Optional<ControlLoop> optional = hcfAnalysis.getControlLoops().stream().filter(loop -> loop.getTargetLink() == element).findFirst();
            if (optional.isPresent()) {
                return optional.get();
            }
            return hcfAnalysis.createControlLoop();
        }
        return null;
    }
}

