/*
 * Decompiled with CFR 0.152.
 */
package net.astah.stpa.stamp.ui.control;

import java.util.Collection;
import net.astah.common.collect.Streams;
import net.astah.dd.di.Diagram;
import net.astah.emf.edit.command.Commands;
import net.astah.golf.model.IEntityStore;
import net.astah.jomt.jcontrol.OpenTableEditorCommand;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.project.Facet;
import net.astah.project.Facets;
import net.astah.project.Project;
import net.astah.project.ProjectManagerAdapter;
import net.astah.stpa.stamp.ControlStructure;
import net.astah.stpa.stamp.STAMPPlugin;
import net.astah.stpa.stamp.STPAAnalysis;
import net.astah.stpa.stamp.notation.ComponentExtractingTable;
import net.astah.stpa.stamp.notation.STAMPControlStructureDiagram;
import net.astah.stpa.stamp.notation.STAMPNotationFactory;
import net.astah.stpa.stamp.notation.edit.command.CreateSTAMPNotationRootCommand;
import net.astah.stpa.stamp.ui.control.CreateSTAMPDiagramFromPrjCommand;
import net.astah.uml.exception.IllegalModelTypeException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;

public class CreateComponentExtractingTableFromPrjCommand
extends CreateSTAMPDiagramFromPrjCommand {
    protected Diagram findSingletonDiagram(EObject selectedModel) {
        Project project = ProjectManagerAdapter.getRootProject((Notifier)selectedModel);
        return (Diagram)Facets.getFirstContent((Project)project, (String)STAMPPlugin.FACET_SYMBOLIC_NAME, ComponentExtractingTable.class, null);
    }

    protected Diagram createNewDiagram(IEntityStore doc, EObject owner) {
        EditingDomain domain = doc.getDomain();
        Project project = ProjectManagerAdapter.getRootProject((Notifier)owner);
        Facet facet = project.getFacet(STAMPPlugin.FACET_SYMBOLIC_NAME);
        STPAAnalysis analysis = (STPAAnalysis)facet.getContents().get(0);
        STAMPControlStructureDiagram relationDiagram = Streams.stream((Collection)facet.getContents(), STAMPControlStructureDiagram.class).filter(d -> d.getComponentExtractingTable() == null).findFirst().orElse(null);
        BasicEList components = new BasicEList();
        EList controlStructures = analysis.getControlStructures();
        for (ControlStructure controlStructure : controlStructures) {
            components.addAll((Collection)controlStructure.getComponents());
        }
        ComponentExtractingTable table = STAMPNotationFactory.eINSTANCE.createComponentExtractingTable();
        Commands.execute((Command)new CreateSTAMPNotationRootCommand(domain, facet, owner, (EObject)table));
        table.setControlStructureDiagram(relationDiagram);
        table.setScope(analysis);
        return table;
    }

    protected void setDiagramName(IEntityStore doc, Diagram diagram) {
        diagram.setName(PropertyManager.getProjectViewResourceBundle().getString("uml.component_extracting_table.label"));
    }

    protected String getNameString() {
        throw new UnsupportedOperationException();
    }

    protected void doPostProcessing() throws IllegalModelTypeException {
    }

    protected net.astah.golf.control.Command createOpenEditorCommand(Diagram diagram) {
        OpenTableEditorCommand command = new OpenTableEditorCommand();
        command.setModel((Object)diagram);
        return command;
    }
}

